/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.AdventureChatComponentArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ChatComponentArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentChatComponentTests
extends TestBase {
    final String json = "[\"%s\"]".formatted("[\"\", {\n    \"text\": \"Once upon a time, there was a guy \"\n}, {\n    \"text\": \"Skepter\",\n    \"color\": \"light_purple\",\n    \"hoverEvent\": {\n        \"action\": \"show_entity\",\n        \"value\": \"Skepter\"\n    }\n}, {\n    \"text\": \" and he created the \"\n}, {\n    \"text\": \"CommandAPI\",\n    \"underlined\": true,\n    \"clickEvent\": {\n        \"action\": \"open_url\",\n        \"value\": \"https://github.com/JorelAli/CommandAPI\"\n    }\n}]\n".stripIndent().replace("\n", "").replace("\r", "").replace("\"", "\\\""));

    ArgumentChatComponentTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithSpigotChatComponentArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatComponentArgument("text")})).executesPlayer((player, args) -> results.set((BaseComponent[])args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("Skepter");
        this.server.dispatchCommand((CommandSender)player2, "test " + this.json);
        Assertions.assertArrayEquals((Object[])ComponentSerializer.parse((String)this.json), (Object[])((Object[])results.get()));
        if (this.version.lessThan(MCVersion.V1_18)) {
            this.assertCommandFailsWith((CommandSender)player2, "test []", "Invalid chat component: empty at position 8: test []<--[HERE]");
        } else if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_3)) {
            this.assertCommandFailsWith((CommandSender)player2, "test []", "Invalid chat component: Not a JSON object: [] at position 8: test []<--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test []", "Invalid chat component: Invalid chat component: empty at position 8: test []<--[HERE] at position 8: test []<--[HERE]");
        }
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_3)) {
            this.assertCommandFailsWith((CommandSender)player2, "test [\"[\"\",{\"text\":\"Some text with bad quote escaping\"}\"]", "Invalid chat component: Unterminated array at line 1 column 6 path $[1] at position 11: ...est [\"[\"\",<--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test [\"[\"\",{\"text\":\"Some text with bad quote escaping\"}\"]", "Invalid chat component: Unterminated array at line 1 column 6 path $[1] at position 5: test <--[HERE]");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithAdventureChatComponentArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatComponentArgument("text")})).executesPlayer((player, args) -> results.set((Component)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("Skepter");
        this.server.dispatchCommand((CommandSender)player2, "test " + this.json);
        Assertions.assertEquals((Object)GsonComponentSerializer.gson().deserialize((Object)this.json), results.get());
        if (this.version.lessThan(MCVersion.V1_18)) {
            this.assertCommandFailsWith((CommandSender)player2, "test []", "Invalid chat component: empty at position 8: test []<--[HERE]");
        } else if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_3)) {
            this.assertCommandFailsWith((CommandSender)player2, "test []", "Invalid chat component: Not a JSON object: [] at position 8: test []<--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test []", "Invalid chat component: Invalid chat component: empty at position 8: test []<--[HERE] at position 8: test []<--[HERE]");
        }
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_3)) {
            this.assertCommandFailsWith((CommandSender)player2, "test [\"[\"\",{\"text\":\"Some text with bad quote escaping\"}\"]", "Invalid chat component: Unterminated array at line 1 column 6 path $[1] at position 11: ...est [\"[\"\",<--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test [\"[\"\",{\"text\":\"Some text with bad quote escaping\"}\"]", "Invalid chat component: Unterminated array at line 1 column 6 path $[1] at position 5: test <--[HERE]");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithSpigotChatComponentArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatComponentArgument("text")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test ["));
    }

    @Test
    void suggestionTestWithAdventureChatComponentArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatComponentArgument("text")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test ["));
    }
}

