/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ChatColorArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentChatColorTests
extends TestBase {
    ArgumentChatColorTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithChatColorArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatColorArgument("color")})).executesPlayer((player, args) -> results.set((ChatColor)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        int numberOfColors = 0;
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        for (int i = 0; i < n; ++i) {
            ChatColor color = chatColorArray[i];
            if (!color.isColor()) continue;
            this.server.dispatchCommand((CommandSender)player2, "test " + color.name().toLowerCase());
            Assertions.assertEquals((Object)color, results.get());
            ++numberOfColors;
        }
        Assertions.assertEquals((int)16, (int)numberOfColors);
        this.server.dispatchCommand((CommandSender)player2, "test reset");
        Assertions.assertEquals((Object)ChatColor.RESET, results.get());
        for (ChatColor color : ChatColor.values()) {
            if (!color.isFormat() || color.equals((Object)ChatColor.RESET)) continue;
            String colorName = color.name().toLowerCase();
            if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
                String command = "test " + colorName;
                int errorPosition = command.length();
                String truncatedCommand = command.length() > 10 ? "..." + command.substring(command.length() - 10, command.length()) : command;
                this.assertCommandFailsWith((CommandSender)player2, command, String.format("Unknown color '%s' at position %d: %s<--[HERE]", colorName, errorPosition, truncatedCommand));
                continue;
            }
            this.assertCommandFailsWith((CommandSender)player2, "test " + colorName, "Unknown color '" + colorName + "'");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithChatColorArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatColorArgument("color")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("dark_aqua", "dark_blue", "dark_gray", "dark_green", "dark_purple", "dark_red"), this.server.getSuggestions((CommandSender)player, "test d"));
    }
}

