/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.AxisArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.EnumSet;
import java.util.List;
import org.bukkit.Axis;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentAxisTests
extends TestBase {
    ArgumentAxisTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithAxisArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AxisArgument("axes")})).executesPlayer((player, args) -> results.set((EnumSet)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test x");
        Assertions.assertEquals(EnumSet.of(Axis.X), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test xy");
        Assertions.assertEquals(EnumSet.of(Axis.X, Axis.Y), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test xyz");
        Assertions.assertEquals(EnumSet.of(Axis.X, Axis.Y, Axis.Z), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test zyx");
        Assertions.assertEquals(EnumSet.of(Axis.X, Axis.Y, Axis.Z), results.get());
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_20_5)) {
            this.assertCommandFailsWith((CommandSender)player2, "test w", "Invalid swizzle, expected combination of 'x', 'y' and 'z' at position 6: test w<--[HERE]");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test w", "Invalid swizzle, expected combination of 'x', 'y' and 'z'");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithAxisArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AxisArgument("axis")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test x"));
    }
}

