/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.AngleArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentAngleTests
extends TestBase {
    ArgumentAngleTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private void setPlayerYaw(PlayerMock player, float yaw) {
        Location location = player.getLocation();
        location.setYaw(yaw);
        player.setLocation(location);
    }

    @Test
    void executionTestWithAngleArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AngleArgument("angle")})).executesPlayer((player, args) -> results.set((Float)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 10");
        Assertions.assertEquals((double)10.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.server.dispatchCommand((CommandSender)player2, "test -180");
        Assertions.assertEquals((double)-180.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.server.dispatchCommand((CommandSender)player2, "test 180");
        Assertions.assertEquals((double)-180.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithAngleArgumentRelative() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AngleArgument("angle")})).executesPlayer((player, args) -> results.set((Float)args.getUnchecked(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.setPlayerYaw(player2, 0.0f);
        this.server.dispatchCommand((CommandSender)player2, "test ~");
        Assertions.assertEquals((double)0.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.setPlayerYaw(player2, 90.0f);
        this.server.dispatchCommand((CommandSender)player2, "test ~");
        Assertions.assertEquals((double)90.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.setPlayerYaw(player2, 180.0f);
        this.server.dispatchCommand((CommandSender)player2, "test ~");
        Assertions.assertEquals((double)-180.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.setPlayerYaw(player2, 270.0f);
        this.server.dispatchCommand((CommandSender)player2, "test ~");
        Assertions.assertEquals((double)-90.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.setPlayerYaw(player2, 360.0f);
        this.server.dispatchCommand((CommandSender)player2, "test ~");
        Assertions.assertEquals((double)0.0, (double)((Float)results.get()).floatValue(), (double)0.1);
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithAngleArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AngleArgument("angle")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

