/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.entity.PlayerMock;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.lang.reflect.Method;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class OnEnableTests
extends TestBase {
    OnEnableTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testOnEnableExecution() {
        Assertions.assertDoesNotThrow(() -> this.enableServer());
    }

    @Test
    void testOnEnableRegisterAndUnregisterCommand() {
        this.enableServer();
        PlayerMock updateCommandsPlayer = (PlayerMock)Mockito.spy((Object)new PlayerMock((ServerMock)this.server, "updateCommandsPlayer"));
        ((PlayerMock)Mockito.doNothing().when((Object)updateCommandsPlayer)).updateCommands();
        this.server.addPlayer(updateCommandsPlayer);
        Player runCommandsPlayer = (Player)Mockito.mock((Class)MockPlatform.getInstance().getCraftPlayerClass());
        Mockito.when((Object)runCommandsPlayer.hasPermission((String)ArgumentMatchers.eq((Object)"permission"))).thenReturn((Object)true);
        Mockito.when((Object)runCommandsPlayer.getLocation()).thenReturn((Object)new Location(null, 0.0, 0.0, 0.0));
        Method getHandle = (Method)Assertions.assertDoesNotThrow(() -> runCommandsPlayer.getClass().getDeclaredMethod("getHandle", new Class[0]));
        Object brigadierSource = Brigadier.getBrigadierSourceFromCommandSender((Object)runCommandsPlayer);
        Object handle = Mockito.mock(getHandle.getReturnType(), invocation -> brigadierSource);
        Assertions.assertDoesNotThrow(() -> getHandle.invoke((Object)runCommandsPlayer, new Object[0]));
        Mockito.when(null).thenReturn(handle);
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("command").withArguments((AbstractArgument[])new Argument[]{new StringArgument("argument")})).withAliases(new String[]{"alias1", "alias2"})).withPermission("permission")).withHelp("short description", "full description")).executes((sender, args) -> results.set((String)args.getUnchecked(0)), new ExecutorType[0])).register();
        ((PlayerMock)Mockito.verify((Object)updateCommandsPlayer, (VerificationMode)Mockito.times((int)1))).updateCommands();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"command\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"argument\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    },\n    \"alias1\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"argument\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    },\n    \"alias2\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"argument\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
        SimpleCommandMap commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
        Command mainCommand = commandMap.getCommand("command");
        Assertions.assertNotNull((Object)mainCommand);
        Assertions.assertTrue((boolean)CommandAPIBukkit.get().isVanillaCommandWrapper(mainCommand));
        Command alias1Command = commandMap.getCommand("alias1");
        Assertions.assertNotNull((Object)alias1Command);
        Assertions.assertTrue((boolean)CommandAPIBukkit.get().isVanillaCommandWrapper(alias1Command));
        Command alias2Command = commandMap.getCommand("alias2");
        Assertions.assertNotNull((Object)alias2Command);
        Assertions.assertTrue((boolean)CommandAPIBukkit.get().isVanillaCommandWrapper(alias2Command));
        Assertions.assertEquals((Object)mainCommand, (Object)commandMap.getCommand("minecraft:command"));
        Assertions.assertEquals((Object)alias1Command, (Object)commandMap.getCommand("minecraft:alias1"));
        Assertions.assertEquals((Object)alias2Command, (Object)commandMap.getCommand("minecraft:alias2"));
        Assertions.assertEquals((Object)"permission", (Object)mainCommand.getPermission());
        Assertions.assertEquals((Object)"permission", (Object)alias1Command.getPermission());
        Assertions.assertEquals((Object)"permission", (Object)alias2Command.getPermission());
        RootCommandNode resourcesRoot = CommandAPIBukkit.get().getResourcesDispatcher().getRoot();
        Assertions.assertNotNull((Object)resourcesRoot.getChild("command"));
        Assertions.assertNotNull((Object)resourcesRoot.getChild("alias1"));
        Assertions.assertNotNull((Object)resourcesRoot.getChild("alias2"));
        Assertions.assertNotNull((Object)resourcesRoot.getChild("minecraft:command"));
        Assertions.assertNotNull((Object)resourcesRoot.getChild("minecraft:alias1"));
        Assertions.assertNotNull((Object)resourcesRoot.getChild("minecraft:alias2"));
        HelpTopic topic = this.server.getHelpMap().getHelpTopic("/command");
        Assertions.assertNotNull((Object)topic);
        Assertions.assertEquals((Object)"short description", (Object)topic.getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"short description\n&6Description: &ffull description\n&6Usage: &f/command <argument>\n&6Aliases: &falias1, alias2"), (Object)topic.getFullText(null));
        this.assertStoresResult((CommandSender)runCommandsPlayer, "command argument", results, "argument");
        this.assertStoresResult((CommandSender)runCommandsPlayer, "alias1 argument", results, "argument");
        this.assertStoresResult((CommandSender)runCommandsPlayer, "alias2 argument", results, "argument");
        this.assertStoresResult((CommandSender)runCommandsPlayer, "minecraft:command argument", results, "argument");
        this.assertStoresResult((CommandSender)runCommandsPlayer, "minecraft:alias1 argument", results, "argument");
        this.assertStoresResult((CommandSender)runCommandsPlayer, "minecraft:alias2 argument", results, "argument");
        CommandAPI.unregister((String)"command");
        ((PlayerMock)Mockito.verify((Object)updateCommandsPlayer, (VerificationMode)Mockito.times((int)2))).updateCommands();
        Assertions.assertEquals((Object)"{\n  \"type\": \"root\",\n  \"children\": {\n    \"alias1\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"argument\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    },\n    \"alias2\": {\n      \"type\": \"literal\",\n      \"children\": {\n        \"argument\": {\n          \"type\": \"argument\",\n          \"parser\": \"brigadier:string\",\n          \"properties\": {\n            \"type\": \"word\"\n          },\n          \"executable\": true\n        }\n      }\n    }\n  }\n}", (Object)this.getDispatcherString());
        Assertions.assertNull((Object)commandMap.getCommand("command"));
        Assertions.assertEquals((Object)mainCommand, (Object)commandMap.getCommand("minecraft:command"));
        Assertions.assertNull((Object)resourcesRoot.getChild("command"));
        Assertions.assertNotNull((Object)resourcesRoot.getChild("minecraft:command"));
        Assertions.assertNull((Object)this.server.getHelpMap().getHelpTopic("/command"));
        this.assertCommandFailsWith((CommandSender)runCommandsPlayer, "command argument", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        CommandAPI.unregister((String)"command", (boolean)true);
        ((PlayerMock)Mockito.verify((Object)updateCommandsPlayer, (VerificationMode)Mockito.times((int)3))).updateCommands();
        Assertions.assertNull((Object)commandMap.getCommand("minecraft:command"));
        Assertions.assertNull((Object)resourcesRoot.getChild("minecraft:command"));
        this.assertCommandFailsWith((CommandSender)runCommandsPlayer, "minecraft:command argument", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }
}

