/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.AbstractArgumentTree;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandTree;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.LiteralArgument;
import dev.jorel.commandapi.arguments.MultiLiteralArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommandHelpTests
extends TestBase {
    CommandHelpTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private void assertHelpTopicCreated(String name, String shortDescription, String fullDescription, CommandSender forWho) {
        HelpTopic helpTopic = this.server.getHelpMap().getHelpTopic(name);
        Assertions.assertNotNull((Object)helpTopic, (String)("Expected to find help topic called <" + name + ">, but null was found."));
        Assertions.assertEquals((Object)shortDescription, (Object)helpTopic.getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)fullDescription), (Object)helpTopic.getFullText(forWho));
    }

    @Test
    void testRegisterCommandWithHelp() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "short description", "short description\n&6Description: &ffull description\n&6Usage: &f/test", (CommandSender)player);
    }

    @Test
    void testRegisterCommandWithShortDescription() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withShortDescription("short description")).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "short description", "short description\n&6Usage: &f/test", (CommandSender)player);
    }

    @Test
    void testRegisterCommandFullDescription() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withFullDescription("full description")).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "full description", "full description\n&6Description: &ffull description\n&6Usage: &f/test", (CommandSender)player);
    }

    @Test
    void testRegisterCommandNoDescription() {
        ((CommandAPICommand)new CommandAPICommand("test").executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "A command by the CommandAPITest plugin.", "A command by the CommandAPITest plugin.\n&6Usage: &f/test", (CommandSender)player);
    }

    @Test
    void testRegisterWithRemovedUsage() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withUsage(new String[0])).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "A command by the CommandAPITest plugin.", "A command by the CommandAPITest plugin.\n", (CommandSender)player);
    }

    @Test
    void testRegisterWithOneUsage() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withUsage(new String[]{"Line one"})).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "A command by the CommandAPITest plugin.", "A command by the CommandAPITest plugin.\n&6Usage: &fLine one", (CommandSender)player);
    }

    @Test
    void testRegisterWithMultipleUsage() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withUsage(new String[]{"Line one", "Line two", "Line three"})).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "A command by the CommandAPITest plugin.", "A command by the CommandAPITest plugin.\n&6Usage: &f\n- Line one\n- Line two\n- Line three", (CommandSender)player);
    }

    @Test
    void testRegisterCommandWithHelpWithAliases() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withAliases(new String[]{"othertest", "othercommand"})).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "short description", "short description\n&6Description: &ffull description\n&6Usage: &f/test\n&6Aliases: &fothertest, othercommand", (CommandSender)player);
        this.assertHelpTopicCreated("/othertest", "short description", "short description\n&6Description: &ffull description\n&6Usage: &f/test\n&6Aliases: &fothercommand, test", (CommandSender)player);
        this.assertHelpTopicCreated("/othercommand", "short description", "short description\n&6Description: &ffull description\n&6Usage: &f/test\n&6Aliases: &fothertest, test", (CommandSender)player);
    }

    @Test
    void testRegisterCommandWithMultipleArguments() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("arg2")})).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "short description", "short description\n&6Description: &ffull description\n&6Usage: &f/test <arg1> <arg2>", (CommandSender)player);
    }

    @Test
    void testRegisterMultipleCommands() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).executesPlayer(P_EXEC)).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("arg2")})).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "short description", "short description\n&6Description: &ffull description\n&6Usage: &f\n- /test <arg1>\n- /test <arg1> <arg2>", (CommandSender)player);
    }

    @Test
    void testRegisterDeepBranches() {
        ((CommandTree)((CommandTree)new CommandTree("test").then(((Argument)new LiteralArgument("branch1").then((AbstractArgumentTree)new StringArgument("string1").executesPlayer(P_EXEC))).then((AbstractArgumentTree)new IntegerArgument("integer1").executesPlayer(P_EXEC)))).then(((Argument)((Argument)new LiteralArgument("branch2").executesPlayer(P_EXEC)).then((AbstractArgumentTree)new StringArgument("string2").executesPlayer(P_EXEC))).then(new IntegerArgument("integer2").then((AbstractArgumentTree)new LiteralArgument("continue").executesPlayer(P_EXEC))))).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "A command by the CommandAPITest plugin.", "A command by the CommandAPITest plugin.\n&6Usage: &f\n- /test branch1 <string1>\n- /test branch1 <integer1>\n- /test branch2\n- /test branch2 <string2>\n- /test branch2 <integer2> continue", (CommandSender)player);
    }

    @Test
    void testRegisterLiteralArguments() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MultiLiteralArgument("multiLiteral", new String[]{"a", "b", "c"}), new LiteralArgument("literal", "d"), new StringArgument("string")})).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "A command by the CommandAPITest plugin.", "A command by the CommandAPITest plugin.\n&6Usage: &f\n- /test a d <string>\n- /test b d <string>\n- /test c d <string>", (CommandSender)player);
    }

    @Test
    void testRegisterCustomHelpTopic() {
        ((CommandAPICommand)new CommandAPICommand("test").withHelp(new HelpTopic(){
            {
                this.shortText = "short description";
            }

            public String getFullText(CommandSender forWho) {
                Object object;
                if (forWho instanceof Player) {
                    Player player = (Player)forWho;
                    object = player.getName();
                } else {
                    object = forWho;
                }
                return "Special full text just for " + String.valueOf(object);
            }

            public boolean canSee(CommandSender sender) {
                return true;
            }
        }).executesPlayer(P_EXEC)).register();
        this.enableServer();
        PlayerMock player1 = this.server.addPlayer("Player1");
        PlayerMock player2 = this.server.addPlayer("Player2");
        this.assertHelpTopicCreated("/test", "short description", "Special full text just for Player1", (CommandSender)player1);
        this.assertHelpTopicCreated("/test", "short description", "Special full text just for Player2", (CommandSender)player2);
    }

    @Test
    void testRegisterAfterServerEnabled() {
        this.enableServer();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withUsage(new String[]{"usage line"})).withAliases(new String[]{"alias"})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertHelpTopicCreated("/test", "short description", "short description\n&6Description: &ffull description\n&6Usage: &fusage line\n&6Aliases: &falias", (CommandSender)player);
        this.assertHelpTopicCreated("/alias", "short description", "short description\n&6Description: &ffull description\n&6Usage: &fusage line\n&6Aliases: &ftest", (CommandSender)player);
    }
}

