/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.DoubleArgument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CommandArgumentsTests
extends TestBase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void executionTestForRawArgumentsWithOnlyOneArgumentAndRequiredArgumentOnly() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyEntities("entities")})).executesPlayer(info -> results.set(info.args().getRaw("entities")))).register();
        PlayerMock player = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player, "test @e");
        Assertions.assertEquals((Object)"@e", results.get());
        this.server.dispatchCommand((CommandSender)player, "test @a");
        Assertions.assertEquals((Object)"@a", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestForRawArgumentsWithMultipleArgumentsAndRequiredArgumentsOnly() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("double")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("text")})).executesPlayer(info -> {
            results.set(info.args().getRaw("double"));
            results.set(info.args().getRaw("text"));
        })).register();
        PlayerMock player = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player, "test 15.34 \"This is interesting text\"");
        Assertions.assertEquals((Object)"15.34", results.get());
        Assertions.assertEquals((Object)"\"This is interesting text\"", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestForRawArgumentsWithMultipleArgumentsWithMultipleRequiredAndOneOptionalArguments() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("double")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("text")})).withOptionalArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyEntities("entities")})).executesPlayer(info -> {
            results.set(info.args().getRaw("double"));
            results.set(info.args().getRaw("text"));
            results.set(info.args().getRawOptional("entities").orElse("<no-entity-selector-given>"));
        })).register();
        PlayerMock player = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player, "test 15.34 \"This is interesting text\"");
        Assertions.assertEquals((Object)"15.34", results.get());
        Assertions.assertEquals((Object)"\"This is interesting text\"", results.get());
        Assertions.assertEquals((Object)"<no-entity-selector-given>", results.get());
        this.server.dispatchCommand((CommandSender)player, "test 15.34 \"This is interesting text\" @e");
        Assertions.assertEquals((Object)"15.34", results.get());
        Assertions.assertEquals((Object)"\"This is interesting text\"", results.get());
        Assertions.assertEquals((Object)"@e", results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestForRawArgumentsWithMultipleArgumentsWithMultipleRequiredAndMultipleOptionalArguments() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new DoubleArgument("double")})).withArguments((AbstractArgument[])new Argument[]{new TextArgument("text")})).withOptionalArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyEntities("entities")})).withOptionalArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executesPlayer(info -> {
            results.set(info.args().getRaw("double"));
            results.set(info.args().getRaw("text"));
            results.set(info.args().getRawOptional("entities").orElse("<no-entity-selector-given>"));
            results.set(info.args().getRawOptional("message").orElse("<no-message-given>"));
        })).register();
        PlayerMock player = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player, "test 15.34 \"This is interesting text\"");
        Assertions.assertEquals((Object)"15.34", results.get());
        Assertions.assertEquals((Object)"\"This is interesting text\"", results.get());
        Assertions.assertEquals((Object)"<no-entity-selector-given>", results.get());
        Assertions.assertEquals((Object)"<no-message-given>", results.get());
        this.server.dispatchCommand((CommandSender)player, "test 15.34 \"This is interesting text\" @e");
        Assertions.assertEquals((Object)"15.34", results.get());
        Assertions.assertEquals((Object)"\"This is interesting text\"", results.get());
        Assertions.assertEquals((Object)"@e", results.get());
        Assertions.assertEquals((Object)"<no-message-given>", results.get());
        this.server.dispatchCommand((CommandSender)player, "test 15.34 \"This is interesting text\" @e Hello, everyone! This is a test which passes and doesn't throw any error!");
        Assertions.assertEquals((Object)"15.34", results.get());
        Assertions.assertEquals((Object)"\"This is interesting text\"", results.get());
        Assertions.assertEquals((Object)"@e", results.get());
        Assertions.assertEquals((Object)"Hello, everyone! This is a test which passes and doesn't throw any error!", results.get());
        this.assertNoMoreResults(results);
    }
}

