/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.plugin.PluginManagerMock;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.test.MockPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CommandAPIServerMock
extends ServerMock {
    List<Advancement> advancements = new ArrayList<Advancement>();

    public CommandAPIServerMock() {
        PluginManagerMock pluginManagerSpy = (PluginManagerMock)Mockito.spy((Object)this.getPluginManager());
        ((PluginManagerMock)Mockito.doNothing().when((Object)pluginManagerSpy)).unsubscribeFromDefaultPerms(((Boolean)ArgumentMatchers.isA(Boolean.class)).booleanValue(), (Permissible)ArgumentMatchers.isA(Permissible.class));
        ((PluginManagerMock)Mockito.doNothing().when((Object)pluginManagerSpy)).subscribeToDefaultPerms(((Boolean)ArgumentMatchers.isA(Boolean.class)).booleanValue(), (Permissible)ArgumentMatchers.isA(Permissible.class));
        MockPlatform.setField(ServerMock.class, (String)"pluginManager", (Object)((Object)this), (Object)pluginManagerSpy);
    }

    public boolean dispatchThrowableCommand(CommandSender sender, String commandLine) throws CommandSyntaxException {
        Object css;
        String[] commands = commandLine.split(" ");
        String commandLabel = commands[0];
        Command command = this.getCommandMap().getCommand(commandLabel);
        if (command != null) {
            return super.dispatchCommand(sender, commandLine);
        }
        CommandDispatcher dispatcher = Brigadier.getCommandDispatcher();
        return dispatcher.execute(commandLine, css = Brigadier.getBrigadierSourceFromCommandSender((Object)sender)) != 0;
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        try {
            return this.dispatchThrowableCommand(sender, commandLine);
        }
        catch (CommandSyntaxException e) {
            Assertions.fail((String)("Command '/" + commandLine + "' failed. If you expected this to fail, use dispatchThrowableCommand() instead."), (Throwable)e);
            return false;
        }
    }

    public int dispatchBrigadierCommand(CommandSender sender, String commandLine) {
        try {
            return this.dispatchThrowableBrigadierCommand(sender, commandLine);
        }
        catch (CommandSyntaxException e) {
            Assertions.fail((String)("Command '/" + commandLine + "' failed. If you expected this to fail, use dispatchThrowableBrigadierCommand() instead."), (Throwable)e);
            return 0;
        }
    }

    public int dispatchThrowableBrigadierCommand(CommandSender sender, String commandLine) throws CommandSyntaxException {
        CommandDispatcher dispatcher = Brigadier.getCommandDispatcher();
        Object css = Brigadier.getBrigadierSourceFromCommandSender((Object)sender);
        return dispatcher.execute(commandLine, css);
    }

    public List<String> getSuggestions(CommandSender sender, String commandLine) {
        CommandDispatcher dispatcher = Brigadier.getCommandDispatcher();
        Object css = Brigadier.getBrigadierSourceFromCommandSender((Object)sender);
        ParseResults parseResults = dispatcher.parse(commandLine, css);
        Suggestions suggestions = null;
        try {
            suggestions = (Suggestions)dispatcher.getCompletionSuggestions(parseResults).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            suggestions = new Suggestions(StringRange.at((int)0), new ArrayList());
        }
        ArrayList<String> suggestionsAsStrings = new ArrayList<String>();
        for (Suggestion suggestion : suggestions.getList()) {
            suggestionsAsStrings.add(suggestion.getText());
        }
        return suggestionsAsStrings;
    }

    public List<Suggestion> getSuggestionsWithTooltips(CommandSender sender, String commandLine) {
        CommandDispatcher dispatcher = Brigadier.getCommandDispatcher();
        Object css = Brigadier.getBrigadierSourceFromCommandSender((Object)sender);
        ParseResults parseResults = dispatcher.parse(commandLine, css);
        Suggestions suggestions = null;
        try {
            suggestions = (Suggestions)dispatcher.getCompletionSuggestions(parseResults).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            suggestions = new Suggestions(StringRange.at((int)0), new ArrayList());
        }
        ArrayList<Suggestion> suggestionsList = new ArrayList<Suggestion>();
        for (Suggestion suggestion : suggestions.getList()) {
            suggestionsList.add(suggestion);
        }
        return suggestionsList;
    }

    public boolean shouldSendChatPreviews() {
        return true;
    }

    @Nullable
    public <T extends Keyed> Registry<T> getRegistry(@NotNull Class<T> tClass) {
        return MockPlatform.getInstance().getRegistry(tClass);
    }

    public WorldMock addSimpleWorld(String name) {
        CustomWorldMock world = new CustomWorldMock();
        world.setName(name);
        super.addWorld((WorldMock)world);
        return world;
    }

    public void addAdvancement(NamespacedKey key) {
        this.advancements.add(MockPlatform.getInstance().addAdvancement(key));
    }

    public void addAdvancements(Collection<NamespacedKey> key) {
        key.forEach(this::addAdvancement);
    }

    public Iterator<Advancement> advancementIterator() {
        return this.advancements.iterator();
    }

    static class CustomWorldMock
    extends WorldMock {
        CustomWorldMock() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof World) {
                World target = (World)obj;
                return this.getUID().equals(target.getUID());
            }
            return false;
        }
    }
}

