/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.TimeArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentTimeTests
extends TestBase {
    ArgumentTimeTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithTimeArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new TimeArgument("time")})).executesPlayer((player, args) -> results.set(Integer.valueOf((Integer)args.get(0))))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 120");
        Assertions.assertEquals((int)120, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 120t");
        Assertions.assertEquals((int)120, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 120s");
        Assertions.assertEquals((int)2400, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 0.82s");
        Assertions.assertEquals((int)16, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test .5d");
        Assertions.assertEquals((int)12000, (Integer)((Integer)results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test 0");
        Assertions.assertEquals((int)0, (Integer)((Integer)results.get()));
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_19_4)) {
            this.assertCommandFailsWith((CommandSender)player2, "test -2", "Tick count must not be less than 0, found -2");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test -2", "Tick count must be non-negative");
        }
        this.assertCommandFailsWith((CommandSender)player2, "test 2x", "Invalid unit");
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithTimeArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new TimeArgument("color")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of("d", "s", "t"), this.server.getSuggestions((CommandSender)player, "test 1"));
    }
}

