/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.PotionEffectArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Arrays;
import org.bukkit.command.CommandSender;
import org.bukkit.potion.PotionEffectType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentPotionTests
extends TestBase {
    ArgumentPotionTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithPotionEffectArgumentWithNamespaces() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new PotionEffectArgument("potion")})).executesPlayer((player, args) -> results.set((PotionEffectType)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test speed");
        Assertions.assertEquals((Object)PotionEffectType.SPEED, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:speed");
        Assertions.assertEquals((Object)PotionEffectType.SPEED, results.get());
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_19_4)) {
            this.assertCommandFailsWith((CommandSender)player2, "test bukkit:speed", "Can't find element 'bukkit:speed' of type 'minecraft:mob_effect'");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test bukkit:speed", "Unknown effect: bukkit:speed");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithPotionEffectArgumentAllPotionEffects() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new PotionEffectArgument("potion")})).executesPlayer((player, args) -> results.set((PotionEffectType)args.get("potion")))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (PotionEffectType potionEffect : MockPlatform.getInstance().getPotionEffects()) {
            this.server.dispatchCommand((CommandSender)player2, "test " + MockPlatform.getInstance().getBukkitPotionEffectTypeName(potionEffect));
            Assertions.assertEquals((Object)potionEffect, results.get());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithPotionEffectArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new PotionEffectArgument("potion")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getPotionEffects()).map(arg_0 -> ((MockPlatform)MockPlatform.getInstance()).getBukkitPotionEffectTypeName(arg_0)).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test minecraft:"));
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getPotionEffects()).map(arg_0 -> ((MockPlatform)MockPlatform.getInstance()).getBukkitPotionEffectTypeName(arg_0)).filter(s -> s.startsWith("minecraft:s")).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test minecraft:s"));
        Assertions.assertEquals(Arrays.stream(MockPlatform.getInstance().getPotionEffects()).map(arg_0 -> ((MockPlatform)MockPlatform.getInstance()).getBukkitPotionEffectTypeName(arg_0)).filter(s -> s.startsWith("minecraft:s")).sorted().toList(), this.server.getSuggestions((CommandSender)player, "test s"));
    }
}

