/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ParticleArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.ParticleData;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Snowable;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

class ArgumentParticleTests
extends TestBase {
    private Set<Particle> dodgyParticles = Set.of(Particle.SNOW_SHOVEL, Particle.SUSPENDED_DEPTH);

    ArgumentParticleTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private float round(float value, int n) {
        return (float)((double)Math.round((double)value * Math.pow(10.0, n)) / Math.pow(10.0, n));
    }

    @Test
    void executionTestWithParticleArgumentVoid() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (Particle particle : Particle.values()) {
            if (!particle.getDataType().equals(Void.class) || this.dodgyParticles.contains(particle)) continue;
            this.server.dispatchCommand((CommandSender)player2, "test " + MockPlatform.getInstance().getNMSParticleNameFromBukkit(particle));
            Assertions.assertEquals((Object)particle, (Object)((ParticleData)results.get()).particle());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentDust() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test dust 1 0.5 0 4");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.REDSTONE, (Object)result.particle());
        Assertions.assertEquals((float)4.0f, (float)((Particle.DustOptions)result.data()).getSize());
        Assertions.assertEquals((Object)Color.fromRGB((int)255, (int)127, (int)0), (Object)((Particle.DustOptions)result.data()).getColor());
        this.assertNoMoreResults(results);
    }

    @RepeatedTest(value=10)
    void executionTestWithParticleArgumentDustRandom() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        float red = this.round(ThreadLocalRandom.current().nextFloat(), 2);
        float green = this.round(ThreadLocalRandom.current().nextFloat(), 2);
        float blue = this.round(ThreadLocalRandom.current().nextFloat(), 2);
        int size = ThreadLocalRandom.current().nextInt(1, 5);
        this.server.dispatchCommand((CommandSender)player2, "test dust %s %s %s %d".formatted(Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue), size));
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.REDSTONE, (Object)result.particle());
        Assertions.assertEquals((float)size, (float)((Particle.DustOptions)result.data()).getSize());
        Assertions.assertEquals((Object)Color.fromRGB((int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f))), (Object)((Particle.DustOptions)result.data()).getColor());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentBlock() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test block minecraft:grass_block[snowy=true]");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.BLOCK_CRACK, (Object)result.particle());
        Assertions.assertEquals((Object)Material.GRASS_BLOCK, (Object)((BlockData)result.data()).getMaterial());
        Assertions.assertTrue((boolean)((Snowable)result.data()).isSnowy());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithParticleArgumentItem() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ParticleArgument("particle")})).executesPlayer((player, args) -> results.set((ParticleData)args.get("particle")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test item apple");
        ParticleData result = (ParticleData)results.get();
        Assertions.assertEquals((Object)Particle.ITEM_CRACK, (Object)result.particle());
        Assertions.assertEquals((Object)new ItemStack(Material.APPLE), (Object)((ItemStack)result.data()));
        this.assertNoMoreResults(results);
    }
}

