/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import de.tr7zw.changeme.nbtapi.NBTContainer;
import de.tr7zw.changeme.nbtapi.utils.MinecraftVersion;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.CommandAPIVersionHandler;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.NBTCompoundArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentNBTCompoundTests
extends TestBase {
    ArgumentNBTCompoundTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        Assumptions.assumeTrue((!CommandAPIVersionHandler.IS_MOJANG_MAPPED ? 1 : 0) != 0);
        Assumptions.assumeTrue((boolean)this.version.lessThan(MCVersion.V1_20));
        super.setUp();
        MinecraftVersion.disableBStats();
        MinecraftVersion.disablePackageWarning();
        MinecraftVersion.disableUpdateCheck();
        MinecraftVersion currentNBTAPIMinecraftVersion = switch (this.version) {
            case MCVersion.V1_16_5 -> MinecraftVersion.MC1_16_R3;
            case MCVersion.V1_17 -> MinecraftVersion.MC1_17_R1;
            case MCVersion.V1_18 -> MinecraftVersion.MC1_18_R1;
            case MCVersion.V1_19_2 -> MinecraftVersion.MC1_19_R1;
            case MCVersion.V1_19_4 -> MinecraftVersion.MC1_19_R3;
            default -> throw new IllegalArgumentException("Unexpected value: " + this.version);
        };
        MockPlatform.setField(MinecraftVersion.class, (String)"version", null, (Object)currentNBTAPIMinecraftVersion);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithNBTCompoundArgumentEmpty() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {}");
        Assertions.assertEquals((Object)new NBTContainer().getCompound(), (Object)((NBTContainer)results.get()).getCompound());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentBoolean() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:true}");
        Assertions.assertEquals((Object)true, (Object)((NBTContainer)results.get()).getBoolean("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:false}");
        Assertions.assertEquals((Object)false, (Object)((NBTContainer)results.get()).getBoolean("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentNumbers() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:2b}");
        Assertions.assertEquals((Byte)2, (Byte)((NBTContainer)results.get()).getByte("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:200s}");
        Assertions.assertEquals((Short)200, (Short)((NBTContainer)results.get()).getShort("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:2000000}");
        Assertions.assertEquals((Integer)2000000, (Integer)((NBTContainer)results.get()).getInteger("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:20000000000l}");
        Assertions.assertEquals((Long)20000000000L, (Long)((NBTContainer)results.get()).getLong("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:2.3f}");
        Assertions.assertEquals((Float)Float.valueOf(2.3f), (Float)((NBTContainer)results.get()).getFloat("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:2.3d}");
        Assertions.assertEquals((Double)2.3, (Double)((NBTContainer)results.get()).getDouble("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentNumberArrays() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:[B;2b,3b,4b]}");
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])((NBTContainer)results.get()).getByteArray("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:[I;200,300,400]}");
        Assertions.assertArrayEquals((int[])new int[]{200, 300, 400}, (int[])((NBTContainer)results.get()).getIntArray("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentNumberLists() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:[200,300,400]}");
        Assertions.assertEquals(List.of(Integer.valueOf(200), Integer.valueOf(300), Integer.valueOf(400)), (Object)((NBTContainer)results.get()).getIntegerList("val"));
        this.server.dispatchCommand((CommandSender)player2, "test {val:[3000000000l,4000000000l,5000000000l]}");
        Assertions.assertEquals(List.of(Long.valueOf(3000000000L), Long.valueOf(4000000000L), Long.valueOf(5000000000L)), (Object)((NBTContainer)results.get()).getLongList("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentStrings() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val:\"Hello, world!\"}");
        Assertions.assertEquals((Object)"Hello, world!", (Object)((NBTContainer)results.get()).getString("val"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentCompound() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val1:{val2:2}}");
        Assertions.assertEquals((int)2, (Integer)((NBTContainer)results.get()).getCompound("val1").getInteger("val2"));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithNBTCompoundArgumentMultiple() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer((player, args) -> results.set((NBTContainer)args.get("nbt")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test {val1:10,val2:20}");
        NBTContainer result = (NBTContainer)results.get();
        Assertions.assertEquals((int)10, (Integer)result.getInteger("val1"));
        Assertions.assertEquals((int)20, (Integer)result.getInteger("val2"));
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithNBTCompoundArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new NBTCompoundArgument("nbt")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test {"));
    }
}

