/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.MapArgumentBuilder;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.LinkedHashMap;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;

public class ArgumentMapTests
extends TestBase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void executionTestWithMapArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':').withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test map:\"cool map\"");
        LinkedHashMap<String, String> testMap = new LinkedHashMap<String, String>();
        testMap.put("map", "cool map");
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test map:\"cool map\" foo:\"bar\"");
        testMap.put("foo", "bar");
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test map:\"cool map\" foo:\"bar\" test:\"Test value\"");
        testMap.put("test", "Test value");
        Assertions.assertEquals(testMap, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test map:\"cool map\" map:\"bar\"", "Could not parse command: Duplicate keys are not allowed at position 19: ...l map\" map<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test map:", "Could not parse command: Quotation mark required after writing the delimiter at position 4: map:<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test map", "Could not parse command: Delimiter required after writing a key at position 3: map<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test map:\"", "Could not parse command: Value required after opening quotation mark at position 5: map:\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test map:\"this\" otherMap:\"this\"", "Could not parse command: Duplicate values are not allowed here at position 26: ...rMap:\"this<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestWithMapArgumentAndSpecialValues() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':').withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test map:\"\\\"hello\\\"\"");
        LinkedHashMap<String, String> testMap = new LinkedHashMap<String, String>();
        testMap.put("map", "\"hello\"");
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test map:\"\\\\hello\\\\\"");
        testMap.clear();
        testMap.put("map", "\\hello\\");
        Assertions.assertEquals(testMap, results.get());
        this.assertNoMoreResults(results);
    }

    @RepeatedTest(value=10)
    public void executionTestWithMapArgumentAndPlayerNameKeys() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':').withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        String possibleChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        StringBuilder playerNameBuilder = new StringBuilder();
        for (int i = 0; i < ThreadLocalRandom.current().nextInt(3, 17); ++i) {
            playerNameBuilder.append(possibleChars.charAt(ThreadLocalRandom.current().nextInt(0, possibleChars.length())));
        }
        String playerName = playerNameBuilder.toString();
        this.server.dispatchCommand((CommandSender)player2, "test " + playerName + ":\"value\"");
        LinkedHashMap<String, String> testMap = new LinkedHashMap<String, String>();
        testMap.put(playerName, "value");
        Assertions.assertEquals(testMap, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    public void exceptionTestWithMapArgument() {
        Assertions.assertThrows(GreedyArgumentException.class, () -> ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", '=').withKeyMapper(s -> s).withValueMapper(Integer::valueOf).withoutKeyList().withoutValueList().build()})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("string")})).executesPlayer(P_EXEC)).register());
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map", ':').withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandFailsWith((CommandSender)player, "test map=\"test1\"", "Could not parse command: A key must only contain letters from a-z and A-Z, numbers, underscores and periods at position 4: map=<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test map\"test1\"", "Could not parse command: You must separate a key/value pair with a ':' at position 4: map\"<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test map:\"test1", "Could not parse command: A value must end with a quotation mark at position 10: map:\"test1<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test map:5", "Could not parse command: A value must start with a quotation mark at position 4: map:<--[HERE]");
    }

    @Test
    public void executionTestWithOtherKeyValuePairs() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(Integer::valueOf).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test map:\"598\"");
        LinkedHashMap<String, Integer> testMap = new LinkedHashMap<String, Integer>();
        testMap.put("map", 598);
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test map:\"598\" age:\"18\"");
        testMap.put("age", 18);
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test map:\"598\" age:\"18\" someThirdValue:\"19999\"");
        testMap.put("someThirdValue", 19999);
        Assertions.assertEquals(testMap, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test map:\"598\" age:\"eighteen\"", "Could not parse command: Invalid value (eighteen): cannot be converted to a value at position 24: ...\"eighteen\"<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestWithFloatKey() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(Float::valueOf).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 3.5:\"Hello World\" 12.25:\"This is a test!\"");
        LinkedHashMap<Float, String> testMap = new LinkedHashMap<Float, String>();
        testMap.put(Float.valueOf(3.5f), "Hello World");
        testMap.put(Float.valueOf(12.25f), "This is a test!");
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 3.5:\"Hello World\" 12.25:\"This is a test!\" 6.25:\"And this is a third value!\"");
        testMap.put(Float.valueOf(6.25f), "And this is a third value!");
        Assertions.assertEquals(testMap, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test 3,5:\"Hello world!\"", "Could not parse command: A key must only contain letters from a-z and A-Z, numbers, underscores and periods at position 2: 3,<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestWithIntegerKey() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(Integer::valueOf).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test 3:\"Hello World\" 12:\"This is a test!\"");
        LinkedHashMap<Integer, String> testMap = new LinkedHashMap<Integer, String>();
        testMap.put(3, "Hello World");
        testMap.put(12, "This is a test!");
        Assertions.assertEquals(testMap, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test 3:\"Hello World\" 12:\"This is a test!\" 6:\"And this is a third value!\"");
        testMap.put(6, "And this is a third value!");
        Assertions.assertEquals(testMap, results.get());
        this.assertCommandFailsWith((CommandSender)player2, "test 3.5:\"Hello world!\"", "Could not parse command: Invalid key (3.5): cannot be converted to a key at position 3: 3.5<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    public void executionTestWithSuggestionsWithContents() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("optionOne", "optionTwo", "optionThree")).withValueList(List.of("solutionOne", "solutionTwo", "solutionThree")).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        this.assertCommandFailsWith((CommandSender)player, "test optionOne:\"solutionTwo\" optionFour:\"solutionOne\"", "Could not parse command: Invalid key: optionFour at position 35: ...optionFour<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test option", "Could not parse command: Invalid key: option at position 6: option<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "test optionOne:\"solutionOne\" optionTwo:\"solutionFour\"", "Could not parse command: Invalid value: solutionFour at position 48: ...lutionFour<--[HERE]");
    }

    @Test
    public void executionTestWithoutSuggestions() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withoutKeyList().withoutValueList().build()})).executesPlayer((player, args) -> results.set((LinkedHashMap)args.get("map")))).register();
        PlayerMock player2 = this.server.addPlayer();
        LinkedHashMap<String, String> testMap = new LinkedHashMap<String, String>();
        testMap.put("key1", "value1");
        testMap.put("key2", "value2");
        this.server.dispatchCommand((CommandSender)player2, "test key1:\"value1\" key2:\"value2\"");
        Assertions.assertEquals(testMap, results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    public void suggestionTestWithMapArgumentAndNoValueDuplicates() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("beautiful", "bold", "crazy", "mighty", "wonderful")).withValueList(List.of("chaotic", "majestic", "sunny", "sweet", "weird")).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("beautiful", "bold", "crazy", "mighty", "wonderful"), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(List.of("beautiful", "bold"), this.server.getSuggestions((CommandSender)player, "test b"));
        Assertions.assertEquals(List.of("crazy"), this.server.getSuggestions((CommandSender)player, "test c"));
        Assertions.assertEquals(List.of("mighty"), this.server.getSuggestions((CommandSender)player, "test m"));
        Assertions.assertEquals(List.of("wonderful"), this.server.getSuggestions((CommandSender)player, "test w"));
        Assertions.assertEquals(List.of(":"), this.server.getSuggestions((CommandSender)player, "test beautiful"));
        Assertions.assertEquals(List.of("\""), this.server.getSuggestions((CommandSender)player, "test beautiful:"));
        Assertions.assertEquals(List.of("chaotic", "majestic", "sunny", "sweet", "weird"), this.server.getSuggestions((CommandSender)player, "test beautiful:\""));
        Assertions.assertEquals(List.of("sunny", "sweet"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"s"));
        Assertions.assertEquals(List.of("chaotic"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"c"));
        Assertions.assertEquals(List.of("majestic"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"m"));
        Assertions.assertEquals(List.of("weird"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"w"));
        Assertions.assertEquals(List.of("\""), this.server.getSuggestions((CommandSender)player, "test beautiful:\"weird"));
        Assertions.assertEquals(List.of("bold", "crazy", "mighty", "wonderful"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"weird\""));
        Assertions.assertEquals(List.of("chaotic", "majestic", "sunny", "sweet"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"weird\" bold:\""));
    }

    @Test
    public void suggestionTestWithMapArgumentAndValueDuplicates() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new MapArgumentBuilder("map").withKeyMapper(s -> s).withValueMapper(s -> s).withKeyList(List.of("beautiful", "bold", "crazy", "mighty", "wonderful")).withValueList(List.of("chaotic", "majestic", "sunny", "sweet", "weird"), true).build()})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of("bold", "crazy", "mighty", "wonderful"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"weird\""));
        Assertions.assertEquals(List.of("chaotic", "majestic", "sunny", "sweet", "weird"), this.server.getSuggestions((CommandSender)player, "test beautiful:\"weird\" bold:\""));
    }
}

