/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.FunctionArgument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentFunctionTests
extends TestBase {
    ArgumentFunctionTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithFunctionArgument() {
        Mut results = Mut.of();
        Mut sayResults = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FunctionArgument("function")})).executesPlayer((player, args) -> results.set((FunctionWrapper[])args.get("function")))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mysay").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executesPlayer((player, args) -> sayResults.set((String)args.getUnchecked("message")))).register();
        PlayerMock player2 = this.server.addPlayer();
        MockPlatform.getInstance().addFunction(new NamespacedKey("ns", "myfunc"), List.of("mysay hi"));
        this.server.dispatchCommand((CommandSender)player2, "test ns:myfunc");
        FunctionWrapper[] result = (FunctionWrapper[])results.get();
        Assertions.assertEquals((int)1, (int)result.length);
        this.assertNoMoreResults(sayResults);
        result[0].run();
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_17));
        Assertions.assertEquals((Object)"hi", sayResults.get());
        this.assertNoMoreResults(results);
        this.assertNoMoreResults(sayResults);
    }

    @Test
    void executionTestWithFunctionArgumentTag() {
        Mut results = Mut.of();
        Mut sayResults = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FunctionArgument("function")})).executesPlayer((player, args) -> results.set((FunctionWrapper[])args.get("function")))).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mysay").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executesPlayer((player, args) -> sayResults.set((String)args.getUnchecked("message")))).register();
        PlayerMock player2 = this.server.addPlayer();
        MockPlatform.getInstance().addTag(new NamespacedKey("ns", "mytag"), List.of(List.of("mysay hi", "mysay bye"), List.of("mysay hello", "mysay world")));
        this.server.dispatchCommand((CommandSender)player2, "test #ns:mytag");
        FunctionWrapper[] result = (FunctionWrapper[])results.get();
        Assertions.assertEquals((int)2, (int)result.length);
        this.assertNoMoreResults(sayResults);
        for (FunctionWrapper wrapper : result) {
            wrapper.run();
        }
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_17));
        Assumptions.assumeFalse((boolean)this.version.equals((Object)MCVersion.V1_18));
        Assertions.assertEquals((Object)"hi", sayResults.get());
        Assertions.assertEquals((Object)"bye", sayResults.get());
        Assertions.assertEquals((Object)"hello", sayResults.get());
        Assertions.assertEquals((Object)"world", sayResults.get());
        this.assertNoMoreResults(results);
        this.assertNoMoreResults(sayResults);
    }

    @Test
    void suggestionTestWithFunctionArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FunctionArgument("function")})).executesPlayer(P_EXEC)).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mysay").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        MockPlatform.getInstance().addFunction(new NamespacedKey("ns", "myfunc"), List.of("mysay hi"));
        MockPlatform.getInstance().addFunction(new NamespacedKey("mynamespace", "myotherfunc"), List.of("mysay bye"));
        Assertions.assertEquals(List.of("mynamespace:myotherfunc", "ns:myfunc"), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithFunctionArgumentTag() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new FunctionArgument("function")})).executesPlayer(P_EXEC)).register();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("mysay").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("message")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        MockPlatform.getInstance().addFunction(new NamespacedKey("ns", "myfunc"), List.of("mysay hi"));
        MockPlatform.getInstance().addFunction(new NamespacedKey("mynamespace", "myotherfunc"), List.of("mysay bye"));
        MockPlatform.getInstance().addTag(new NamespacedKey("ns", "mytag"), List.of(List.of("mysay hi", "mysay bye"), List.of("mysay hello", "mysay world")));
        MockPlatform.getInstance().addTag(new NamespacedKey("namespace", "myothertag"), List.of(List.of("mysay hi", "mysay bye"), List.of("mysay hello", "mysay world")));
        Assertions.assertEquals(List.of("#namespace:myothertag", "#ns:mytag", "mynamespace:myotherfunc", "ns:myfunc"), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

