/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.MCVersion;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.EntityTypeArgument;
import dev.jorel.commandapi.test.MockPlatform;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentEntityTypeTests
extends TestBase {
    ArgumentEntityTypeTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    private List<String> getAllEntityTypes() {
        return Arrays.stream(MockPlatform.getInstance().getEntityTypes()).filter(e -> e != EntityType.UNKNOWN).filter(e -> e != EntityType.PLAYER).filter(e -> e != EntityType.FISHING_HOOK).filter(e -> {
            if (this.version.equals((Object)MCVersion.V1_19_4)) {
                return !e.name().equals("CAMEL") && !e.name().equals("SNIFFER");
            }
            return true;
        }).map(e -> e.getKey().toString()).sorted().toList();
    }

    @Test
    void executionTestWithEntityTypeArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntityTypeArgument("entity")})).executesPlayer((player, args) -> results.set((EntityType)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        this.server.dispatchCommand((CommandSender)player2, "test pig");
        Assertions.assertEquals((Object)EntityType.PIG, results.get());
        this.server.dispatchCommand((CommandSender)player2, "test minecraft:pig");
        Assertions.assertEquals((Object)EntityType.PIG, results.get());
        if (this.version.greaterThanOrEqualTo(MCVersion.V1_19_4)) {
            this.assertCommandFailsWith((CommandSender)player2, "test giraffe", "Can't find element 'minecraft:giraffe' of type 'minecraft:entity_type'");
        } else {
            this.assertCommandFailsWith((CommandSender)player2, "test giraffe", "Unknown entity: minecraft:giraffe");
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithEntityTypeArgumentAllEntityTypes() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntityTypeArgument("entity")})).executesPlayer((player, args) -> results.set((EntityType)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer();
        for (String entityType : this.getAllEntityTypes()) {
            this.server.dispatchCommand((CommandSender)player2, "test " + entityType);
            Assertions.assertEquals((Object)Arrays.stream(EntityType.values()).filter(e -> e.getKey().toString().equals(entityType)).findFirst().get(), results.get());
        }
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithEntityTypeArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntityTypeArgument("entity")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assumptions.assumeTrue((boolean)this.version.greaterThanOrEqualTo(MCVersion.V1_19));
        Assertions.assertEquals(this.getAllEntityTypes(), this.server.getSuggestions((CommandSender)player, "test "));
        Assertions.assertEquals(this.getAllEntityTypes().stream().filter(s -> s.contains(":p") || s.contains("_p")).toList(), this.server.getSuggestions((CommandSender)player, "test p"));
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test x"));
    }
}

