/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.EntitySelectorArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentEntitySelectorTests
extends TestBase {
    ArgumentEntitySelectorTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithEntitySelectorArgumentOnePlayer() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OnePlayer("value")})).executesPlayer((player, args) -> results.set((Player)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test APlayer");
        Assertions.assertEquals((Object)"APlayer", (Object)((Player)results.get()).getName());
        this.server.dispatchCommand((CommandSender)player2, "test @p");
        Assertions.assertEquals((Object)"APlayer", (Object)((Player)results.get()).getName());
        this.server.dispatchCommand((CommandSender)player2, "test @a[limit=1]");
        Assertions.assertEquals((Object)"APlayer", (Object)((Player)results.get()).getName());
        this.assertCommandFailsWith((CommandSender)player2, "test @e[limit=1]", "Only players may be affected by this command, but the provided selector includes entities at position 0: <--[HERE]");
        this.assertNotCommandFailsWith((CommandSender)player2, "test @e[limit=1,type=player]", "Only players may be affected by this command, but the provided selector includes entities at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test @a", "Only one player is allowed, but the provided selector allows more than one at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithEntitySelectorArgumentManyPlayers() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyPlayers("value")})).executesPlayer((player, args) -> results.set((Collection)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.addPlayer("APlayer1");
        this.server.addPlayer("APlayer2");
        this.server.addPlayer("APlayer3");
        this.server.addPlayer("APlayer4");
        this.server.dispatchCommand((CommandSender)player2, "test @a");
        Assertions.assertEquals(List.of("APlayer", "APlayer1", "APlayer2", "APlayer3", "APlayer4"), ((Collection)results.get()).stream().map(Player::getName).toList());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithEntitySelectorArgumentOneEntity() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.OneEntity("value")})).executesPlayer((player, args) -> results.set((Entity)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test APlayer");
        Assertions.assertEquals((Object)"APlayer", (Object)((Entity)results.get()).getName());
        this.server.dispatchCommand((CommandSender)player2, "test @p");
        Assertions.assertEquals((Object)"APlayer", (Object)((Entity)results.get()).getName());
        this.assertCommandFailsWith((CommandSender)player2, "test @e", "Only one entity is allowed, but the provided selector allows more than one at position 0: <--[HERE]");
        this.assertNotCommandFailsWith((CommandSender)player2, "test @e[limit=1]", "Only one entity is allowed, but the provided selector allows more than one at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player2, "test @a", "Only one entity is allowed, but the provided selector allows more than one at position 0: <--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithEntitySelectorArgumentManyEntities() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new EntitySelectorArgument.ManyEntities("value")})).executesPlayer((player, args) -> results.set((Collection)args.get(0)))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.addPlayer("APlayer1");
        this.server.addPlayer("APlayer2");
        this.server.addPlayer("APlayer3");
        this.server.addPlayer("APlayer4");
        this.server.dispatchCommand((CommandSender)player2, "test @a");
        Assertions.assertEquals(List.of("APlayer", "APlayer1", "APlayer2", "APlayer3", "APlayer4"), ((Collection)results.get()).stream().map(CommandSender::getName).toList());
        this.server.dispatchCommand((CommandSender)player2, "test APlayer");
        Assertions.assertEquals((int)1, (int)((Collection)results.get()).size());
        this.server.dispatchCommand((CommandSender)player2, "test @p");
        Assertions.assertEquals((int)1, (int)((Collection)results.get()).size());
        this.assertNoMoreResults(results);
    }
}

