/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.CommandArgument;
import dev.jorel.commandapi.arguments.SuggestionsBranch;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import dev.jorel.commandapi.wrappers.CommandResult;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentCommandTests
extends TestBase {
    ArgumentCommandTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithCommandArgumentBukkitCommand() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("commandargument").withArguments((AbstractArgument[])new Argument[]{new CommandArgument("command")})).executesPlayer((sender, args) -> results.set((CommandResult)args.get(0)))).register();
        SimpleCommandMap commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player, "commandargument version");
        Assertions.assertNotNull((Object)commandMap.getCommand("version"));
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("version"), new String[0]), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithCommandArgumentRestrictedCommandReplaceSuggestions() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("restrictedcommand").withArguments((AbstractArgument[])new Argument[]{new CommandArgument("command").replaceSuggestions(new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"give"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new)), ArgumentSuggestions.strings((String[])new String[]{"diamond", "minecraft:diamond"}), ArgumentSuggestions.empty()})})).executesPlayer((sender, args) -> results.set((CommandResult)args.get(0)))).register();
        SimpleCommandMap commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
        this.registerDummyCommands((CommandMap)commandMap, "give", "data", "tp");
        PlayerMock player = this.server.addPlayer("APlayer");
        this.server.addPlayer("BPlayer");
        this.server.dispatchCommand((CommandSender)player, "restrictedcommand give APlayer diamond");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"APlayer", "diamond"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "restrictedcommand give BPlayer diamond");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"BPlayer", "diamond"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "restrictedcommand give APlayer minecraft:diamond");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"APlayer", "minecraft:diamond"}), results.get());
        this.assertCommandFailsWith((CommandSender)player, "restrictedcommand data APlayer diamond", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "restrictedcommand notacommand APlayer diamond", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "restrictedcommand give CPlayer diamond", "Incorrect argument for command at position 5: give <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "restrictedcommand give APlayer dirt", "Incorrect argument for command at position 13: ...e APlayer <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "restrictedcommand give APlayer diamond 64", "Incorrect argument for command at position 21: ...r diamond <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "restrictedcommand give APlayer", "Expected more arguments at position 13: ...ve APlayer<--[HERE]");
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithCommandArgumentMultipleCommandBranchingSuggestions() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("multiplecommands").withArguments((AbstractArgument[])new Argument[]{new CommandArgument("command").branchSuggestions(new SuggestionsBranch[]{SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"give"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new))}).branch(new SuggestionsBranch[]{SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"diamond", "minecraft:diamond"}), ArgumentSuggestions.empty()}), SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"dirt", "minecraft:dirt"}), null, ArgumentSuggestions.empty()})}), SuggestionsBranch.suggest((ArgumentSuggestions[])new ArgumentSuggestions[]{ArgumentSuggestions.strings((String[])new String[]{"tp"}), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new)), ArgumentSuggestions.strings(info -> (String[])Bukkit.getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new))})})})).executes((sender, args) -> results.set((CommandResult)args.get(0)), new ExecutorType[0])).register();
        SimpleCommandMap commandMap = CommandAPIBukkit.get().getSimpleCommandMap();
        this.registerDummyCommands((CommandMap)commandMap, "give", "data", "tp");
        PlayerMock player = this.server.addPlayer("APlayer");
        this.server.addPlayer("BPlayer");
        this.server.dispatchCommand((CommandSender)player, "multiplecommands give APlayer diamond");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"APlayer", "diamond"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "multiplecommands give BPlayer diamond");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"BPlayer", "diamond"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "multiplecommands give APlayer minecraft:diamond");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"APlayer", "minecraft:diamond"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "multiplecommands give APlayer dirt");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"APlayer", "dirt"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "multiplecommands give APlayer dirt 64");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("give"), new String[]{"APlayer", "dirt", "64"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "multiplecommands tp APlayer BPlayer");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("tp"), new String[]{"APlayer", "BPlayer"}), results.get());
        this.server.dispatchCommand((CommandSender)player, "multiplecommands tp BPlayer APlayer");
        Assertions.assertEquals((Object)new CommandResult(commandMap.getCommand("tp"), new String[]{"BPlayer", "APlayer"}), results.get());
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands data get entity APlayer", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands notacommand APlayer diamond", "Unknown or incomplete command, see below for error at position 0: <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands give CPlayer diamond", "Incorrect argument for command at position 5: give <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands give APlayer stone", "Incorrect argument for command at position 13: ...e APlayer <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands give APlayer diamond 64", "Incorrect argument for command at position 21: ...r diamond <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands give APlayer", "Expected more arguments at position 13: ...ve APlayer<--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands tp APlayer CPlayer", "Incorrect argument for command at position 11: ...p APlayer <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands tp CPlayer APlayer", "Incorrect argument for command at position 3: tp <--[HERE]");
        this.assertCommandFailsWith((CommandSender)player, "multiplecommands tp APlayer", "Expected more arguments at position 11: tp APlayer<--[HERE]");
        this.assertNoMoreResults(results);
    }
}

