/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test.arguments;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.AdventureChatArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ChatArgument;
import dev.jorel.commandapi.test.Mut;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ArgumentChatTests
extends TestBase {
    ArgumentChatTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void executionTestWithSpigotChatArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatArgument("chat")})).executesPlayer((player, args) -> results.set((BaseComponent[])args.get("chat")))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        player2.setOp(true);
        TextComponent expected = new TextComponent("Hello, ");
        expected.addExtra((BaseComponent)new TextComponent("APlayer"));
        expected.addExtra((BaseComponent)new TextComponent("!"));
        this.server.dispatchCommand((CommandSender)player2, "test Hello, @p!");
        Assertions.assertArrayEquals((Object[])new BaseComponent[]{expected}, (Object[])((Object[])results.get()));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithAdventureChatArgument() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatArgument("chat")})).executesPlayer((player, args) -> results.set((Component)args.get("chat")))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        player2.setOp(true);
        this.server.dispatchCommand((CommandSender)player2, "test Hello, @p!");
        Assertions.assertEquals((Object)GsonComponentSerializer.gson().deserialize((Object)"[\"Hello, \",\"APlayer\",\"!\"]"), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithSpigotChatArgumentNoOp() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatArgument("chat")})).executesPlayer((player, args) -> results.set((BaseComponent[])args.get("chat")))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test Hello, APlayer!");
        Assertions.assertArrayEquals((Object[])ComponentSerializer.parse((String)"[\"Hello, APlayer!\"]"), (Object[])((Object[])results.get()));
        this.server.dispatchCommand((CommandSender)player2, "test Hello, @p!");
        Assertions.assertArrayEquals((Object[])ComponentSerializer.parse((String)"[\"Hello, @p!\"]"), (Object[])((Object[])results.get()));
        this.assertNoMoreResults(results);
    }

    @Test
    void executionTestWithAdventureChatArgumentNoOp() {
        Mut results = Mut.of();
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatArgument("chat")})).executesPlayer((player, args) -> results.set((Component)args.get("chat")))).register();
        PlayerMock player2 = this.server.addPlayer("APlayer");
        this.server.dispatchCommand((CommandSender)player2, "test Hello, APlayer!");
        Assertions.assertEquals((Object)GsonComponentSerializer.gson().deserialize((Object)"[\"Hello, APlayer!\"]"), results.get());
        this.server.dispatchCommand((CommandSender)player2, "test Hello, @p!");
        Assertions.assertEquals((Object)GsonComponentSerializer.gson().deserialize((Object)"[\"Hello, @p!\"]"), results.get());
        this.assertNoMoreResults(results);
    }

    @Test
    void suggestionTestWithSpigotChatArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new ChatArgument("chat")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void suggestionTestWithAdventureChatArgument() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new AdventureChatArgument("chat")})).executesPlayer(P_EXEC)).register();
        PlayerMock player = this.server.addPlayer();
        Assertions.assertEquals(List.of(), this.server.getSuggestions((CommandSender)player, "test "));
    }
}

