/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import dev.jorel.commandapi.AbstractCommandAPICommand;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.GreedyStringArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.exceptions.GreedyArgumentException;
import dev.jorel.commandapi.exceptions.InvalidCommandNameException;
import dev.jorel.commandapi.exceptions.MissingCommandExecutorException;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.TestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommandTests
extends TestBase {
    CommandTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testGreedyStringArgumentNotAtEnd() {
        CommandAPICommand validGreedyCommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("arg2")})).executes((sender, args) -> {
            String arg1 = (String)args.get(0);
            String arg2 = (String)args.get(0);
        }, new ExecutorType[0]);
        Assertions.assertDoesNotThrow(() -> validGreedyCommand.register());
        CommandAPICommand invalidGreedyCommand = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new GreedyStringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg2")})).executes((sender, args) -> {
            String arg1 = (String)args.get(0);
            String arg2 = (String)args.get(0);
        }, new ExecutorType[0]);
        Assertions.assertThrows(GreedyArgumentException.class, () -> invalidGreedyCommand.register());
    }

    @Test
    void testInvalidCommandName() {
        Assertions.assertThrows(InvalidCommandNameException.class, () -> new CommandAPICommand((String)null));
        Assertions.assertThrows(InvalidCommandNameException.class, () -> new CommandAPICommand(""));
        Assertions.assertThrows(InvalidCommandNameException.class, () -> new CommandAPICommand("my command"));
    }

    @Test
    void testNoExecutor() {
        CommandAPICommand commandWithNoExecutors = (CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")});
        Assertions.assertThrows(MissingCommandExecutorException.class, () -> commandWithNoExecutors.register());
        CommandAPICommand commandWithNoRunnableSubcommands = (CommandAPICommand)new CommandAPICommand("test").withSubcommand((AbstractCommandAPICommand)new CommandAPICommand("sub"));
        Assertions.assertThrows(MissingCommandExecutorException.class, () -> commandWithNoRunnableSubcommands.register());
    }
}

