/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.IntegerArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.TestBase;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CommandHelpTests
extends TestBase {
    CommandHelpTests() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testRegisterCommandWithHelp() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"short description", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"short description\n&6Description: &ffull description\n&6Usage: &f/test"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }

    @Test
    void testRegisterCommandWithShortDescription() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withShortDescription("short description")).executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"short description", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"short description\n&6Usage: &f/test"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }

    @Test
    void testRegisterCommandFullDescription() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withFullDescription("full description")).executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"full description", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"full description\n&6Description: &ffull description\n&6Usage: &f/test"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }

    @Test
    void testRegisterCommandNoDescription() {
        ((CommandAPICommand)new CommandAPICommand("test").executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"A command by the CommandAPITest plugin.", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"A command by the CommandAPITest plugin.\n&6Usage: &f/test"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }

    @Test
    void testRegisterCommandWithHelpWithAliases() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withAliases(new String[]{"othertest", "othercommand"})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"short description", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"short description\n&6Description: &ffull description\n&6Usage: &f/test\n&6Aliases: &fothertest, othercommand"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }

    @Test
    void testRegisterCommandWithMultipleArguments() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("arg2")})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"short description", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"short description\n&6Description: &ffull description\n&6Usage: &f/test <arg1> <arg2>"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }

    @Test
    void testRegisterMultipleCommands() {
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withHelp("short description", "full description")).withArguments((AbstractArgument[])new Argument[]{new StringArgument("arg1")})).withArguments((AbstractArgument[])new Argument[]{new IntegerArgument("arg2")})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        CommandHelpTests.disablePaperImplementations();
        this.server.getScheduler().performOneTick();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertNotNull((Object)this.server.getHelpMap().getHelpTopic("/test"));
        Assertions.assertEquals((Object)"short description", (Object)this.server.getHelpMap().getHelpTopic("/test").getShortText());
        Assertions.assertEquals((Object)ChatColor.translateAlternateColorCodes((char)'&', (String)"short description\n&6Description: &ffull description\n&6Usage: &f\n- /test <arg1>\n- /test <arg1> <arg2>"), (Object)this.server.getHelpMap().getHelpTopic("/test").getFullText((CommandSender)player));
    }
}

