/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.entity.PlayerMock;
import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.IStringTooltip;
import dev.jorel.commandapi.StringTooltip;
import dev.jorel.commandapi.arguments.AbstractArgument;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.MathOperationArgument;
import dev.jorel.commandapi.arguments.StringArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.test.TestBase;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ArgumentSuggestionTests
extends TestBase {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
    }

    @Test
    void testReplaceSuggestionsConstants() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("arg").replaceSuggestions(ArgumentSuggestions.strings((String[])new String[]{"cat", "apple", "wolf"}))})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertEquals(List.of("apple", "cat", "wolf"), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void testReplaceSuggestionsConstantsCollection() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("arg").replaceSuggestions(ArgumentSuggestions.strings(List.of("cat", "apple", "wolf")))})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertEquals(List.of("apple", "cat", "wolf"), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void testIncludeSuggestionsConstants() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new MathOperationArgument("arg").includeSuggestions(ArgumentSuggestions.strings((String[])new String[]{"^^"}))})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        PlayerMock player = this.server.addPlayer("APlayer");
        Assertions.assertEquals(List.of("%=", "*=", "+=", "-=", "/=", "<", "=", ">", "><", "^^"), this.server.getSuggestions((CommandSender)player, "test "));
    }

    @Test
    void testReplaceSuggestionsConstantsTooltips() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("arg").replaceSuggestions(ArgumentSuggestions.stringsWithTooltips((IStringTooltip[])new IStringTooltip[]{StringTooltip.ofString((String)"cat", (String)"a cat"), StringTooltip.ofString((String)"apple", (String)"an apple"), StringTooltip.ofString((String)"wolf", (String)"a wolf")}))})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertSuggestionListEquals(List.of(this.mkSuggestion("apple", "an apple"), this.mkSuggestion("cat", "a cat"), this.mkSuggestion("wolf", "a wolf")), this.server.getSuggestionsWithTooltips((CommandSender)player, "test "));
    }

    @Test
    void testReplaceSuggestionsConstantsCollectionTooltips() {
        ((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments((AbstractArgument[])new Argument[]{(Argument)new StringArgument("arg").replaceSuggestions(ArgumentSuggestions.stringsWithTooltips(List.of(StringTooltip.ofString((String)"cat", (String)"a cat"), StringTooltip.ofString((String)"apple", (String)"an apple"), StringTooltip.ofString((String)"wolf", (String)"a wolf"))))})).executes((sender, args) -> {}, new ExecutorType[0])).register();
        PlayerMock player = this.server.addPlayer("APlayer");
        this.assertSuggestionListEquals(List.of(this.mkSuggestion("apple", "an apple"), this.mkSuggestion("cat", "a cat"), this.mkSuggestion("wolf", "a wolf")), this.server.getSuggestionsWithTooltips((CommandSender)player, "test "));
    }
}

