/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.wrappers.ParticleData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTables;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MockPlatform<CLW>
extends CommandAPIBukkit<CLW> {
    private static MockPlatform<?> instance = null;
    private final CommandDispatcher<CLW> brigadierDispatcher = new CommandDispatcher();
    private final CommandDispatcher<CLW> resourcesDispatcher = new CommandDispatcher();
    public Map<Class<?>, Map<NamespacedKey, Object>> registry = null;

    public static <CLW> MockPlatform<CLW> getInstance() {
        return instance;
    }

    protected MockPlatform() {
        if (instance == null) {
            instance = this;
        }
    }

    public static void unload() {
        instance = null;
    }

    public CommandDispatcher<CLW> getMockBrigadierDispatcher() {
        return this.brigadierDispatcher;
    }

    public CommandDispatcher<CLW> getMockResourcesDispatcher() {
        return this.resourcesDispatcher;
    }

    public final String convert(ItemStack is) {
        throw new UnimplementedError();
    }

    public final String convert(ParticleData<?> particle) {
        throw new UnimplementedError();
    }

    public final String convert(PotionEffectType potion) {
        throw new UnimplementedError();
    }

    public final String convert(Sound sound) {
        throw new UnimplementedError();
    }

    public final void reloadDataPacks() {
    }

    public static Object getField(Class<?> className, String fieldName, Object instance) {
        return MockPlatform.getField(className, fieldName, fieldName, instance);
    }

    public static Object getField(Class<?> className, String fieldName, String mojangMappedName, Object instance) {
        try {
            Field field = className.getDeclaredField(SafeVarHandle.USING_MOJANG_MAPPINGS ? mojangMappedName : fieldName);
            field.setAccessible(true);
            return field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static void setField(Class<?> className, String fieldName, Object instance, Object value) {
        MockPlatform.setField(className, fieldName, fieldName, instance, value);
    }

    public static void setField(Class<?> className, String fieldName, String mojangMappedName, Object instance, Object value) {
        try {
            Field field = className.getDeclaredField(SafeVarHandle.USING_MOJANG_MAPPINGS ? mojangMappedName : fieldName);
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static <T> T getFieldAs(Class<?> className, String fieldName, Object instance, Class<T> asType) {
        return MockPlatform.getFieldAs(className, fieldName, fieldName, instance, asType);
    }

    public static <T> T getFieldAs(Class<?> className, String fieldName, String mojangMappedName, Object instance, Class<T> asType) {
        try {
            Field field = className.getDeclaredField(SafeVarHandle.USING_MOJANG_MAPPINGS ? mojangMappedName : fieldName);
            field.setAccessible(true);
            return asType.cast(field.get(instance));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public static <T> T forceGetArgument(CommandContext cmdCtx, String key) {
        ParsedArgument result = (ParsedArgument)MockPlatform.getFieldAs(CommandContext.class, "arguments", cmdCtx, Map.class).get(key);
        return (T)result.getResult();
    }

    public abstract ItemFactory getItemFactory();

    public abstract Advancement addAdvancement(NamespacedKey var1);

    public abstract void addFunction(NamespacedKey var1, List<String> var2);

    public abstract void addTag(NamespacedKey var1, List<List<String>> var2);

    public abstract Player setupMockedCraftPlayer(String var1);

    public abstract String getBukkitPotionEffectTypeName(PotionEffectType var1);

    public abstract String getNMSParticleNameFromBukkit(Particle var1);

    public int popFunctionCallbackResult() {
        throw new IllegalStateException("Pop function callback result hasn't been overridden");
    }

    public final List<Pair<String, JsonObject>> getRecipes(Class<?> minecraftServerClass) {
        ArrayList<Pair<String, JsonObject>> list = new ArrayList<Pair<String, JsonObject>>();
        try (JarFile jar = new JarFile(minecraftServerClass.getProtectionDomain().getCodeSource().getLocation().getPath());){
            jar.entries().asIterator().forEachRemaining(entry -> {
                if (entry.getName().startsWith("data/minecraft/recipes/") && entry.getName().endsWith(".json")) {
                    InputStream is = minecraftServerClass.getClassLoader().getResourceAsStream(entry.getName());
                    String jsonStr = new BufferedReader(new InputStreamReader(is)).lines().map(line -> {
                        if (line.contains("\"tag\": ")) {
                            return "\"item\": \"minecraft:stick\"";
                        }
                        return line;
                    }).collect(Collectors.joining("\n"));
                    JsonObject parsedJson = new JsonParser().parse(jsonStr).getAsJsonObject();
                    list.add(new Pair<String, JsonObject>(entry.getName().substring("data/minecraft/recipes/".length(), entry.getName().lastIndexOf(".")), parsedJson));
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load any recipes for testing!", e);
        }
        return list;
    }

    public abstract Enchantment[] getEnchantments();

    public abstract EntityType[] getEntityTypes();

    public abstract LootTables[] getLootTables();

    public abstract PotionEffectType[] getPotionEffects();

    public abstract Sound[] getSounds();

    public abstract Biome[] getBiomes();

    public abstract List<String> getAllItemNames();

    public abstract List<NamespacedKey> getAllRecipes();

    public <T extends Keyed> void addToRegistry(Class<T> className, NamespacedKey key, T object) {
        if (this.registry == null) {
            this.registry = new HashMap();
        }
        if (this.registry.containsKey(className)) {
            this.registry.get(className).put(key, object);
        } else {
            HashMap<NamespacedKey, T> registryMap = new HashMap<NamespacedKey, T>();
            registryMap.put(key, object);
            this.registry.put(className, registryMap);
        }
    }

    public <T extends Keyed> Registry<T> getRegistry(final Class<T> className) {
        return new Registry(){
            final /* synthetic */ MockPlatform this$0;
            {
                this.this$0 = this$0;
            }

            @Nullable
            public T get(@NotNull NamespacedKey key) {
                return (Keyed)this.this$0.registry.get(className).get(key);
            }

            @NotNull
            public Stream<T> stream() {
                return this.this$0.registry.get(className).values().stream();
            }

            public Iterator<T> iterator() {
                return this.this$0.registry.get(className).values().iterator();
            }
        };
    }

    private static class UnimplementedError
    extends Error {
        public UnimplementedError() {
            super("Unimplemented");
        }
    }

    record Pair<A, B>(A first, B second) {
    }
}

