/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentMock;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.PaperImplementations;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.nms.NMS;
import dev.jorel.commandapi.test.Enums;
import dev.jorel.commandapi.test.MockPlatform;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementDisplay;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_20_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemFactory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockNMS
extends Enums {
    private static final SafeVarHandle<HelpMapMock, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(HelpMapMock.class, (String)"topics", (String)"topics", Map.class);
    static adc advancementDataWorld;
    MinecraftServer minecraftServerMock = null;
    List<aig> players = new ArrayList<aig>();
    alk playerListMock;
    final cjd recipeManager;
    Map<acq, dn> functions = new HashMap<acq, dn>();
    Map<acq, Collection<dn>> tags = new HashMap<acq, Collection<dn>>();

    public MockNMS(CommandAPIBukkit<?> baseNMS) {
        super(baseNMS);
        CommandAPIBukkit nms = (CommandAPIBukkit)Mockito.spy((Object)this.baseNMS);
        Mockito.when((Object)nms.getMinecraftServer()).thenAnswer(i -> this.getMinecraftServer());
        ((CommandAPIBukkit)Mockito.doAnswer(i -> this.getSimpleCommandMap()).when((Object)nms)).getSimpleCommandMap();
        this.baseNMS = nms;
        MockPlatform.setField(CommandAPIBukkit.class, (String)"paper", (Object)this.baseNMS, (Object)new PaperImplementations(false, false, (NMS)this.baseNMS));
        aa.a();
        this.unregisterAllEnchantments();
        this.unregisterAllPotionEffects();
        acs.a();
        this.registerDefaultPotionEffects();
        this.registerDefaultEnchantments();
        this.recipeManager = new cjd();
        this.functions = new HashMap<acq, dn>();
        this.registerDefaultRecipes();
        this.playerListMock = (alk)Mockito.mock(alk.class);
        Mockito.when((Object)this.playerListMock.a(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (aig onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return onlinePlayer;
            }
            return null;
        });
    }

    private void unregisterAllPotionEffects() {
        PotionEffectType[] byId = (PotionEffectType[])MockNMS.getFieldAs(PotionEffectType.class, (String)"byId", null, PotionEffectType[].class);
        for (int i = 0; i < byId.length; ++i) {
            byId[i] = null;
        }
        ((Map)MockNMS.getFieldAs(PotionEffectType.class, (String)"byName", null, Map.class)).clear();
        ((Map)MockNMS.getFieldAs(PotionEffectType.class, (String)"byKey", null, Map.class)).clear();
        MockNMS.setField(PotionEffectType.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultPotionEffects() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        this.registerPotionEffectType(1, "SPEED", false, 8171462);
        this.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        this.registerPotionEffectType(3, "HASTE", false, 14270531);
        this.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        this.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        this.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        this.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        this.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        this.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        this.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        this.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        this.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        this.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        this.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        this.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        this.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        this.registerPotionEffectType(17, "HUNGER", false, 5797459);
        this.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        this.registerPotionEffectType(19, "POISON", false, 5149489);
        this.registerPotionEffectType(20, "WITHER", false, 3484199);
        this.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        this.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        this.registerPotionEffectType(23, "SATURATION", true, 16262179);
        this.registerPotionEffectType(24, "GLOWING", false, 9740385);
        this.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        this.registerPotionEffectType(26, "LUCK", false, 0x339900);
        this.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        this.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        this.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        this.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        this.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        this.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 0x44FF44);
        this.registerPotionEffectType(33, "DARKNESS", false, 2696993);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private void registerPotionEffectType(int id, @NotNull String name, boolean instant, int rgb) {
        NamespacedKey key = NamespacedKey.minecraft((String)name.toLowerCase(Locale.ROOT));
        PotionEffectType.registerPotionEffectType((PotionEffectType)new MockPotionEffectType(key, id, name, instant, Color.fromRGB((int)rgb)));
    }

    private void unregisterAllEnchantments() {
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byName", null, Map.class)).clear();
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byKey", null, Map.class)).clear();
        MockNMS.setField(Enchantment.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultEnchantments() {
        for (Enchantment enchantment : this.getEnchantments()) {
            if (Enchantment.getByKey((NamespacedKey)enchantment.getKey()) != null) continue;
            Enchantment.registerEnchantment((Enchantment)new EnchantmentMock(enchantment.getKey(), enchantment.getKey().getKey()));
        }
    }

    private void registerDefaultRecipes() {
        List<cjc> recipes = this.getRecipes(MinecraftServer.class).stream().map(p -> cjd.a((acq)new acq((String)p.first()), (JsonObject)((JsonObject)p.second()))).toList();
        this.recipeManager.a(recipes);
    }

    public ItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public List<String> getAllItemNames() {
        return StreamSupport.stream(jb.i.spliterator(), false).map(Object::toString).map(s -> "minecraft:" + s).sorted().toList();
    }

    public String[] compatibleVersions() {
        return this.baseNMS.compatibleVersions();
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((ServerMock)Bukkit.getServer()).getCommandMap();
    }

    public ds getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        CommandSender sender = (CommandSender)senderWrapper.getSource();
        ds css = (ds)Mockito.mock(ds.class);
        Mockito.when((Object)css.getBukkitSender()).thenReturn((Object)sender);
        if (sender instanceof Entity) {
            aif worldServerLevel;
            Entity entity = (Entity)sender;
            Location loc = entity.getLocation();
            Mockito.when((Object)css.d()).thenReturn((Object)new eei(loc.getX(), loc.getY(), loc.getZ()));
            World world = entity.getWorld();
            if (world instanceof CraftWorld) {
                CraftWorld cw = (CraftWorld)world;
                worldServerLevel = cw.getHandle();
            } else {
                worldServerLevel = (aif)Mockito.mock(aif.class);
            }
            Mockito.when((Object)css.e()).thenReturn((Object)worldServerLevel);
            Mockito.when((Object)css.e().A((gu)ArgumentMatchers.any(gu.class))).thenReturn((Object)true);
            Mockito.when((Object)css.e().j((gu)ArgumentMatchers.any(gu.class))).thenReturn((Object)true);
            Mockito.when((Object)css.m()).thenReturn((Object)eb.a.b);
            Mockito.when((Object)css.l()).thenAnswer(s -> this.getMinecraftServer());
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                aig entityPlayerMock = (aig)Mockito.mock(aig.class);
                CraftPlayer craftPlayerMock = (CraftPlayer)Mockito.mock(CraftPlayer.class);
                String name = onlinePlayer.getName();
                UUID uuid = onlinePlayer.getUniqueId();
                Mockito.when((Object)craftPlayerMock.getName()).thenReturn((Object)name);
                Mockito.when((Object)craftPlayerMock.getUniqueId()).thenReturn((Object)uuid);
                Mockito.when((Object)entityPlayerMock.getBukkitEntity()).thenReturn((Object)craftPlayerMock);
                Mockito.when((Object)entityPlayerMock.H_()).thenReturn((Object)sw.b((String)name));
                Mockito.when((Object)entityPlayerMock.ae()).thenReturn((Object)bfn.bt);
                this.players.add(entityPlayerMock);
            }
            Mockito.when((Object)css.u()).thenAnswer(invocation -> {
                HashSet<acp> set = new HashSet<acp>();
                for (World world : Bukkit.getWorlds()) {
                    acp key = (acp)Mockito.mock(acp.class);
                    Mockito.when((Object)key.a()).thenReturn((Object)new acq(world.getName()));
                    set.add(key);
                }
                return set;
            });
            Mockito.when((Object)css.k()).thenReturn((Object)new eeh(loc.getPitch(), loc.getYaw()));
            Mockito.when((Object)css.r()).thenAnswer(invocation -> Bukkit.getScoreboardManager().getMainScoreboard().getTeams().stream().map(Team::getName).toList());
            Mockito.when((Object)css.s()).thenAnswer(invocation -> jb.c.e().stream());
            Mockito.when((Object)css.t()).thenAnswer(invocation -> this.recipeManager.d());
            Mockito.when((Object)css.c(ArgumentMatchers.anyInt())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.hasPermission(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.w()).thenAnswer(invocation -> cay.f);
            Mockito.when((Object)css.a()).thenReturn((Object)css);
            Mockito.when((Object)css.b(ArgumentMatchers.anyInt())).thenReturn((Object)css);
        } else {
            Mockito.when((Object)css.d()).thenReturn((Object)new eei(0.0, 0.0, 0.0));
            Mockito.when((Object)css.k()).thenReturn((Object)new eeh(0.0f, 0.0f));
        }
        return css;
    }

    public void createDispatcherFile(File file, CommandDispatcher dispatcher) throws IOException {
        this.baseNMS.createDispatcherFile(file, dispatcher);
    }

    public World getWorldForCSS(ds clw) {
        return this.baseNMS.getWorldForCSS((Object)clw);
    }

    public String getBukkitPotionEffectTypeName(PotionEffectType potionEffectType) {
        return potionEffectType.getKey().toString();
    }

    public String getNMSParticleNameFromBukkit(Particle particle) {
        CraftParticle craftParticle = CraftParticle.valueOf((String)particle.name());
        return ((acq)MockPlatform.getFieldAs(CraftParticle.class, (String)"minecraftKey", (Object)craftParticle, acq.class)).toString();
    }

    public List<NamespacedKey> getAllRecipes() {
        return this.recipeManager.d().map(k -> new NamespacedKey(k.b(), k.a())).toList();
    }

    public <T> T getMinecraftServer() {
        if (this.minecraftServerMock != null) {
            return (T)this.minecraftServerMock;
        }
        this.minecraftServerMock = (MinecraftServer)Mockito.mock(MinecraftServer.class);
        Mockito.when((Object)this.minecraftServerMock.aH()).thenAnswer(invocation -> {
            dzn lootDataManager = (dzn)Mockito.mock(dzn.class);
            Mockito.when((Object)lootDataManager.getLootTable((acq)ArgumentMatchers.any(acq.class))).thenAnswer(i -> {
                if (dzg.a().contains(i.getArgument(0))) {
                    return dzs.a;
                }
                return null;
            });
            Mockito.when((Object)lootDataManager.a((dzp)ArgumentMatchers.any())).thenAnswer(i -> Streams.concat((Stream[])new Stream[]{Arrays.stream(this.getEntityTypes()).filter(e -> !e.equals((Object)EntityType.UNKNOWN)).filter(e -> !e.equals((Object)EntityType.ALLAY)).filter(e -> !e.equals((Object)EntityType.FROG)).filter(e -> !e.equals((Object)EntityType.TADPOLE)).filter(e -> !e.equals((Object)EntityType.WARDEN)).filter(e -> e.isAlive()).map(EntityType::getKey).map(k -> new acq("minecraft", "entities/" + k.getKey())), dzg.a().stream()}).collect(Collectors.toSet()));
            return lootDataManager;
        });
        Mockito.when((Object)this.minecraftServerMock.az()).thenAnswer(i -> advancementDataWorld);
        adg scoreboardServerMock = (adg)Mockito.mock(adg.class);
        Mockito.when((Object)scoreboardServerMock.f(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String teamName = (String)invocation.getArgument(0);
            Team team = Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
            if (team == null) {
                return null;
            }
            return new efe((efg)scoreboardServerMock, teamName);
        });
        Mockito.when((Object)scoreboardServerMock.d(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String objectiveName = (String)invocation.getArgument(0);
            Objective bukkitObjective = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
            if (bukkitObjective == null) {
                return null;
            }
            efj efj2 = (efj)efj.a((String)bukkitObjective.getCriteria()).get();
            tj tj2 = sw.b((String)bukkitObjective.getDisplayName());
            return new efd((efg)scoreboardServerMock, objectiveName, efj2, (sw)tj2, switch (bukkitObjective.getRenderType()) {
                default -> throw new IncompatibleClassChangeError();
                case RenderType.HEARTS -> efj.a.b;
                case RenderType.INTEGER -> efj.a.a;
            });
        });
        Mockito.when((Object)this.minecraftServerMock.aF()).thenReturn((Object)scoreboardServerMock);
        Mockito.when((Object)this.minecraftServerMock.a((acp)ArgumentMatchers.any(acp.class))).thenAnswer(invocation -> {
            acp resourceKey = (acp)invocation.getArgument(0);
            String worldName = resourceKey.a().a();
            World world = Bukkit.getServer().getWorld(worldName);
            if (world == null) {
                return null;
            }
            CraftWorld craftWorldMock = (CraftWorld)Mockito.mock(CraftWorld.class);
            Mockito.when((Object)craftWorldMock.getName()).thenReturn((Object)world.getName());
            Mockito.when((Object)craftWorldMock.getUID()).thenReturn((Object)world.getUID());
            aif bukkitWorldServerMock = (aif)Mockito.mock(aif.class);
            Mockito.when((Object)bukkitWorldServerMock.getWorld()).thenReturn((Object)craftWorldMock);
            return bukkitWorldServerMock;
        });
        Mockito.when((Object)this.minecraftServerMock.ac()).thenAnswer(i -> this.playerListMock);
        Mockito.when((Object)this.minecraftServerMock.ac().t()).thenAnswer(i -> this.players);
        alg userCacheMock = (alg)Mockito.mock(alg.class);
        Mockito.when((Object)userCacheMock.a(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (aig onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return Optional.of(new GameProfile(onlinePlayer.getBukkitEntity().getUniqueId(), playerName));
            }
            return Optional.empty();
        });
        Mockito.when((Object)this.minecraftServerMock.ap()).thenReturn((Object)userCacheMock);
        Mockito.when((Object)this.minecraftServerMock.aE()).thenAnswer(i -> this.recipeManager);
        Mockito.when((Object)this.minecraftServerMock.j()).thenReturn((Object)2);
        Mockito.when((Object)this.minecraftServerMock.aA()).thenAnswer(i -> {
            add serverFunctionLibrary = (add)Mockito.mock(add.class);
            Mockito.when((Object)serverFunctionLibrary.a((acq)ArgumentMatchers.any())).thenAnswer(invocation -> Optional.ofNullable(this.functions.get(invocation.getArgument(0))));
            Mockito.when((Object)serverFunctionLibrary.a()).thenAnswer(invocation -> this.functions);
            Mockito.when((Object)serverFunctionLibrary.b((acq)ArgumentMatchers.any())).thenAnswer(invocation -> this.tags.getOrDefault(invocation.getArgument(0), List.of()));
            Mockito.when((Object)serverFunctionLibrary.b()).thenAnswer(invocation -> this.tags.keySet());
            return new ade(this.minecraftServerMock, serverFunctionLibrary){

                public CommandDispatcher<ds> b() {
                    return Brigadier.getCommandDispatcher();
                }
            };
        });
        Mockito.when((Object)this.minecraftServerMock.aI()).thenAnswer(i -> new cmi());
        Mockito.when((Object)this.minecraftServerMock.aN()).thenAnswer(i -> bby.a.f());
        dt brigadierCommands = new dt();
        MockPlatform.setField(brigadierCommands.getClass(), (String)"g", (String)"dispatcher", (Object)brigadierCommands, (Object)this.getMockBrigadierDispatcher());
        this.minecraftServerMock.vanillaCommandDispatcher = brigadierCommands;
        dt resourcesCommands = new dt();
        MockPlatform.setField(resourcesCommands.getClass(), (String)"g", (String)"dispatcher", (Object)resourcesCommands, (Object)this.getMockResourcesDispatcher());
        Mockito.when((Object)this.minecraftServerMock.aC()).thenReturn((Object)resourcesCommands);
        return (T)this.minecraftServerMock;
    }

    public void addFunction(NamespacedKey key, List<String> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        acq resourceLocation = new acq(key.toString());
        ds css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        this.functions.put(resourceLocation, dn.a((acq)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (ds)css, commands));
    }

    public void addTag(NamespacedKey key, List<List<String>> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        acq resourceLocation = new acq(key.toString());
        ds css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        ArrayList<dn> tagFunctions = new ArrayList<dn>();
        for (List<String> functionCommands : commands) {
            tagFunctions.add(dn.a((acq)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (ds)css, functionCommands));
        }
        this.tags.put(resourceLocation, tagFunctions);
    }

    public Player setupMockedCraftPlayer(String name) {
        CraftPlayer player = (CraftPlayer)Mockito.mock(CraftPlayer.class);
        aif serverLevel = (aif)Mockito.mock(aif.class);
        CraftWorld world = (CraftWorld)Mockito.mock(CraftWorld.class);
        Mockito.when((Object)world.getHandle()).thenReturn((Object)serverLevel);
        Mockito.when((Object)serverLevel.getWorld()).thenReturn((Object)world);
        Mockito.when((Object)player.getLocation()).thenReturn((Object)new Location((World)world, 0.0, 0.0, 0.0));
        Mockito.when((Object)player.getWorld()).thenReturn((Object)world);
        ds css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)this.wrapCommandSender((CommandSender)player));
        aig handle = (aig)Mockito.mock(aig.class);
        Mockito.when((Object)handle.da()).thenReturn((Object)css);
        Mockito.when((Object)player.getHandle()).thenReturn((Object)handle);
        tj nameComponent = sw.b((String)name);
        Mockito.when((Object)handle.Z()).thenReturn((Object)nameComponent);
        Mockito.when((Object)handle.H_()).thenReturn((Object)nameComponent);
        return player;
    }

    public Advancement addAdvancement(final NamespacedKey key) {
        MockNMS.advancementDataWorld.c.b.put(new acq(key.toString()), new ae(new acq(key.toString()), null, null, null, new HashMap(), null, false));
        return new Advancement(){
            final /* synthetic */ MockNMS this$0;
            {
                this.this$0 = this$0;
            }

            public NamespacedKey getKey() {
                return key;
            }

            public Collection<String> getCriteria() {
                return List.of();
            }

            @Nullable
            public AdvancementDisplay getDisplay() {
                throw new IllegalStateException("getDisplay is unimplemented");
            }
        };
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<ds> cmdCtx, boolean forceNative) {
        return this.baseNMS.getSenderForCommand(cmdCtx, forceNative);
    }

    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(ds clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return this.baseNMS.generateHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((HelpMapMock)Bukkit.getHelpMap()));
    }

    public CommandRegistrationStrategy<ds> createCommandRegistrationStrategy() {
        return this.baseNMS.createCommandRegistrationStrategy();
    }

    static {
        CodeSource src = PotionEffectType.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            System.err.println("Loading PotionEffectType sources from " + String.valueOf(src.getLocation()));
        }
        advancementDataWorld = new adc(null);
    }
}

