/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentMock;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.test.Enums;
import dev.jorel.commandapi.test.MockPlatform;
import io.papermc.paper.advancement.AdvancementDisplay;
import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.kyori.adventure.text.Component;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemFactory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockNMS
extends Enums {
    private static final SafeVarHandle<HelpMapMock, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(HelpMapMock.class, (String)"topics", (String)"topics", Map.class);
    static ServerAdvancementManager advancementDataWorld;
    MinecraftServer minecraftServerMock = null;
    List<ServerPlayer> players = new ArrayList<ServerPlayer>();
    PlayerList playerListMock;
    final RecipeManager recipeManager;
    Map<ResourceLocation, CommandFunction> functions = new HashMap<ResourceLocation, CommandFunction>();
    Map<ResourceLocation, Collection<CommandFunction>> tags = new HashMap<ResourceLocation, Collection<CommandFunction>>();

    public MockNMS(CommandAPIBukkit<?> baseNMS) {
        super(baseNMS);
        CommandAPIBukkit nms = (CommandAPIBukkit)Mockito.spy((Object)this.baseNMS);
        Mockito.when((Object)nms.getMinecraftServer()).thenAnswer(i -> this.getMinecraftServer());
        this.baseNMS = nms;
        SharedConstants.tryDetectVersion();
        this.unregisterAllEnchantments();
        this.unregisterAllPotionEffects();
        Bootstrap.bootStrap();
        this.registerDefaultPotionEffects();
        this.registerDefaultEnchantments();
        this.recipeManager = new RecipeManager();
        this.functions = new HashMap<ResourceLocation, CommandFunction>();
        this.registerDefaultRecipes();
        this.playerListMock = (PlayerList)Mockito.mock(PlayerList.class);
        Mockito.when((Object)this.playerListMock.getPlayerByName(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (ServerPlayer onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return onlinePlayer;
            }
            return null;
        });
    }

    private void unregisterAllPotionEffects() {
        PotionEffectType[] byId = (PotionEffectType[])MockNMS.getFieldAs(PotionEffectType.class, (String)"byId", null, PotionEffectType[].class);
        for (int i = 0; i < byId.length; ++i) {
            byId[i] = null;
        }
        ((Map)MockNMS.getFieldAs(PotionEffectType.class, (String)"byName", null, Map.class)).clear();
        ((Map)MockNMS.getFieldAs(PotionEffectType.class, (String)"byKey", null, Map.class)).clear();
        MockNMS.setField(PotionEffectType.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultPotionEffects() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        this.registerPotionEffectType(1, "SPEED", false, 8171462);
        this.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        this.registerPotionEffectType(3, "HASTE", false, 14270531);
        this.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        this.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        this.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        this.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        this.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        this.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        this.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        this.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        this.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        this.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        this.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        this.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        this.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        this.registerPotionEffectType(17, "HUNGER", false, 5797459);
        this.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        this.registerPotionEffectType(19, "POISON", false, 5149489);
        this.registerPotionEffectType(20, "WITHER", false, 3484199);
        this.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        this.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        this.registerPotionEffectType(23, "SATURATION", true, 16262179);
        this.registerPotionEffectType(24, "GLOWING", false, 9740385);
        this.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        this.registerPotionEffectType(26, "LUCK", false, 0x339900);
        this.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        this.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        this.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        this.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        this.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        this.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 0x44FF44);
        this.registerPotionEffectType(33, "DARKNESS", false, 2696993);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private void registerPotionEffectType(int id, @NotNull String name, boolean instant, int rgb) {
        NamespacedKey key = NamespacedKey.minecraft((String)name.toLowerCase(Locale.ROOT));
        PotionEffectType.registerPotionEffectType((PotionEffectType)new MockPotionEffectType(key, id, name, instant, Color.fromRGB((int)rgb)));
    }

    private void unregisterAllEnchantments() {
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byName", null, Map.class)).clear();
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byKey", null, Map.class)).clear();
        MockNMS.setField(Enchantment.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultEnchantments() {
        for (Enchantment enchantment : this.getEnchantments()) {
            if (Enchantment.getByKey((NamespacedKey)enchantment.getKey()) != null) continue;
            Enchantment.registerEnchantment((Enchantment)new EnchantmentMock(enchantment.getKey(), enchantment.getKey().getKey()));
        }
    }

    private void registerDefaultRecipes() {
        List<Recipe> recipes = this.getRecipes(MinecraftServer.class).stream().map(p -> RecipeManager.fromJson((ResourceLocation)new ResourceLocation((String)p.first()), (JsonObject)((JsonObject)p.second()))).toList();
        this.recipeManager.replaceRecipes(recipes);
    }

    public ItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public List<String> getAllItemNames() {
        return StreamSupport.stream(BuiltInRegistries.ITEM.spliterator(), false).map(Object::toString).map(s -> "minecraft:" + s).sorted().toList();
    }

    public String[] compatibleVersions() {
        return this.baseNMS.compatibleVersions();
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((ServerMock)Bukkit.getServer()).getCommandMap();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return this.baseNMS.isVanillaCommandWrapper(command);
    }

    public Command wrapToVanillaCommandWrapper(CommandNode<CommandSourceStack> node) {
        return this.baseNMS.wrapToVanillaCommandWrapper(node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<CommandSourceStack> node) {
        return this.baseNMS.isBukkitCommandWrapper(node);
    }

    public CommandSourceStack getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        CommandSender sender = (CommandSender)senderWrapper.getSource();
        CommandSourceStack css = (CommandSourceStack)Mockito.mock(CommandSourceStack.class);
        Mockito.when((Object)css.getBukkitSender()).thenReturn((Object)sender);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Location loc = player.getLocation();
            Mockito.when((Object)css.getPosition()).thenReturn((Object)new Vec3(loc.getX(), loc.getY(), loc.getZ()));
            ServerLevel worldServerMock = (ServerLevel)Mockito.mock(ServerLevel.class);
            Mockito.when((Object)css.getLevel()).thenReturn((Object)worldServerMock);
            Mockito.when((Object)css.getLevel().hasChunkAt((BlockPos)ArgumentMatchers.any(BlockPos.class))).thenReturn((Object)true);
            Mockito.when((Object)css.getLevel().isInWorldBounds((BlockPos)ArgumentMatchers.any(BlockPos.class))).thenReturn((Object)true);
            Mockito.when((Object)css.getAnchor()).thenReturn((Object)EntityAnchorArgument.Anchor.EYES);
            Mockito.when((Object)css.getServer()).thenAnswer(s -> this.getMinecraftServer());
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                ServerPlayer entityPlayerMock = (ServerPlayer)Mockito.mock(ServerPlayer.class);
                CraftPlayer craftPlayerMock = (CraftPlayer)Mockito.mock(CraftPlayer.class);
                String name = onlinePlayer.getName();
                UUID uuid = onlinePlayer.getUniqueId();
                Mockito.when((Object)craftPlayerMock.getName()).thenReturn((Object)name);
                Mockito.when((Object)craftPlayerMock.getUniqueId()).thenReturn((Object)uuid);
                Mockito.when((Object)entityPlayerMock.getBukkitEntity()).thenReturn((Object)craftPlayerMock);
                Mockito.when((Object)entityPlayerMock.getDisplayName()).thenReturn((Object)net.minecraft.network.chat.Component.literal((String)name));
                Mockito.when((Object)entityPlayerMock.getType()).thenReturn((Object)EntityType.PLAYER);
                this.players.add(entityPlayerMock);
            }
            Mockito.when((Object)css.levels()).thenAnswer(invocation -> {
                HashSet<ResourceKey> set = new HashSet<ResourceKey>();
                for (World world : Bukkit.getWorlds()) {
                    ResourceKey key = (ResourceKey)Mockito.mock(ResourceKey.class);
                    Mockito.when((Object)key.location()).thenReturn((Object)new ResourceLocation(world.getName()));
                    set.add(key);
                }
                return set;
            });
            Mockito.when((Object)css.getRotation()).thenReturn((Object)new Vec2(loc.getPitch(), loc.getYaw()));
            Mockito.when((Object)css.getAllTeams()).thenAnswer(invocation -> Bukkit.getScoreboardManager().getMainScoreboard().getTeams().stream().map(Team::getName).toList());
            Mockito.when((Object)css.getAvailableSounds()).thenAnswer(invocation -> BuiltInRegistries.SOUND_EVENT.keySet().stream());
            Mockito.when((Object)css.getRecipeNames()).thenAnswer(invocation -> this.recipeManager.getRecipeIds());
            Mockito.when((Object)css.hasPermission(ArgumentMatchers.anyInt())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.hasPermission(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.enabledFeatures()).thenAnswer(invocation -> FeatureFlags.DEFAULT_FLAGS);
            Mockito.when((Object)css.withSuppressedOutput()).thenReturn((Object)css);
            Mockito.when((Object)css.withMaximumPermission(ArgumentMatchers.anyInt())).thenReturn((Object)css);
        }
        return css;
    }

    public void createDispatcherFile(File file, CommandDispatcher dispatcher) throws IOException {
        this.baseNMS.createDispatcherFile(file, dispatcher);
    }

    public World getWorldForCSS(CommandSourceStack clw) {
        return new WorldMock();
    }

    public String getBukkitPotionEffectTypeName(PotionEffectType potionEffectType) {
        return potionEffectType.getKey().toString();
    }

    public String getNMSParticleNameFromBukkit(Particle particle) {
        CraftParticle craftParticle = CraftParticle.valueOf((String)particle.name());
        return ((ResourceLocation)MockPlatform.getFieldAs(CraftParticle.class, (String)"minecraftKey", (Object)craftParticle, ResourceLocation.class)).toString();
    }

    public List<NamespacedKey> getAllRecipes() {
        return this.recipeManager.getRecipeIds().map(k -> new NamespacedKey(k.getNamespace(), k.getPath())).toList();
    }

    public <T> T getMinecraftServer() {
        if (this.minecraftServerMock != null) {
            return (T)this.minecraftServerMock;
        }
        this.minecraftServerMock = (MinecraftServer)Mockito.mock(MinecraftServer.class);
        Mockito.when((Object)this.minecraftServerMock.getLootTables()).thenAnswer(invocation -> {
            LootTables lootTables = (LootTables)Mockito.mock(LootTables.class);
            Mockito.when((Object)lootTables.get((ResourceLocation)ArgumentMatchers.any(ResourceLocation.class))).thenAnswer(i -> {
                if (BuiltInLootTables.all().contains(i.getArgument(0))) {
                    return LootTable.EMPTY;
                }
                return null;
            });
            Mockito.when((Object)lootTables.getIds()).thenAnswer(i -> Streams.concat((Stream[])new Stream[]{Arrays.stream(this.getEntityTypes()).filter(e -> !e.equals((Object)org.bukkit.entity.EntityType.UNKNOWN)).filter(e -> !e.equals((Object)org.bukkit.entity.EntityType.ALLAY)).filter(e -> !e.equals((Object)org.bukkit.entity.EntityType.FROG)).filter(e -> !e.equals((Object)org.bukkit.entity.EntityType.TADPOLE)).filter(e -> !e.equals((Object)org.bukkit.entity.EntityType.WARDEN)).filter(e -> e.isAlive()).map(org.bukkit.entity.EntityType::getKey).map(k -> new ResourceLocation("minecraft", "entities/" + k.getKey())), BuiltInLootTables.all().stream()}).collect(Collectors.toSet()));
            return lootTables;
        });
        Mockito.when((Object)this.minecraftServerMock.getAdvancements()).thenAnswer(i -> advancementDataWorld);
        ServerScoreboard scoreboardServerMock = (ServerScoreboard)Mockito.mock(ServerScoreboard.class);
        Mockito.when((Object)scoreboardServerMock.getPlayerTeam(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String teamName = (String)invocation.getArgument(0);
            Team team = Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
            if (team == null) {
                return null;
            }
            return new PlayerTeam((Scoreboard)scoreboardServerMock, teamName);
        });
        Mockito.when((Object)scoreboardServerMock.getObjective(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String objectiveName = (String)invocation.getArgument(0);
            org.bukkit.scoreboard.Objective bukkitObjective = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
            if (bukkitObjective == null) {
                return null;
            }
            ObjectiveCriteria objectiveCriteria = (ObjectiveCriteria)ObjectiveCriteria.byName((String)bukkitObjective.getCriteria()).get();
            MutableComponent mutableComponent = net.minecraft.network.chat.Component.literal((String)bukkitObjective.getDisplayName());
            return new Objective((Scoreboard)scoreboardServerMock, objectiveName, objectiveCriteria, (net.minecraft.network.chat.Component)mutableComponent, switch (bukkitObjective.getRenderType()) {
                default -> throw new IncompatibleClassChangeError();
                case RenderType.HEARTS -> ObjectiveCriteria.RenderType.HEARTS;
                case RenderType.INTEGER -> ObjectiveCriteria.RenderType.INTEGER;
            });
        });
        Mockito.when((Object)this.minecraftServerMock.getScoreboard()).thenReturn((Object)scoreboardServerMock);
        Mockito.when((Object)this.minecraftServerMock.getLevel((ResourceKey)ArgumentMatchers.any(ResourceKey.class))).thenAnswer(invocation -> {
            ResourceKey resourceKey = (ResourceKey)invocation.getArgument(0);
            String worldName = resourceKey.location().getPath();
            World world = Bukkit.getServer().getWorld(worldName);
            if (world == null) {
                return null;
            }
            CraftWorld craftWorldMock = (CraftWorld)Mockito.mock(CraftWorld.class);
            Mockito.when((Object)craftWorldMock.getName()).thenReturn((Object)world.getName());
            Mockito.when((Object)craftWorldMock.getUID()).thenReturn((Object)world.getUID());
            ServerLevel bukkitWorldServerMock = (ServerLevel)Mockito.mock(ServerLevel.class);
            Mockito.when((Object)bukkitWorldServerMock.getWorld()).thenReturn((Object)craftWorldMock);
            return bukkitWorldServerMock;
        });
        Mockito.when((Object)this.minecraftServerMock.getPlayerList()).thenAnswer(i -> this.playerListMock);
        Mockito.when((Object)this.minecraftServerMock.getPlayerList().getPlayers()).thenAnswer(i -> this.players);
        GameProfileCache userCacheMock = (GameProfileCache)Mockito.mock(GameProfileCache.class);
        Mockito.when((Object)userCacheMock.get(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (ServerPlayer onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return Optional.of(new GameProfile(onlinePlayer.getBukkitEntity().getUniqueId(), playerName));
            }
            return Optional.empty();
        });
        Mockito.when((Object)this.minecraftServerMock.getProfileCache()).thenReturn((Object)userCacheMock);
        Mockito.when((Object)this.minecraftServerMock.getRecipeManager()).thenAnswer(i -> this.recipeManager);
        Mockito.when((Object)this.minecraftServerMock.getFunctionCompilationLevel()).thenReturn((Object)2);
        Mockito.when((Object)this.minecraftServerMock.getFunctions()).thenAnswer(i -> {
            ServerFunctionLibrary serverFunctionLibrary = (ServerFunctionLibrary)Mockito.mock(ServerFunctionLibrary.class);
            Mockito.when((Object)serverFunctionLibrary.getFunction((ResourceLocation)ArgumentMatchers.any())).thenAnswer(invocation -> Optional.ofNullable(this.functions.get(invocation.getArgument(0))));
            Mockito.when((Object)serverFunctionLibrary.getFunctions()).thenAnswer(invocation -> this.functions);
            Mockito.when((Object)serverFunctionLibrary.getTag((ResourceLocation)ArgumentMatchers.any())).thenAnswer(invocation -> this.tags.getOrDefault(invocation.getArgument(0), List.of()));
            Mockito.when((Object)serverFunctionLibrary.getAvailableTags()).thenAnswer(invocation -> this.tags.keySet());
            return new ServerFunctionManager(this.minecraftServerMock, serverFunctionLibrary){

                public CommandDispatcher<CommandSourceStack> getDispatcher() {
                    return Brigadier.getCommandDispatcher();
                }
            };
        });
        Mockito.when((Object)this.minecraftServerMock.getGameRules()).thenAnswer(i -> new GameRules());
        Mockito.when((Object)this.minecraftServerMock.getProfiler()).thenAnswer(i -> InactiveMetricsRecorder.INSTANCE.getProfiler());
        Commands commands = new Commands();
        MockPlatform.setField(commands.getClass(), (String)"g", (String)"dispatcher", (Object)commands, (Object)this.getBrigadierDispatcher());
        this.minecraftServerMock.vanillaCommandDispatcher = commands;
        return (T)this.minecraftServerMock;
    }

    public void addFunction(NamespacedKey key, List<String> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        ResourceLocation resourceLocation = new ResourceLocation(key.toString());
        CommandSourceStack css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        this.functions.put(resourceLocation, CommandFunction.fromLines((ResourceLocation)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (CommandSourceStack)css, commands));
    }

    public void addTag(NamespacedKey key, List<List<String>> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        ResourceLocation resourceLocation = new ResourceLocation(key.toString());
        CommandSourceStack css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        ArrayList<CommandFunction> tagFunctions = new ArrayList<CommandFunction>();
        for (List<String> functionCommands : commands) {
            tagFunctions.add(CommandFunction.fromLines((ResourceLocation)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (CommandSourceStack)css, functionCommands));
        }
        this.tags.put(resourceLocation, tagFunctions);
    }

    public Class<? extends Player> getCraftPlayerClass() {
        return CraftPlayer.class;
    }

    public org.bukkit.advancement.Advancement addAdvancement(final NamespacedKey key) {
        MockNMS.advancementDataWorld.advancements.advancements.put(new ResourceLocation(key.toString()), new Advancement(new ResourceLocation(key.toString()), null, null, null, new HashMap(), null));
        return new org.bukkit.advancement.Advancement(){
            final /* synthetic */ MockNMS this$0;
            {
                this.this$0 = this$0;
            }

            public NamespacedKey getKey() {
                return key;
            }

            public Collection<String> getCriteria() {
                return List.of();
            }

            @Nullable
            public AdvancementDisplay getDisplay() {
                throw new IllegalStateException("getDisplay is unimplemented");
            }

            @NotNull
            public Component displayName() {
                throw new IllegalStateException("displayName is unimplemented");
            }

            public @Nullable org.bukkit.advancement.Advancement getParent() {
                throw new IllegalStateException("getParent is unimplemented");
            }

            @NotNull
            public @Unmodifiable Collection<org.bukkit.advancement.Advancement> getChildren() {
                throw new IllegalStateException("getChildren is unimplemented");
            }

            public @NotNull org.bukkit.advancement.Advancement getRoot() {
                throw new IllegalStateException("getRoot is unimplemented");
            }
        };
    }

    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandSourceStack clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return this.baseNMS.generateHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((HelpMapMock)Bukkit.getHelpMap()));
    }

    static {
        CodeSource src = PotionEffectType.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            System.err.println("Loading PotionEffectType sources from " + String.valueOf(src.getLocation()));
        }
        advancementDataWorld = new ServerAdvancementManager(null);
    }
}

