/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentMock;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.test.Enums;
import dev.jorel.commandapi.test.MockPlatform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemFactory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Team;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockNMS
extends Enums {
    private static final SafeVarHandle<HelpMapMock, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(HelpMapMock.class, (String)"topics", (String)"topics", Map.class);
    static xg advancementDataWorld = new xg(null);
    MinecraftServer minecraftServerMock = null;
    List<abs> players = new ArrayList<abs>();
    aeh playerListMock;
    final bti recipeManager;
    Map<ww, di> functions = new HashMap<ww, di>();
    Map<ww, Collection<di>> tags = new HashMap<ww, Collection<di>>();

    public MockNMS(CommandAPIBukkit<?> baseNMS) {
        super(baseNMS);
        CommandAPIBukkit nms = (CommandAPIBukkit)Mockito.spy((Object)this.baseNMS);
        Mockito.when((Object)nms.getMinecraftServer()).thenAnswer(i -> this.getMinecraftServer());
        this.baseNMS = nms;
        ab.a();
        this.unregisterAllEnchantments();
        this.unregisterAllPotionEffects();
        wy.a();
        this.registerDefaultPotionEffects();
        this.registerDefaultEnchantments();
        this.recipeManager = new bti();
        this.functions = new HashMap<ww, di>();
        this.registerDefaultRecipes();
        this.playerListMock = (aeh)Mockito.mock(aeh.class);
        Mockito.when((Object)this.playerListMock.a(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (abs onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return onlinePlayer;
            }
            return null;
        });
    }

    private void unregisterAllPotionEffects() {
        PotionEffectType[] byId = (PotionEffectType[])MockNMS.getFieldAs(PotionEffectType.class, (String)"byId", null, PotionEffectType[].class);
        for (int i = 0; i < byId.length; ++i) {
            byId[i] = null;
        }
        ((Map)MockNMS.getFieldAs(PotionEffectType.class, (String)"byName", null, Map.class)).clear();
        MockNMS.setField(PotionEffectType.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultPotionEffects() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        MockNMS.registerPotionEffectType(1, "SPEED", false, 8171462);
        MockNMS.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        MockNMS.registerPotionEffectType(3, "HASTE", false, 14270531);
        MockNMS.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        MockNMS.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        MockNMS.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        MockNMS.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        MockNMS.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        MockNMS.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        MockNMS.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        MockNMS.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        MockNMS.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        MockNMS.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        MockNMS.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        MockNMS.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        MockNMS.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        MockNMS.registerPotionEffectType(17, "HUNGER", false, 5797459);
        MockNMS.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        MockNMS.registerPotionEffectType(19, "POISON", false, 5149489);
        MockNMS.registerPotionEffectType(20, "WITHER", false, 3484199);
        MockNMS.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        MockNMS.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        MockNMS.registerPotionEffectType(23, "SATURATION", true, 16262179);
        MockNMS.registerPotionEffectType(24, "GLOWING", false, 9740385);
        MockNMS.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        MockNMS.registerPotionEffectType(26, "LUCK", false, 0x339900);
        MockNMS.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        MockNMS.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        MockNMS.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        MockNMS.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        MockNMS.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        MockNMS.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 0x44FF44);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private static void registerPotionEffectType(int id, String name, boolean instant, int rgb) {
        PotionEffectType.registerPotionEffectType((PotionEffectType)new MockPotionEffectType(id, name, instant, Color.fromRGB((int)rgb)));
    }

    private void unregisterAllEnchantments() {
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byName", null, Map.class)).clear();
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byKey", null, Map.class)).clear();
        MockNMS.setField(Enchantment.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultEnchantments() {
        for (Enchantment enchantment : this.getEnchantments()) {
            if (Enchantment.getByKey((NamespacedKey)enchantment.getKey()) != null) continue;
            Enchantment.registerEnchantment((Enchantment)new EnchantmentMock(enchantment.getKey(), enchantment.getKey().getKey()));
        }
    }

    private void registerDefaultRecipes() {
        List<bth> recipes = this.getRecipes(MinecraftServer.class).stream().map(p -> bti.a((ww)new ww((String)p.first()), (JsonObject)((JsonObject)p.second()))).toList();
        this.recipeManager.a(recipes);
    }

    public ItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public List<String> getAllItemNames() {
        return StreamSupport.stream(gw.Z.spliterator(), false).map(Object::toString).map(s -> "minecraft:" + s).sorted().toList();
    }

    public String[] compatibleVersions() {
        return this.baseNMS.compatibleVersions();
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((ServerMock)Bukkit.getServer()).getCommandMap();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return this.baseNMS.isVanillaCommandWrapper(command);
    }

    public Command wrapToVanillaCommandWrapper(CommandNode<dl> node) {
        return this.baseNMS.wrapToVanillaCommandWrapper(node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<dl> node) {
        return this.baseNMS.isBukkitCommandWrapper(node);
    }

    public dl getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        CommandSender sender = (CommandSender)senderWrapper.getSource();
        dl css = (dl)Mockito.mock(dl.class);
        Mockito.when((Object)css.getBukkitSender()).thenReturn((Object)sender);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Location loc = player.getLocation();
            Mockito.when((Object)css.d()).thenReturn((Object)new dna(loc.getX(), loc.getY(), loc.getZ()));
            abr worldServerMock = (abr)Mockito.mock(abr.class);
            Mockito.when((Object)css.e()).thenReturn((Object)worldServerMock);
            Mockito.when((Object)css.e().D((gg)ArgumentMatchers.any(gg.class))).thenReturn((Object)true);
            Mockito.when((Object)css.e().k((gg)ArgumentMatchers.any(gg.class))).thenReturn((Object)true);
            Mockito.when((Object)css.k()).thenReturn((Object)du.a.b);
            Mockito.when((Object)css.j()).thenAnswer(s -> this.getMinecraftServer());
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                abs entityPlayerMock = (abs)Mockito.mock(abs.class);
                CraftPlayer craftPlayerMock = (CraftPlayer)Mockito.mock(CraftPlayer.class);
                String name = onlinePlayer.getName();
                UUID uuid = onlinePlayer.getUniqueId();
                Mockito.when((Object)craftPlayerMock.getName()).thenReturn((Object)name);
                Mockito.when((Object)craftPlayerMock.getUniqueId()).thenReturn((Object)uuid);
                Mockito.when((Object)entityPlayerMock.getBukkitEntity()).thenReturn((Object)craftPlayerMock);
                Mockito.when((Object)entityPlayerMock.B_()).thenReturn((Object)new pf(name));
                this.players.add(entityPlayerMock);
            }
            Mockito.when((Object)css.p()).thenAnswer(invocation -> {
                HashSet<wv> set = new HashSet<wv>();
                for (World world : Bukkit.getWorlds()) {
                    wv key = (wv)Mockito.mock(wv.class);
                    Mockito.when((Object)key.a()).thenReturn((Object)new ww(world.getName()));
                    set.add(key);
                }
                return set;
            });
            Mockito.when((Object)css.i()).thenReturn((Object)new dmz(loc.getPitch(), loc.getYaw()));
            Mockito.when((Object)css.m()).thenAnswer(invocation -> Bukkit.getScoreboardManager().getMainScoreboard().getTeams().stream().map(Team::getName).toList());
            Mockito.when((Object)css.n()).thenAnswer(invocation -> gw.T.c());
            Mockito.when((Object)css.o()).thenAnswer(invocation -> this.recipeManager.d());
            Mockito.when((Object)css.c(ArgumentMatchers.anyInt())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.hasPermission(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.a()).thenReturn((Object)css);
            Mockito.when((Object)css.b(ArgumentMatchers.anyInt())).thenReturn((Object)css);
        }
        return css;
    }

    public void createDispatcherFile(File file, CommandDispatcher dispatcher) throws IOException {
        this.baseNMS.createDispatcherFile(file, dispatcher);
    }

    public World getWorldForCSS(dl clw) {
        return new WorldMock();
    }

    public String getBukkitPotionEffectTypeName(PotionEffectType potionEffectType) {
        return asx.a((int)potionEffectType.getId()).c().replace("effect.minecraft.", "minecraft:");
    }

    public String getNMSParticleNameFromBukkit(Particle particle) {
        CraftParticle craftParticle = CraftParticle.valueOf((String)particle.name());
        return ((ww)MockPlatform.getFieldAs(CraftParticle.class, (String)"minecraftKey", (Object)craftParticle, ww.class)).toString();
    }

    public List<NamespacedKey> getAllRecipes() {
        return this.recipeManager.d().map(k -> new NamespacedKey(k.b(), k.a())).toList();
    }

    public <T> T getMinecraftServer() {
        if (this.minecraftServerMock != null) {
            return (T)this.minecraftServerMock;
        }
        this.minecraftServerMock = (MinecraftServer)Mockito.mock(MinecraftServer.class);
        Mockito.when((Object)this.minecraftServerMock.aI()).thenAnswer(invocation -> {
            dit lootTables = (dit)Mockito.mock(dit.class);
            Mockito.when((Object)lootTables.a((ww)ArgumentMatchers.any(ww.class))).thenAnswer(i -> {
                if (dik.a().contains(i.getArgument(0))) {
                    return dis.a;
                }
                return null;
            });
            Mockito.when((Object)lootTables.a()).thenAnswer(i -> Streams.concat((Stream[])new Stream[]{Arrays.stream(this.getEntityTypes()).filter(e -> !e.equals((Object)EntityType.UNKNOWN)).filter(e -> e.isAlive()).map(EntityType::getKey).map(k -> new ww("minecraft", "entities/" + k.getKey())), dik.a().stream()}).collect(Collectors.toSet()));
            return lootTables;
        });
        Mockito.when((Object)this.minecraftServerMock.az()).thenAnswer(i -> advancementDataWorld);
        xl scoreboardServerMock = (xl)Mockito.mock(xl.class);
        Mockito.when((Object)scoreboardServerMock.f(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String teamName = (String)invocation.getArgument(0);
            Team team = Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
            if (team == null) {
                return null;
            }
            return new dnw((dny)scoreboardServerMock, teamName);
        });
        Mockito.when((Object)scoreboardServerMock.d(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String objectiveName = (String)invocation.getArgument(0);
            Objective bukkitObjective = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
            if (bukkitObjective == null) {
                return null;
            }
            dob dob2 = (dob)dob.a((String)bukkitObjective.getCriteria()).get();
            pf pf2 = new pf(bukkitObjective.getDisplayName());
            return new dnv((dny)scoreboardServerMock, objectiveName, dob2, (os)pf2, switch (bukkitObjective.getRenderType()) {
                default -> throw new IncompatibleClassChangeError();
                case RenderType.HEARTS -> dob.a.b;
                case RenderType.INTEGER -> dob.a.a;
            });
        });
        Mockito.when((Object)this.minecraftServerMock.aG()).thenReturn((Object)scoreboardServerMock);
        Mockito.when((Object)this.minecraftServerMock.a((wv)ArgumentMatchers.any(wv.class))).thenAnswer(invocation -> {
            wv resourceKey = (wv)invocation.getArgument(0);
            String worldName = resourceKey.a().a();
            World world = Bukkit.getServer().getWorld(worldName);
            if (world == null) {
                return null;
            }
            CraftWorld craftWorldMock = (CraftWorld)Mockito.mock(CraftWorld.class);
            Mockito.when((Object)craftWorldMock.getName()).thenReturn((Object)world.getName());
            Mockito.when((Object)craftWorldMock.getUID()).thenReturn((Object)world.getUID());
            abr bukkitWorldServerMock = (abr)Mockito.mock(abr.class);
            Mockito.when((Object)bukkitWorldServerMock.getWorld()).thenReturn((Object)craftWorldMock);
            return bukkitWorldServerMock;
        });
        Mockito.when((Object)this.minecraftServerMock.ae()).thenAnswer(i -> this.playerListMock);
        Mockito.when((Object)this.minecraftServerMock.ae().s()).thenAnswer(i -> this.players);
        aed userCacheMock = (aed)Mockito.mock(aed.class);
        Mockito.when((Object)userCacheMock.a(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (abs onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return new GameProfile(onlinePlayer.getBukkitEntity().getUniqueId(), playerName);
            }
            return null;
        });
        Mockito.when((Object)this.minecraftServerMock.aq()).thenReturn((Object)userCacheMock);
        Mockito.when((Object)this.minecraftServerMock.aE()).thenAnswer(i -> this.recipeManager);
        Mockito.when((Object)this.minecraftServerMock.i()).thenReturn((Object)2);
        Mockito.when((Object)this.minecraftServerMock.aA()).thenAnswer(i -> {
            xh serverFunctionLibrary = (xh)Mockito.mock(xh.class);
            Mockito.when((Object)serverFunctionLibrary.a((ww)ArgumentMatchers.any())).thenAnswer(invocation -> Optional.ofNullable(this.functions.get(invocation.getArgument(0))));
            Mockito.when((Object)serverFunctionLibrary.a()).thenAnswer(invocation -> this.functions);
            Mockito.when((Object)serverFunctionLibrary.b((ww)ArgumentMatchers.any())).thenAnswer(invocation -> {
                Collection tagsFromResourceLocation = this.tags.getOrDefault(invocation.getArgument(0), List.of());
                return aga.b(Set.copyOf(tagsFromResourceLocation));
            });
            Mockito.when((Object)serverFunctionLibrary.b()).thenAnswer(invocation -> {
                HashMap<ww, aga> tagMap = new HashMap<ww, aga>();
                for (Map.Entry<ww, Collection<di>> entry : this.tags.entrySet()) {
                    tagMap.put(entry.getKey(), aga.b(Set.copyOf(entry.getValue())));
                }
                return agb.a(tagMap);
            });
            return new xi(this.minecraftServerMock, serverFunctionLibrary){

                public CommandDispatcher<dl> b() {
                    return Brigadier.getCommandDispatcher();
                }
            };
        });
        Mockito.when((Object)this.minecraftServerMock.aL()).thenAnswer(i -> new bwl());
        Mockito.when((Object)this.minecraftServerMock.aQ()).thenAnswer(i -> aqf.a.e());
        dm commands = new dm();
        MockPlatform.setField(commands.getClass(), (String)"g", (String)"dispatcher", (Object)commands, (Object)this.getBrigadierDispatcher());
        this.minecraftServerMock.vanillaCommandDispatcher = commands;
        return (T)this.minecraftServerMock;
    }

    public void addFunction(NamespacedKey key, List<String> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        ww resourceLocation = new ww(key.toString());
        dl css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        this.functions.put(resourceLocation, di.a((ww)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (dl)css, commands));
    }

    public void addTag(NamespacedKey key, List<List<String>> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        ww resourceLocation = new ww(key.toString());
        dl css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        ArrayList<di> tagFunctions = new ArrayList<di>();
        for (List<String> functionCommands : commands) {
            tagFunctions.add(di.a((ww)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (dl)css, functionCommands));
        }
        this.tags.put(resourceLocation, tagFunctions);
    }

    public Class<? extends Player> getCraftPlayerClass() {
        return CraftPlayer.class;
    }

    public Advancement addAdvancement(final NamespacedKey key) {
        MockNMS.advancementDataWorld.c.b.put(new ww(key.toString()), new ae(new ww(key.toString()), null, null, null, new HashMap(), null));
        return new Advancement(){
            final /* synthetic */ MockNMS this$0;
            {
                this.this$0 = this$0;
            }

            public NamespacedKey getKey() {
                return key;
            }

            public Collection<String> getCriteria() {
                return List.of();
            }
        };
    }

    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(dl clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return this.baseNMS.generateHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((HelpMapMock)Bukkit.getHelpMap()));
    }
}

