/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.test;

import be.seeseemelk.mockbukkit.ServerMock;
import be.seeseemelk.mockbukkit.WorldMock;
import be.seeseemelk.mockbukkit.enchantments.EnchantmentMock;
import be.seeseemelk.mockbukkit.help.HelpMapMock;
import be.seeseemelk.mockbukkit.potion.MockPotionEffectType;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.Brigadier;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.test.Enums;
import dev.jorel.commandapi.test.MockPlatform;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatComponentText;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.tags.Tag;
import net.minecraft.tags.Tags;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemFactory;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemFactory;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Team;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class MockNMS
extends Enums {
    private static final SafeVarHandle<HelpMapMock, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(HelpMapMock.class, (String)"topics", (String)"topics", Map.class);
    static AdvancementDataWorld advancementDataWorld = new AdvancementDataWorld(null);
    MinecraftServer minecraftServerMock = null;
    List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    PlayerList playerListMock;
    final CraftingManager recipeManager;
    Map<MinecraftKey, CustomFunction> functions = new HashMap<MinecraftKey, CustomFunction>();
    Map<MinecraftKey, Collection<CustomFunction>> tags = new HashMap<MinecraftKey, Collection<CustomFunction>>();

    public MockNMS(CommandAPIBukkit<?> baseNMS) {
        super(baseNMS);
        CommandAPIBukkit nms = (CommandAPIBukkit)Mockito.spy((Object)this.baseNMS);
        Mockito.when((Object)nms.getMinecraftServer()).thenAnswer(i -> this.getMinecraftServer());
        this.baseNMS = nms;
        SharedConstants.a();
        this.unregisterAllEnchantments();
        this.unregisterAllPotionEffects();
        DispenserRegistry.init();
        this.registerDefaultPotionEffects();
        this.registerDefaultEnchantments();
        this.recipeManager = new CraftingManager();
        this.functions = new HashMap<MinecraftKey, CustomFunction>();
        this.registerDefaultRecipes();
        this.playerListMock = (PlayerList)Mockito.mock(PlayerList.class);
        Mockito.when((Object)this.playerListMock.getPlayer(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (EntityPlayer onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return onlinePlayer;
            }
            return null;
        });
    }

    private void unregisterAllPotionEffects() {
        PotionEffectType[] byId = (PotionEffectType[])MockNMS.getFieldAs(PotionEffectType.class, (String)"byId", null, PotionEffectType[].class);
        for (int i = 0; i < byId.length; ++i) {
            byId[i] = null;
        }
        ((Map)MockNMS.getFieldAs(PotionEffectType.class, (String)"byName", null, Map.class)).clear();
        MockNMS.setField(PotionEffectType.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultPotionEffects() {
        for (PotionEffectType type : PotionEffectType.values()) {
            if (type == null) continue;
            return;
        }
        MockNMS.registerPotionEffectType(1, "SPEED", false, 8171462);
        MockNMS.registerPotionEffectType(2, "SLOWNESS", false, 5926017);
        MockNMS.registerPotionEffectType(3, "HASTE", false, 14270531);
        MockNMS.registerPotionEffectType(4, "MINING_FATIGUE", false, 4866583);
        MockNMS.registerPotionEffectType(5, "STRENGTH", false, 9643043);
        MockNMS.registerPotionEffectType(6, "INSTANT_HEALTH", true, 16262179);
        MockNMS.registerPotionEffectType(7, "INSTANT_DAMAGE", true, 4393481);
        MockNMS.registerPotionEffectType(8, "JUMP_BOOST", false, 2293580);
        MockNMS.registerPotionEffectType(9, "NAUSEA", false, 5578058);
        MockNMS.registerPotionEffectType(10, "REGENERATION", false, 13458603);
        MockNMS.registerPotionEffectType(11, "RESISTANCE", false, 10044730);
        MockNMS.registerPotionEffectType(12, "FIRE_RESISTANCE", false, 14981690);
        MockNMS.registerPotionEffectType(13, "WATER_BREATHING", false, 3035801);
        MockNMS.registerPotionEffectType(14, "INVISIBILITY", false, 8356754);
        MockNMS.registerPotionEffectType(15, "BLINDNESS", false, 2039587);
        MockNMS.registerPotionEffectType(16, "NIGHT_VISION", false, 0x1F1FA1);
        MockNMS.registerPotionEffectType(17, "HUNGER", false, 5797459);
        MockNMS.registerPotionEffectType(18, "WEAKNESS", false, 0x484D48);
        MockNMS.registerPotionEffectType(19, "POISON", false, 5149489);
        MockNMS.registerPotionEffectType(20, "WITHER", false, 3484199);
        MockNMS.registerPotionEffectType(21, "HEALTH_BOOST", false, 16284963);
        MockNMS.registerPotionEffectType(22, "ABSORPTION", false, 0x2552A5);
        MockNMS.registerPotionEffectType(23, "SATURATION", true, 16262179);
        MockNMS.registerPotionEffectType(24, "GLOWING", false, 9740385);
        MockNMS.registerPotionEffectType(25, "LEVITATION", false, 0xCEFFFF);
        MockNMS.registerPotionEffectType(26, "LUCK", false, 0x339900);
        MockNMS.registerPotionEffectType(27, "UNLUCK", false, 12624973);
        MockNMS.registerPotionEffectType(28, "SLOW_FALLING", false, 16773073);
        MockNMS.registerPotionEffectType(29, "CONDUIT_POWER", false, 1950417);
        MockNMS.registerPotionEffectType(30, "DOLPHINS_GRACE", false, 8954814);
        MockNMS.registerPotionEffectType(31, "BAD_OMEN", false, 745784);
        MockNMS.registerPotionEffectType(32, "HERO_OF_THE_VILLAGE", false, 0x44FF44);
        PotionEffectType.stopAcceptingRegistrations();
    }

    private static void registerPotionEffectType(int id, String name, boolean instant, int rgb) {
        PotionEffectType.registerPotionEffectType((PotionEffectType)new MockPotionEffectType(id, name, instant, Color.fromRGB((int)rgb)));
    }

    private void unregisterAllEnchantments() {
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byName", null, Map.class)).clear();
        ((Map)MockNMS.getFieldAs(Enchantment.class, (String)"byKey", null, Map.class)).clear();
        MockNMS.setField(Enchantment.class, (String)"acceptingNew", null, (Object)true);
    }

    private void registerDefaultEnchantments() {
        for (Enchantment enchantment : this.getEnchantments()) {
            if (Enchantment.getByKey((NamespacedKey)enchantment.getKey()) != null) continue;
            Enchantment.registerEnchantment((Enchantment)new EnchantmentMock(enchantment.getKey(), enchantment.getKey().getKey()));
        }
    }

    private void registerDefaultRecipes() {
        List<IRecipe> recipes = this.getRecipes(MinecraftServer.class).stream().map(p -> CraftingManager.a((MinecraftKey)new MinecraftKey((String)p.first()), (JsonObject)((JsonObject)p.second()))).toList();
        this.recipeManager.a(recipes);
    }

    public ItemFactory getItemFactory() {
        return CraftItemFactory.instance();
    }

    public List<String> getAllItemNames() {
        return StreamSupport.stream(IRegistry.Z.spliterator(), false).map(Object::toString).map(s -> "minecraft:" + s).sorted().toList();
    }

    public String[] compatibleVersions() {
        return this.baseNMS.compatibleVersions();
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((ServerMock)Bukkit.getServer()).getCommandMap();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return this.baseNMS.isVanillaCommandWrapper(command);
    }

    public Command wrapToVanillaCommandWrapper(LiteralCommandNode<CommandListenerWrapper> node) {
        return this.baseNMS.wrapToVanillaCommandWrapper(node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<CommandListenerWrapper> node) {
        return this.baseNMS.isBukkitCommandWrapper(node);
    }

    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        CommandSender sender = (CommandSender)senderWrapper.getSource();
        CommandListenerWrapper css = (CommandListenerWrapper)Mockito.mock(CommandListenerWrapper.class);
        Mockito.when((Object)css.getBukkitSender()).thenReturn((Object)sender);
        if (sender instanceof Player) {
            Player player = (Player)sender;
            Location loc = player.getLocation();
            Mockito.when((Object)css.getPosition()).thenReturn((Object)new Vec3D(loc.getX(), loc.getY(), loc.getZ()));
            WorldServer worldServerMock = (WorldServer)Mockito.mock(WorldServer.class);
            Mockito.when((Object)css.getWorld()).thenReturn((Object)worldServerMock);
            Mockito.when((Object)css.getWorld().isLoaded((BlockPosition)ArgumentMatchers.any(BlockPosition.class))).thenReturn((Object)true);
            Mockito.when((Object)css.getWorld().isValidLocation((BlockPosition)ArgumentMatchers.any(BlockPosition.class))).thenReturn((Object)true);
            Mockito.when((Object)css.k()).thenReturn((Object)ArgumentAnchor.Anchor.b);
            Mockito.when((Object)css.getServer()).thenAnswer(s -> this.getMinecraftServer());
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                EntityPlayer entityPlayerMock = (EntityPlayer)Mockito.mock(EntityPlayer.class);
                CraftPlayer craftPlayerMock = (CraftPlayer)Mockito.mock(CraftPlayer.class);
                String name = onlinePlayer.getName();
                UUID uuid = onlinePlayer.getUniqueId();
                Mockito.when((Object)craftPlayerMock.getName()).thenReturn((Object)name);
                Mockito.when((Object)craftPlayerMock.getUniqueId()).thenReturn((Object)uuid);
                Mockito.when((Object)entityPlayerMock.getBukkitEntity()).thenReturn((Object)craftPlayerMock);
                Mockito.when((Object)entityPlayerMock.getScoreboardDisplayName()).thenReturn((Object)new ChatComponentText(name));
                this.players.add(entityPlayerMock);
            }
            Mockito.when((Object)css.p()).thenAnswer(invocation -> {
                HashSet<ResourceKey> set = new HashSet<ResourceKey>();
                for (World world : Bukkit.getWorlds()) {
                    ResourceKey key = (ResourceKey)Mockito.mock(ResourceKey.class);
                    Mockito.when((Object)key.a()).thenReturn((Object)new MinecraftKey(world.getName()));
                    set.add(key);
                }
                return set;
            });
            Mockito.when((Object)css.i()).thenReturn((Object)new Vec2F(loc.getPitch(), loc.getYaw()));
            Mockito.when((Object)css.m()).thenAnswer(invocation -> Bukkit.getScoreboardManager().getMainScoreboard().getTeams().stream().map(Team::getName).toList());
            Mockito.when((Object)css.n()).thenAnswer(invocation -> IRegistry.T.keySet());
            Mockito.when((Object)css.o()).thenAnswer(invocation -> this.recipeManager.d());
            Mockito.when((Object)css.hasPermission(ArgumentMatchers.anyInt())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.hasPermission(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString())).thenAnswer(invocation -> sender.isOp());
            Mockito.when((Object)css.a()).thenReturn((Object)css);
            Mockito.when((Object)css.b(ArgumentMatchers.anyInt())).thenReturn((Object)css);
        }
        return css;
    }

    public void createDispatcherFile(File file, CommandDispatcher dispatcher) throws IOException {
        this.baseNMS.createDispatcherFile(file, dispatcher);
    }

    public World getWorldForCSS(CommandListenerWrapper clw) {
        return new WorldMock();
    }

    public String getBukkitPotionEffectTypeName(PotionEffectType potionEffectType) {
        return MobEffectList.fromId((int)potionEffectType.getId()).c().replace("effect.minecraft.", "minecraft:");
    }

    public String getNMSParticleNameFromBukkit(Particle particle) {
        CraftParticle craftParticle = CraftParticle.valueOf((String)particle.name());
        return ((MinecraftKey)MockPlatform.getFieldAs(CraftParticle.class, (String)"minecraftKey", (Object)craftParticle, MinecraftKey.class)).toString();
    }

    public List<NamespacedKey> getAllRecipes() {
        return this.recipeManager.d().map(k -> new NamespacedKey(k.getNamespace(), k.getKey())).toList();
    }

    public <T> T getMinecraftServer() {
        if (this.minecraftServerMock != null) {
            return (T)this.minecraftServerMock;
        }
        this.minecraftServerMock = (MinecraftServer)Mockito.mock(MinecraftServer.class);
        Mockito.when((Object)this.minecraftServerMock.getLootTableRegistry()).thenAnswer(invocation -> {
            LootTableRegistry lootTables = (LootTableRegistry)Mockito.mock(LootTableRegistry.class);
            Mockito.when((Object)lootTables.getLootTable((MinecraftKey)ArgumentMatchers.any(MinecraftKey.class))).thenAnswer(i -> {
                if (LootTables.a().contains(i.getArgument(0))) {
                    return LootTable.a;
                }
                return null;
            });
            Mockito.when((Object)lootTables.a()).thenAnswer(i -> Streams.concat((Stream[])new Stream[]{Arrays.stream(this.getEntityTypes()).filter(e -> !e.equals((Object)EntityType.UNKNOWN)).filter(e -> e.isAlive()).map(EntityType::getKey).map(k -> new MinecraftKey("minecraft", "entities/" + k.getKey())), LootTables.a().stream()}).collect(Collectors.toSet()));
            return lootTables;
        });
        Mockito.when((Object)this.minecraftServerMock.getAdvancementData()).thenAnswer(i -> advancementDataWorld);
        ScoreboardServer scoreboardServerMock = (ScoreboardServer)Mockito.mock(ScoreboardServer.class);
        Mockito.when((Object)scoreboardServerMock.getTeam(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String teamName = (String)invocation.getArgument(0);
            Team team = Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
            if (team == null) {
                return null;
            }
            return new ScoreboardTeam((Scoreboard)scoreboardServerMock, teamName);
        });
        Mockito.when((Object)scoreboardServerMock.getObjective(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String objectiveName = (String)invocation.getArgument(0);
            Objective bukkitObjective = Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
            if (bukkitObjective == null) {
                return null;
            }
            IScoreboardCriteria iScoreboardCriteria = (IScoreboardCriteria)IScoreboardCriteria.a((String)bukkitObjective.getCriteria()).get();
            ChatComponentText chatComponentText = new ChatComponentText(bukkitObjective.getDisplayName());
            return new ScoreboardObjective((Scoreboard)scoreboardServerMock, objectiveName, iScoreboardCriteria, (IChatBaseComponent)chatComponentText, switch (bukkitObjective.getRenderType()) {
                default -> throw new IncompatibleClassChangeError();
                case RenderType.HEARTS -> IScoreboardCriteria.EnumScoreboardHealthDisplay.b;
                case RenderType.INTEGER -> IScoreboardCriteria.EnumScoreboardHealthDisplay.a;
            });
        });
        Mockito.when((Object)this.minecraftServerMock.getScoreboard()).thenReturn((Object)scoreboardServerMock);
        Mockito.when((Object)this.minecraftServerMock.getWorldServer((ResourceKey)ArgumentMatchers.any(ResourceKey.class))).thenAnswer(invocation -> {
            ResourceKey resourceKey = (ResourceKey)invocation.getArgument(0);
            String worldName = resourceKey.a().getKey();
            World world = Bukkit.getServer().getWorld(worldName);
            if (world == null) {
                return null;
            }
            CraftWorld craftWorldMock = (CraftWorld)Mockito.mock(CraftWorld.class);
            Mockito.when((Object)craftWorldMock.getName()).thenReturn((Object)world.getName());
            Mockito.when((Object)craftWorldMock.getUID()).thenReturn((Object)world.getUID());
            WorldServer bukkitWorldServerMock = (WorldServer)Mockito.mock(WorldServer.class);
            Mockito.when((Object)bukkitWorldServerMock.getWorld()).thenReturn((Object)craftWorldMock);
            return bukkitWorldServerMock;
        });
        Mockito.when((Object)this.minecraftServerMock.getPlayerList()).thenAnswer(i -> this.playerListMock);
        Mockito.when((Object)this.minecraftServerMock.getPlayerList().getPlayers()).thenAnswer(i -> this.players);
        UserCache userCacheMock = (UserCache)Mockito.mock(UserCache.class);
        Mockito.when((Object)userCacheMock.getProfile(ArgumentMatchers.anyString())).thenAnswer(invocation -> {
            String playerName = (String)invocation.getArgument(0);
            for (EntityPlayer onlinePlayer : this.players) {
                if (!onlinePlayer.getBukkitEntity().getName().equals(playerName)) continue;
                return new GameProfile(onlinePlayer.getBukkitEntity().getUniqueId(), playerName);
            }
            return null;
        });
        Mockito.when((Object)this.minecraftServerMock.getUserCache()).thenReturn((Object)userCacheMock);
        Mockito.when((Object)this.minecraftServerMock.getCraftingManager()).thenAnswer(i -> this.recipeManager);
        Mockito.when((Object)this.minecraftServerMock.i()).thenReturn((Object)2);
        Mockito.when((Object)this.minecraftServerMock.getFunctionData()).thenAnswer(i -> {
            CustomFunctionManager serverFunctionLibrary = (CustomFunctionManager)Mockito.mock(CustomFunctionManager.class);
            Mockito.when((Object)serverFunctionLibrary.a((MinecraftKey)ArgumentMatchers.any())).thenAnswer(invocation -> Optional.ofNullable(this.functions.get(invocation.getArgument(0))));
            Mockito.when((Object)serverFunctionLibrary.a()).thenAnswer(invocation -> this.functions);
            Mockito.when((Object)serverFunctionLibrary.b((MinecraftKey)ArgumentMatchers.any())).thenAnswer(invocation -> {
                Collection tagsFromResourceLocation = this.tags.getOrDefault(invocation.getArgument(0), List.of());
                return Tag.b(Set.copyOf(tagsFromResourceLocation));
            });
            Mockito.when((Object)serverFunctionLibrary.b()).thenAnswer(invocation -> {
                HashMap<MinecraftKey, Tag> tagMap = new HashMap<MinecraftKey, Tag>();
                for (Map.Entry<MinecraftKey, Collection<CustomFunction>> entry : this.tags.entrySet()) {
                    tagMap.put(entry.getKey(), Tag.b(Set.copyOf(entry.getValue())));
                }
                return Tags.a(tagMap);
            });
            return new CustomFunctionData(this.minecraftServerMock, serverFunctionLibrary){

                public CommandDispatcher<CommandListenerWrapper> getCommandDispatcher() {
                    return Brigadier.getCommandDispatcher();
                }
            };
        });
        Mockito.when((Object)this.minecraftServerMock.getGameRules()).thenAnswer(i -> new GameRules());
        Mockito.when((Object)this.minecraftServerMock.getMethodProfiler()).thenAnswer(i -> InactiveMetricsRecorder.a.e());
        net.minecraft.commands.CommandDispatcher commands = new net.minecraft.commands.CommandDispatcher();
        MockPlatform.setField(commands.getClass(), (String)"g", (String)"dispatcher", (Object)commands, (Object)this.getBrigadierDispatcher());
        this.minecraftServerMock.vanillaCommandDispatcher = commands;
        return (T)this.minecraftServerMock;
    }

    public void addFunction(NamespacedKey key, List<String> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        MinecraftKey resourceLocation = new MinecraftKey(key.toString());
        CommandListenerWrapper css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        this.functions.put(resourceLocation, CustomFunction.a((MinecraftKey)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (CommandListenerWrapper)css, commands));
    }

    public void addTag(NamespacedKey key, List<List<String>> commands) {
        if (Bukkit.getOnlinePlayers().isEmpty()) {
            throw new IllegalStateException("You need to have at least one player on the server to add a function");
        }
        MinecraftKey resourceLocation = new MinecraftKey(key.toString());
        CommandListenerWrapper css = this.getBrigadierSourceFromCommandSender((AbstractCommandSender<? extends CommandSender>)new BukkitPlayer((Player)Bukkit.getOnlinePlayers().iterator().next()));
        ArrayList<CustomFunction> tagFunctions = new ArrayList<CustomFunction>();
        for (List<String> functionCommands : commands) {
            tagFunctions.add(CustomFunction.a((MinecraftKey)resourceLocation, (CommandDispatcher)Brigadier.getCommandDispatcher(), (CommandListenerWrapper)css, functionCommands));
        }
        this.tags.put(resourceLocation, tagFunctions);
    }

    public Class<? extends Player> getCraftPlayerClass() {
        return CraftPlayer.class;
    }

    public org.bukkit.advancement.Advancement addAdvancement(final NamespacedKey key) {
        MockNMS.advancementDataWorld.c.b.put(new MinecraftKey(key.toString()), new Advancement(new MinecraftKey(key.toString()), null, null, null, new HashMap(), null));
        return new org.bukkit.advancement.Advancement(){

            public NamespacedKey getKey() {
                return key;
            }

            public Collection<String> getCriteria() {
                return List.of();
            }
        };
    }

    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandListenerWrapper clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return this.baseNMS.generateHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((HelpMapMock)Bukkit.getHelpMap()));
    }
}

