/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.AngleArgument;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ObjectiveCriteriaArgument;
import net.minecraft.commands.arguments.OperationArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public abstract class NMS_Common
extends CommandAPIBukkit<CommandSourceStack> {
    private static NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    @Override
    public final ArgumentType<?> _ArgumentAngle() {
        return AngleArgument.angle();
    }

    @Override
    public final ArgumentType<?> _ArgumentAxis() {
        return SwizzleArgument.swizzle();
    }

    @Override
    public abstract ArgumentType<?> _ArgumentBlockPredicate();

    @Override
    public abstract ArgumentType<?> _ArgumentBlockState();

    @Override
    public final ArgumentType<?> _ArgumentChat() {
        return MessageArgument.message();
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ComponentArgument.textComponent();
    }

    @Override
    public final ArgumentType<?> _ArgumentChatFormat() {
        return ColorArgument.color();
    }

    @Override
    public ArgumentType<?> _ArgumentDimension() {
        return DimensionArgument.dimension();
    }

    @Override
    public abstract ArgumentType<?> _ArgumentEnchantment();

    @Override
    public abstract ArgumentType<?> _ArgumentEntity(ArgumentSubType var1);

    @Override
    public abstract ArgumentType<?> _ArgumentEntitySummon();

    @Override
    public final ArgumentType<?> _ArgumentFloatRange() {
        return RangeArgument.floatRange();
    }

    @Override
    public final ArgumentType<?> _ArgumentIntRange() {
        return RangeArgument.intRange();
    }

    @Override
    public abstract ArgumentType<?> _ArgumentItemPredicate();

    @Override
    public abstract ArgumentType<?> _ArgumentItemStack();

    @Override
    public final ArgumentType<?> _ArgumentMathOperation() {
        return OperationArgument.operation();
    }

    @Override
    public final ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ResourceLocationArgument.id();
    }

    @Override
    public abstract ArgumentType<?> _ArgumentMobEffect();

    @Override
    public final ArgumentType<?> _ArgumentNBTCompound() {
        return CompoundTagArgument.compoundTag();
    }

    @Override
    public abstract ArgumentType<?> _ArgumentParticle();

    @Override
    public final ArgumentType<?> _ArgumentPosition() {
        return BlockPosArgument.blockPos();
    }

    @Override
    public final ArgumentType<?> _ArgumentPosition2D() {
        return ColumnPosArgument.columnPos();
    }

    @Override
    public final ArgumentType<?> _ArgumentProfile() {
        return GameProfileArgument.gameProfile();
    }

    @Override
    public final ArgumentType<?> _ArgumentRotation() {
        return RotationArgument.rotation();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ObjectiveCriteriaArgument.criteria();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardObjective() {
        return ObjectiveArgument.objective();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardSlot() {
        return ScoreboardSlotArgument.displaySlot();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreboardTeam() {
        return TeamArgument.team();
    }

    @Override
    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ScoreHolderArgument.scoreHolder();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ScoreHolderArgument.scoreHolders();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public abstract ArgumentType<?> _ArgumentSyntheticBiome();

    @Override
    public final ArgumentType<?> _ArgumentTag() {
        return FunctionArgument.functions();
    }

    @Override
    public final ArgumentType<?> _ArgumentTime() {
        return TimeArgument.time();
    }

    @Override
    public final ArgumentType<?> _ArgumentUUID() {
        return UuidArgument.uuid();
    }

    @Override
    public final ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return Vec2Argument.vec2((boolean)centerPosition);
    }

    @Override
    public final ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return Vec3Argument.vec3((boolean)centerPosition);
    }

    @Override
    public abstract Map<String, HelpTopic> getHelpMap();

    @Override
    public abstract String[] compatibleVersions();

    @Override
    public abstract String convert(ItemStack var1);

    @Override
    public abstract String convert(ParticleData<?> var1);

    @Override
    public final String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public final String convert(Sound sound) {
        return sound.getKey().toString();
    }

    @Override
    public abstract void createDispatcherFile(File var1, CommandDispatcher<CommandSourceStack> var2) throws IOException;

    @Override
    public abstract HelpTopic generateHelpTopic(String var1, String var2, String var3, String var4);

    @Override
    public abstract Advancement getAdvancement(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public Component getAdventureChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)Component.Serializer.toJson((net.minecraft.network.chat.Component)MessageArgument.getMessage(cmdCtx, (String)key)));
    }

    @Override
    public abstract NamedTextColor getAdventureChatColor(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public final float getAngle(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return AngleArgument.getAngle(cmdCtx, (String)key);
    }

    @Override
    public final EnumSet<Axis> getAxis(CommandContext<CommandSourceStack> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = SwizzleArgument.getSwizzle(cmdCtx, (String)key);
        for (Direction.Axis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.Axis.X -> Axis.X;
                case Direction.Axis.Y -> Axis.Y;
                case Direction.Axis.Z -> Axis.Z;
            });
        }
        return set;
    }

    @Override
    public abstract Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract BlockData getBlockState(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public BaseComponent[] getChat(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)Component.Serializer.toJson((net.minecraft.network.chat.Component)MessageArgument.getMessage(cmdCtx, (String)key)));
    }

    @Override
    public final ChatColor getChatColor(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ChatColor.getByChar((char)ColorArgument.getColor(cmdCtx, (String)key).getChar());
    }

    @Override
    public final BaseComponent[] getChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ComponentSerializer.parse((String)Component.Serializer.toJson((net.minecraft.network.chat.Component)ComponentArgument.getComponent(cmdCtx, (String)key)));
    }

    @Override
    public abstract CommandSourceStack getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> var1);

    @Override
    public final BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandSourceStack css) {
        try {
            return this.wrapCommandSender(css.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public abstract World getDimension(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract Enchantment getEnchantment(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract EntityType getEntityType(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract FloatRange getFloatRange(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public abstract FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract SimpleFunctionWrapper getFunction(NamespacedKey var1);

    @Override
    public abstract Set<NamespacedKey> getFunctions();

    @Override
    public abstract IntegerRange getIntRange(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public abstract ItemStack getItemStack(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract Location2D getLocation2DBlock(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec2 vecPos = Vec2Argument.getVec2(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x, vecPos.y);
    }

    @Override
    public abstract Location getLocationBlock(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract Location getLocationPrecise(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public abstract LootTable getLootTable(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public final MathOperation getMathOperation(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        OperationArgument.getOperation(cmdCtx, (String)key);
        return MathOperation.fromString(CommandAPIHandler.getRawArgumentInput(cmdCtx, key));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return NMS_Common.fromResourceLocation(ResourceLocationArgument.getId(cmdCtx, (String)key));
    }

    @Override
    public final <NBTContainer> Object getNBTCompound(CommandContext<CommandSourceStack> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(CompoundTagArgument.getCompoundTag(cmdCtx, (String)key));
    }

    @Override
    public Objective getObjective(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ObjectiveArgument.getObjective(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public final String getObjectiveCriteria(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ObjectiveCriteriaArgument.getCriteria(cmdCtx, (String)key).getName();
    }

    @Override
    public final OfflinePlayer getOfflinePlayer(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return Bukkit.getOfflinePlayer((UUID)((GameProfile)GameProfileArgument.getGameProfiles(cmdCtx, (String)key).iterator().next()).getId());
    }

    @Override
    public abstract ParticleData<?> getParticle(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public final Player getPlayer(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)GameProfileArgument.getGameProfiles(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw GameProfileArgument.ERROR_UNKNOWN_PLAYER.create();
        }
        return target;
    }

    @Override
    public abstract Object getPotionEffect(CommandContext<CommandSourceStack> var1, String var2, ArgumentSubType var3) throws CommandSyntaxException;

    @Override
    public abstract Recipe getRecipe(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public final Rotation getRotation(CommandContext<CommandSourceStack> cmdCtx, String key) {
        Vec2 rotation = RotationArgument.getRotation(cmdCtx, (String)key).getRotation((CommandSourceStack)cmdCtx.getSource());
        return new Rotation(rotation.y, rotation.x);
    }

    @Override
    public abstract ScoreboardSlot getScoreboardSlot(CommandContext<CommandSourceStack> var1, String var2);

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ScoreHolderArgument.getNames(cmdCtx, (String)key);
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ScoreHolderArgument.getName(cmdCtx, (String)key);
    }

    @Override
    public abstract BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandSourceStack> var1, boolean var2);

    @Override
    public abstract SimpleCommandMap getSimpleCommandMap();

    @Override
    public abstract Object getSound(CommandContext<CommandSourceStack> var1, String var2, ArgumentSubType var3);

    @Override
    public abstract SuggestionProvider<CommandSourceStack> getSuggestionProvider(SuggestionProviders var1);

    @Override
    public abstract SimpleFunctionWrapper[] getTag(NamespacedKey var1);

    @Override
    public abstract Set<NamespacedKey> getTags();

    @Override
    public Team getTeam(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = TeamArgument.getTeam(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public final int getTime(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    @Override
    public final UUID getUUID(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return UuidArgument.getUuid(cmdCtx, (String)key);
    }

    @Override
    public abstract void reloadDataPacks();

    @Override
    public abstract CommandRegistrationStrategy<CommandSourceStack> createCommandRegistrationStrategy();
}

