/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandRegistrationStrategy;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.SpigotCommandRegistration;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_CommonWithFunctions;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ScoreboardSlotArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftSound;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R2.potion.CraftPotionEffectType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;

public class NMS_1_19_3_R2
extends NMS_CommonWithFunctions {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final SafeVarHandle<ItemInput, CompoundTag> itemInput;
    private static final Field serverFunctionLibraryDispatcher;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return BlockPredicateArgument.blockPredicate((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentBlockState() {
        return BlockStateArgument.block((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ENCHANTMENT);
    }

    @Override
    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> EntityArgument.entities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> EntityArgument.players();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> EntityArgument.entity();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> EntityArgument.player();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ItemPredicateArgument.itemPredicate((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentItemStack() {
        return ItemArgument.item((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentParticle() {
        return ParticleArgument.particle((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.BIOME);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.19.3"};
    }

    @Override
    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().getAsString();
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), particle.data()).writeToString();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction commandFunction) {
        ToIntFunction<CommandSourceStack> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).getFunctions().execute(commandFunction, css);
        CommandFunction.Entry[] cArr = commandFunction.getEntries();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_3_R2.fromResourceLocation(commandFunction.getId()), appliedObj, result);
    }

    @Override
    public final void createDispatcherFile(File file, CommandDispatcher<CommandSourceStack> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.serializeNodeToJson(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return ResourceLocationArgument.getAdvancement(cmdCtx, (String)key).bukkit;
    }

    @Override
    public NamedTextColor getAdventureChatColor(CommandContext<CommandSourceStack> cmdCtx, String key) {
        Integer color = ColorArgument.getColor(cmdCtx, (String)key).getColor();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    @Override
    public final Component getAdventureChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)Component.Serializer.toJson((net.minecraft.network.chat.Component)ComponentArgument.getComponent(cmdCtx, (String)key)));
    }

    @Override
    public final Object getBiome(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceArgument.getResource(cmdCtx, (String)key, (ResourceKey)Registries.BIOME).key().location();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.getPath().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_19_3_R2.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    @Override
    public final Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = BlockPredicateArgument.getBlockPredicate(cmdCtx, (String)key);
        return block -> predicate.test(new BlockInWorld((LevelReader)((CommandSourceStack)cmdCtx.getSource()).getLevel(), new BlockPos(block.getX(), block.getY(), block.getZ()), true));
    }

    @Override
    public final BlockData getBlockState(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return CraftBlockData.fromData((BlockState)BlockStateArgument.getBlock(cmdCtx, (String)key).getState());
    }

    @Override
    public CommandSourceStack getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public final World getDimension(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return DimensionArgument.getDimension(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.enchantments.Enchantment.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(BuiltInRegistries.ENCHANTMENT.getKey((Object)((Enchantment)ResourceArgument.getEnchantment(cmdCtx, (String)key).value()))));
    }

    @Override
    public final Object getEntitySelector(CommandContext<CommandSourceStack> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.findEntities((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw EntityArgument.NO_ENTITIES_FOUND.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ServerPlayer player : argument.findPlayers((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw EntityArgument.NO_PLAYERS_FOUND.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.findSingleEntity((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.findSinglePlayer((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
            }
        }
        return object;
    }

    @Override
    public final org.bukkit.entity.EntityType getEntityType(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.entity.EntityType.fromName((String)EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType(cmdCtx, (String)key).value())).getPath());
    }

    @Override
    public FloatRange getFloatRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        MinMaxBounds.Doubles range = RangeArgument.Floats.getRange(cmdCtx, (String)key);
        Double lowBoxed = (Double)range.getMin();
        Double highBoxed = (Double)range.getMax();
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandSourceStack css = ((CommandSourceStack)cmdCtx.getSource()).withSuppressedOutput().withMaximumPermission(2);
        for (CommandFunction commandFunction : FunctionArgument.getFunctions(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction(commandFunction), css, entity -> ((CommandSourceStack)cmdCtx.getSource()).withEntity(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandSourceStack> cmdCtx, String key) {
        MinMaxBounds.Ints range = RangeArgument.Ints.getRange(cmdCtx, (String)key);
        Integer lowBoxed = (Integer)range.getMin();
        Integer highBoxed = (Integer)range.getMax();
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final ItemStack getItemStack(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ItemInput input = ItemArgument.getItem(cmdCtx, (String)key);
        net.minecraft.world.item.ItemStack itemWithMaybeTag = input.createItemStack(1, false);
        CompoundTag tag = itemInput.get(input);
        if (tag != null) {
            byte count = tag.getByte("Count");
            itemWithMaybeTag = input.createItemStack((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)itemWithMaybeTag));
        return result;
    }

    @Override
    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ItemPredicateArgument.getItemPredicate(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public final Location2D getLocation2DBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ColumnPos blockPos = ColumnPosArgument.getColumnPos(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), blockPos.x(), blockPos.z());
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec2 vecPos = Vec2Argument.getVec2(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x, vecPos.y);
    }

    @Override
    public final Location getLocationBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        BlockPos blockPos = BlockPosArgument.getSpawnablePos(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    @Override
    public final Location getLocationPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec3 vecPos = Vec3Argument.getCoordinates(cmdCtx, (String)key).getPosition((CommandSourceStack)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x(), vecPos.y(), vecPos.z());
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandSourceStack> cmdCtx, String key) {
        ResourceLocation resourceLocation = ResourceLocationArgument.getId(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_19_3_R2.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).getLootTables().get(resourceLocation));
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandSourceStack> cmdCtx, String key) {
        ParticleOptions particleOptions = ParticleArgument.getParticle(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleOptions)particleOptions);
        if (particleOptions instanceof SimpleParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof BlockParticleOption) {
            BlockParticleOption options = (BlockParticleOption)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((BlockState)options.getState()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof DustParticleOptions) {
            DustParticleOptions options = (DustParticleOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.getScale()));
        }
        if (particleOptions instanceof ItemParticleOption) {
            ItemParticleOption options = (ItemParticleOption)particleOptions;
            return new ParticleData<ItemStack>(particle, CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.getItem()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.getDelay());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.roll()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.getToColor().x() * 255.0f)), (int)((int)(options.getToColor().y() * 255.0f)), (int)((int)(options.getToColor().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.getScale()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandSourceStack> cmdCtx, Particle particle, VibrationParticleOption options) {
        Vec3 origin = ((CommandSourceStack)cmdCtx.getSource()).getPosition();
        ServerLevel level = ((CommandSourceStack)cmdCtx.getSource()).getLevel();
        Location from = new Location((World)level.getWorld(), origin.x, origin.y, origin.z);
        PositionSource positionSource = options.getDestination();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.getDestination()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3 to = (Vec3)positionSource2.getPosition((Level)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.x(), to.y(), to.z()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.getArrivalInTicks()));
    }

    @Override
    public Object getPotionEffect(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> CraftPotionEffectType.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)ResourceArgument.getMobEffect(cmdCtx, (String)key).value()))));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_19_3_R2.fromResourceLocation(ResourceLocationArgument.getId(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public final org.bukkit.inventory.Recipe getRecipe(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Recipe recipe = ResourceLocationArgument.getRecipe(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_19_3_R2.fromResourceLocation(recipe.getId()), recipe.toBukkitRecipe());
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ScoreboardSlotArgument.getDisplaySlot(cmdCtx, (String)key));
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandSourceStack> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandSourceStack css = (CommandSourceStack)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3 pos = css.getPosition();
        Vec2 rot = css.getRotation();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.x(), pos.y(), pos.z(), rot.y, rot.x);
        Entity proxyEntity = css.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final Object getSound(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) {
        ResourceLocation soundResource = ResourceLocationArgument.getId(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((SoundEvent)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.getNamespace() + ":" + soundResource.getPath()));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)subType));
        };
    }

    @Override
    public SuggestionProvider<CommandSourceStack> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                ServerFunctionManager functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctions();
                SharedSuggestionProvider.suggestResource((Iterable)functionData.getTagNames(), (SuggestionsBuilder)builder, (String)"#");
                return SharedSuggestionProvider.suggestResource((Iterable)functionData.getFunctionNames(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> net.minecraft.commands.synchronization.SuggestionProviders.ALL_RECIPES;
            case SuggestionProviders.SOUNDS -> net.minecraft.commands.synchronization.SuggestionProviders.AVAILABLE_SOUNDS;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource(((MinecraftServer)this.getMinecraftServer()).getAdvancements().getAllAdvancements().stream().map(Advancement::getId), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((MinecraftServer)this.getMinecraftServer()).getLootTables().getIds(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> net.minecraft.commands.synchronization.SuggestionProviders.SUMMONABLE_ENTITIES;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.MOB_EFFECT.keySet(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).getFunctions().getTag(new ResourceLocation(key.getNamespace(), key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CommandFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction(customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ResourceLocation resourceLocation : ((MinecraftServer)this.getMinecraftServer()).getFunctions().getTagNames()) {
            result.add(NMS_1_19_3_R2.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public World getWorldForCSS(CommandSourceStack css) {
        return css.getLevel() == null ? null : css.getLevel().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).resources;
        serverResources.managers().commands = ((MinecraftServer)this.getMinecraftServer()).getCommands();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.managers().getFunctionLibrary(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).getPackRepository().getSelectedIds());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).getWorldData().getDataConfiguration().dataPacks().getDisabled();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).getPackRepository().getAvailableIds()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        RegistryAccess.Frozen registryAccess = ((MinecraftServer)this.getMinecraftServer()).registryAccess();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            PackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).getPackRepository();
            ArrayList<PackResources> packResources = new ArrayList<PackResources>();
            for (String packID : collection) {
                Pack pack = serverPackRepository.getPack(packID);
                if (pack == null) continue;
                packResources.add(pack.open());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, packResources);
            CompletableFuture simpleReloadInstance = SimpleReloadInstance.create((ResourceManager)resourceManager, (List)serverResources.managers().listeners(), (Executor)((MinecraftServer)this.getMinecraftServer()).executor, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.INSTANCE), (boolean)LogUtils.getLogger().isDebugEnabled()).done();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).resources.close();
            ((MinecraftServer)this.getMinecraftServer()).resources = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).getPackRepository().setSelected(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).getPackRepository().getSelectedIds();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).getPackRepository().getAvailableIds());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).getWorldData().setDataConfiguration(new WorldDataConfiguration(new DataPackConfig((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).getWorldData().getDataConfiguration().enabledFeatures()));
            ((MinecraftServer)this.getMinecraftServer()).resources.managers().updateRegistryTags((RegistryAccess)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).getStructureManager().onResourceManagerReload((ResourceManager)((MinecraftServer)this.getMinecraftServer()).resources.resourceManager());
        });
        if (((MinecraftServer)this.getMinecraftServer()).isSameThread()) {
            ((MinecraftServer)this.getMinecraftServer()).managedBlock(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return Component.Serializer.fromJson((String)json);
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.MOB_EFFECT);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ENTITY_TYPE);
    }

    @Override
    public CommandRegistrationStrategy<CommandSourceStack> createCommandRegistrationStrategy() {
        return new SpigotCommandRegistration<CommandSourceStack>(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.getDispatcher(), (SimpleCommandMap)this.getPaper().getCommandMap(), () -> ((MinecraftServer)this.getMinecraftServer()).getCommands().getDispatcher(), command -> command instanceof VanillaCommandWrapper, node -> new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node), node -> node.getCommand() instanceof BukkitCommandWrapper);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.configurable((RegistryAccess)server2.getServer().registryAccess(), (FeatureFlagSet)server2.getServer().getWorldData().getDataConfiguration().enabledFeatures());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        itemInput = SafeVarHandle.ofOrNull(ItemInput.class, "c", "tag", CompoundTag.class);
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(ServerFunctionLibrary.class, "g", "dispatcher");
    }
}

