/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandAPIBukkitConfig
extends CommandAPIConfig<CommandAPIBukkitConfig> {
    JavaPlugin plugin;
    boolean shouldHookPaperReload = true;
    boolean shouldUseMojangMappings = false;

    public CommandAPIBukkitConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        super.setNamespace("minecraft");
    }

    public CommandAPIBukkitConfig shouldHookPaperReload(boolean hooked) {
        this.shouldHookPaperReload = hooked;
        return this;
    }

    public CommandAPIBukkitConfig useMojangMappings(boolean useMojangMappings) {
        this.shouldUseMojangMappings = useMojangMappings;
        return this;
    }

    @Override
    public CommandAPIBukkitConfig usePluginNamespace() {
        super.setNamespace(this.plugin.getName().toLowerCase());
        this.usePluginNamespace = true;
        return this;
    }

    @Override
    public CommandAPIBukkitConfig setNamespace(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("Default namespace can't be null!");
        }
        if (namespace.isEmpty()) {
            CommandAPI.logNormal("Did not set namespace to an empty value! Namespace '" + this.namespace + "' is used as the default namespace!");
            return this;
        }
        if (!CommandAPIHandler.NAMESPACE_PATTERN.matcher(namespace).matches()) {
            CommandAPI.logNormal("Did not set namespace to the provided '" + namespace + "' namespace because only 0-9, a-z, underscores, periods and hyphens are allowed!");
            return this;
        }
        return (CommandAPIBukkitConfig)super.setNamespace(namespace);
    }

    @Override
    public CommandAPIBukkitConfig instance() {
        return this;
    }
}

