/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.executors;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public record CommandArguments(Object[] args, Map<String, Object> argsMap, String[] rawArgs, Map<String, String> rawArgsMap, String fullInput) {
    private final Map<String, Object> argsMap;
    private final Map<String, String> rawArgsMap;

    public Map<String, Object> argsMap() {
        return Collections.unmodifiableMap(this.argsMap);
    }

    public Map<String, String> rawArgsMap() {
        return Collections.unmodifiableMap(this.rawArgsMap);
    }

    @Deprecated(since="9.1.0", forRemoval=true)
    public String getFullInput() {
        return this.fullInput;
    }

    public int count() {
        return this.args.length;
    }

    @Nullable
    public Object get(int index) {
        if (this.args.length <= index) {
            return null;
        }
        return this.args[index];
    }

    @Nullable
    public Object get(String nodeName) {
        return this.argsMap.get(nodeName);
    }

    public Object getOrDefault(int index, Object defaultValue) {
        if (this.args.length <= index) {
            return defaultValue;
        }
        return this.args[index];
    }

    public Object getOrDefault(String nodeName, Object defaultValue) {
        return this.argsMap.getOrDefault(nodeName, defaultValue);
    }

    public Object getOrDefault(int index, Supplier<?> defaultValue) {
        if (this.args.length <= index) {
            return defaultValue.get();
        }
        return this.args[index];
    }

    public Object getOrDefault(String nodeName, Supplier<?> defaultValue) {
        return this.argsMap.getOrDefault(nodeName, defaultValue.get());
    }

    public Optional<Object> getOptional(int index) {
        if (this.args.length <= index) {
            return Optional.empty();
        }
        return Optional.of(this.args[index]);
    }

    public Optional<Object> getOptional(String nodeName) {
        if (!this.argsMap.containsKey(nodeName)) {
            return Optional.empty();
        }
        return Optional.of(this.argsMap.get(nodeName));
    }

    @Nullable
    public String getRaw(int index) {
        if (this.rawArgs.length <= index) {
            return null;
        }
        return this.rawArgs[index];
    }

    @Nullable
    public String getRaw(String nodeName) {
        return this.rawArgsMap.get(nodeName);
    }

    public String getOrDefaultRaw(int index, String defaultValue) {
        if (this.rawArgs.length <= index) {
            return defaultValue;
        }
        return this.rawArgs[index];
    }

    public String getOrDefaultRaw(String nodeName, String defaultValue) {
        return this.rawArgsMap.getOrDefault(nodeName, defaultValue);
    }

    public String getOrDefaultRaw(int index, Supplier<String> defaultValue) {
        if (this.rawArgs.length <= index) {
            return defaultValue.get();
        }
        return this.rawArgs[index];
    }

    public String getOrDefaultRaw(String nodeName, Supplier<String> defaultValue) {
        return this.rawArgsMap.getOrDefault(nodeName, defaultValue.get());
    }

    public Optional<String> getRawOptional(int index) {
        if (this.rawArgs.length <= index) {
            return Optional.empty();
        }
        return Optional.of(this.rawArgs[index]);
    }

    public Optional<String> getRawOptional(String nodeName) {
        if (!this.rawArgsMap.containsKey(nodeName)) {
            return Optional.empty();
        }
        return Optional.of(this.rawArgsMap.get(nodeName));
    }

    @Nullable
    public <T> T getUnchecked(int index) {
        return (T)this.get(index);
    }

    @Nullable
    public <T> T getUnchecked(String nodeName) {
        return (T)this.get(nodeName);
    }

    public <T> T getOrDefaultUnchecked(int index, T defaultValue) {
        return (T)this.getOrDefault(index, defaultValue);
    }

    public <T> T getOrDefaultUnchecked(String nodeName, T defaultValue) {
        return (T)this.getOrDefault(nodeName, defaultValue);
    }

    public <T> T getOrDefaultUnchecked(int index, Supplier<T> defaultValue) {
        return (T)this.getOrDefault(index, defaultValue);
    }

    public <T> T getOrDefaultUnchecked(String nodeName, Supplier<T> defaultValue) {
        return (T)this.getOrDefault(nodeName, defaultValue);
    }

    public <T> Optional<T> getOptionalUnchecked(int index) {
        return this.getOptional(index);
    }

    public <T> Optional<T> getOptionalUnchecked(String nodeName) {
        return this.getOptional(nodeName);
    }
}

