/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nbtapi;

import dev.jorel.commandapi.nbtapi.NBTCompound;
import dev.jorel.commandapi.nbtapi.NBTContainer;
import dev.jorel.commandapi.nbtapi.NBTReflectionUtil;
import dev.jorel.commandapi.nbtapi.NbtApiException;
import dev.jorel.commandapi.nbtapi.utils.MinecraftVersion;
import dev.jorel.commandapi.nbtapi.utils.annotations.AvailableSince;
import dev.jorel.commandapi.nbtapi.utils.annotations.CheckUtil;
import dev.jorel.commandapi.nbtapi.utils.annotations.FAUtil;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState tile) {
        super(null, null);
        if (tile == null || MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_8_R3) && !tile.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = tile;
    }

    @Override
    public Object getCompound() {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("BlockEntity NBT needs to be accessed sync!");
        }
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object compound) {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("BlockEntity NBT needs to be accessed sync!");
        }
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, compound);
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasTag("PublicBukkitValues")) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer container = new NBTContainer();
        container.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(container);
        return this.getCompound("PublicBukkitValues");
    }
}

