/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.jorel.commandapi.CommandAPIConfig;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.CommandAPILogger;
import dev.jorel.commandapi.CommandAPIPlatform;
import dev.jorel.commandapi.CommandAPIVersionHandler;
import dev.jorel.commandapi.InternalConfig;
import dev.jorel.commandapi.RegisteredCommand;
import dev.jorel.commandapi.Tooltip;
import dev.jorel.commandapi.commandsenders.AbstractPlayer;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandAPI {
    private static boolean canRegister;
    private static boolean loaded;
    private static InternalConfig config;
    private static CommandAPILogger logger;

    private CommandAPI() {
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static void stopCommandRegistration() {
        canRegister = false;
    }

    public static boolean canRegister() {
        return canRegister;
    }

    public static InternalConfig getConfiguration() {
        if (config != null) {
            return config;
        }
        throw new IllegalStateException("Tried to access InternalConfig, but it was null! Are you using CommandAPI features before calling CommandAPI#onLoad?");
    }

    public static void setLogger(CommandAPILogger logger) {
        CommandAPI.logger = logger;
    }

    public static CommandAPILogger getLogger() {
        if (logger == null) {
            logger = CommandAPIHandler.getInstance().getPlatform().getLogger();
        }
        return logger;
    }

    public static void onLoad(CommandAPIConfig<?> config) {
        if (!loaded) {
            CommandAPI.config = new InternalConfig(config);
            CommandAPIPlatform<?, ?, ?> platform = CommandAPIVersionHandler.getPlatform();
            new CommandAPIHandler(platform);
            ArrayList<String> platformClassHierarchyList = new ArrayList<String>();
            for (Class<?> platformClass = platform.getClass(); platformClass != null && platformClass != Object.class; platformClass = platformClass.getSuperclass()) {
                platformClassHierarchyList.add(platformClass.getSimpleName());
            }
            String platformClassHierarchy = String.join((CharSequence)" > ", platformClassHierarchyList);
            CommandAPI.logNormal("Loaded platform " + platformClassHierarchy);
            CommandAPIHandler.getInstance().onLoad(config);
            loaded = true;
        } else {
            CommandAPI.getLogger().severe("You've tried to call the CommandAPI's onLoad() method more than once!");
        }
    }

    public static void onEnable() {
        CommandAPIHandler.getInstance().onEnable();
    }

    public static void onDisable() {
        canRegister = true;
        config = null;
        logger = null;
        loaded = false;
        CommandAPIHandler<?, ?, ?> handler = null;
        try {
            handler = CommandAPIHandler.getInstance();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (handler != null) {
            handler.onDisable();
        }
    }

    public static void logInfo(String message) {
        if (config.hasVerboseOutput() && !config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message);
        }
    }

    public static void logNormal(String message) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().info(message);
        }
    }

    public static void logWarning(String message) {
        if (!config.hasSilentLogs()) {
            CommandAPI.getLogger().warning(message);
        }
    }

    public static void logError(String message) {
        CommandAPI.getLogger().severe(message);
    }

    public static void reloadDatapacks() {
        CommandAPIHandler.getInstance().getPlatform().reloadDataPacks();
    }

    public static <CommandSender, Player extends CommandSender> void updateRequirements(Player player) {
        CommandAPIPlatform<?, ?, ?> platform = CommandAPIHandler.getInstance().getPlatform();
        platform.updateRequirements((AbstractPlayer)platform.wrapCommandSender(player));
    }

    public static WrapperCommandSyntaxException failWithString(String message) {
        return CommandAPI.failWithMessage(Tooltip.messageFromString(message));
    }

    public static WrapperCommandSyntaxException failWithMessage(Message message) {
        return new WrapperCommandSyntaxException(new SimpleCommandExceptionType(message).create());
    }

    public static void unregister(String command) {
        CommandAPIHandler.getInstance().getPlatform().unregister(command, false);
    }

    public static void unregister(String command, boolean force) {
        if (!canRegister) {
            CommandAPI.getLogger().warning("Unexpected unregistering of /" + command + ", as server is loaded! Unregistering anyway, but this can lead to unstable results!");
        }
        CommandAPIHandler.getInstance().getPlatform().unregister(command, force);
    }

    public static void registerCommand(Class<?> commandClass) {
        try {
            Class.forName(commandClass.getName() + "$Command").getDeclaredMethod("register", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public static List<RegisteredCommand> getRegisteredCommands() {
        return Collections.unmodifiableList(CommandAPIHandler.getInstance().registeredCommands);
    }

    static {
        CommandAPI.onDisable();
    }
}

