/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nbtapi;

import dev.jorel.commandapi.nbtapi.NBTCompound;
import dev.jorel.commandapi.nbtapi.NBTContainer;
import dev.jorel.commandapi.nbtapi.NBTList;
import dev.jorel.commandapi.nbtapi.NBTType;
import dev.jorel.commandapi.nbtapi.NbtApiException;
import dev.jorel.commandapi.nbtapi.utils.UUIDUtil;
import dev.jorel.commandapi.nbtapi.utils.nmsmappings.ClassWrapper;
import dev.jorel.commandapi.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;

public class NBTUUIDList
extends NBTList<UUID> {
    private final NBTContainer tmpContainer = new NBTContainer();

    protected NBTUUIDList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(UUID object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGINTARRAY.getClazz().getDeclaredConstructor(int[].class);
            con.setAccessible(true);
            return con.newInstance(new Object[]{UUIDUtil.uuidToIntArray(object)});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public UUID get(int index) {
        try {
            Object obj = ReflectionMethod.LIST_GET.run(this.listObject, index);
            ReflectionMethod.COMPOUND_SET.run(this.tmpContainer.getCompound(), "tmp", obj);
            int[] val = this.tmpContainer.getIntArray("tmp");
            this.tmpContainer.removeKey("tmp");
            return UUIDUtil.uuidFromIntArray(val);
        }
        catch (NumberFormatException nf) {
            return null;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }
}

