/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAngle;
import net.minecraft.commands.arguments.ArgumentChat;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentChatFormat;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentMathOperation;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentNBTTag;
import net.minecraft.commands.arguments.ArgumentProfile;
import net.minecraft.commands.arguments.ArgumentScoreboardCriteria;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotationAxis;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.Vec2F;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public abstract class NMS_Common
extends CommandAPIBukkit<CommandListenerWrapper> {
    private static final Field commandDispatcher;

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentAngle() {
        return ArgumentAngle.a();
    }

    public final ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    public abstract ArgumentType<?> _ArgumentBlockPredicate();

    public abstract ArgumentType<?> _ArgumentBlockState();

    public final ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    public final ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    public abstract ArgumentType<?> _ArgumentEnchantment();

    public abstract ArgumentType<?> _ArgumentEntity(ArgumentSubType var1);

    public abstract ArgumentType<?> _ArgumentEntitySummon();

    public final ArgumentType<?> _ArgumentFloatRange() {
        return ArgumentCriterionValue.b();
    }

    public final ArgumentType<?> _ArgumentIntRange() {
        return ArgumentCriterionValue.a();
    }

    public abstract ArgumentType<?> _ArgumentItemPredicate();

    public abstract ArgumentType<?> _ArgumentItemStack();

    public final ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    public final ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    public abstract ArgumentType<?> _ArgumentMobEffect();

    public final ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    public abstract ArgumentType<?> _ArgumentParticle();

    public final ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    public final ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    public final ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    public final ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ArgumentScoreholder.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ArgumentScoreholder.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public abstract ArgumentType<?> _ArgumentSyntheticBiome();

    public final ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    public final ArgumentType<?> _ArgumentTime() {
        return ArgumentTime.a();
    }

    public final ArgumentType<?> _ArgumentUUID() {
        return ArgumentUUID.a();
    }

    public final ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return ArgumentVec2.a((boolean)centerPosition);
    }

    public final ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return ArgumentVec3.a((boolean)centerPosition);
    }

    public abstract Map<String, HelpTopic> getHelpMap();

    public abstract String[] compatibleVersions();

    public abstract String convert(ItemStack var1);

    public abstract String convert(ParticleData<?> var1);

    public final String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    public final String convert(Sound sound) {
        return sound.getKey().toString();
    }

    public abstract void createDispatcherFile(File var1, CommandDispatcher<CommandListenerWrapper> var2) throws IOException;

    public abstract HelpTopic generateHelpTopic(String var1, String var2, String var3, String var4);

    public abstract Advancement getAdvancement(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    public abstract NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> var1, String var2);

    public final float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentAngle.a(cmdCtx, (String)key);
    }

    public final EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.EnumAxis.a -> Axis.X;
                case EnumDirection.EnumAxis.b -> Axis.Y;
                case EnumDirection.EnumAxis.c -> Axis.Z;
            });
        }
        return set;
    }

    public abstract Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract BlockData getBlockState(CommandContext<CommandListenerWrapper> var1, String var2);

    public final CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        if (commandDispatcher != null) {
            return ((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a();
        }
        return this.getResourcesDispatcher();
    }

    public abstract CommandDispatcher<CommandListenerWrapper> getResourcesDispatcher();

    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    public final ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ChatColor.getByChar((char)ArgumentChatFormat.a(cmdCtx, (String)key).a());
    }

    public final BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    public abstract CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> var1);

    public final BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandListenerWrapper css) {
        try {
            return this.wrapCommandSender(css.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public abstract World getDimension(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract Enchantment getEnchantment(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract EntityType getEntityType(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract FloatRange getFloatRange(CommandContext<CommandListenerWrapper> var1, String var2);

    public abstract FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract SimpleFunctionWrapper getFunction(NamespacedKey var1);

    public abstract Set<NamespacedKey> getFunctions();

    public abstract IntegerRange getIntRange(CommandContext<CommandListenerWrapper> var1, String var2);

    public abstract ItemStack getItemStack(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public abstract Location getLocationBlock(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract Location getLocationPrecise(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public abstract LootTable getLootTable(CommandContext<CommandListenerWrapper> var1, String var2);

    public final MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentMathOperation.a(cmdCtx, (String)key);
        return MathOperation.fromString((String)CommandAPIHandler.getRawArgumentInput(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return NMS_Common.fromResourceLocation(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key));
    }

    public final <NBTContainer> Object getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(ArgumentNBTTag.a(cmdCtx, (String)key));
    }

    public Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    public final String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).d();
    }

    public final OfflinePlayer getOfflinePlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return Bukkit.getOfflinePlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
    }

    public abstract ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> var1, String var2);

    public final Player getPlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    public abstract Object getPotionEffect(CommandContext<CommandListenerWrapper> var1, String var2, ArgumentSubType var3) throws CommandSyntaxException;

    public abstract Recipe getRecipe(CommandContext<CommandListenerWrapper> var1, String var2) throws CommandSyntaxException;

    public final Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F rotation = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(rotation.j, rotation.i);
    }

    public abstract ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> var1, String var2);

    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key);
    }

    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key);
    }

    public abstract BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> var1, boolean var2);

    public abstract SimpleCommandMap getSimpleCommandMap();

    public abstract Object getSound(CommandContext<CommandListenerWrapper> var1, String var2, ArgumentSubType var3);

    public abstract SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders var1);

    public abstract SimpleFunctionWrapper[] getTag(NamespacedKey var1);

    public abstract Set<NamespacedKey> getTags();

    public Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    public final int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    public final UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentUUID.a(cmdCtx, (String)key);
    }

    public abstract boolean isVanillaCommandWrapper(Command var1);

    public abstract Command wrapToVanillaCommandWrapper(CommandNode<CommandListenerWrapper> var1);

    public abstract boolean isBukkitCommandWrapper(CommandNode<CommandListenerWrapper> var1);

    public abstract void reloadDataPacks();

    static {
        Field temporary;
        try {
            temporary = MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
        }
        catch (Exception e) {
            temporary = null;
        }
        commandDispatcher = temporary;
    }
}

