/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import org.bukkit.NamespacedKey;

public abstract class NMS_CommonWithFunctions
extends NMS_Common {
    private static NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    private SimpleFunctionWrapper convertFunction(CommandFunction commandFunction) {
        ToIntFunction<CommandSourceStack> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).getFunctions().execute(commandFunction, css);
        CommandFunction.Entry[] cArr = commandFunction.getEntries();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_CommonWithFunctions.fromResourceLocation(commandFunction.getId()), appliedObj, result);
    }

    @Override
    public abstract FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> var1, String var2) throws CommandSyntaxException;

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        ResourceLocation resourceLocation = new ResourceLocation(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).getFunctions().get(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CommandFunction)commandFunctionOptional.get());
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (ResourceLocation resourceLocation : ((MinecraftServer)this.getMinecraftServer()).getFunctions().getFunctionNames()) {
            result.add(NMS_CommonWithFunctions.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public abstract SimpleFunctionWrapper[] getTag(NamespacedKey var1);
}

