/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public abstract class NMS_Common
extends CommandAPIBukkit<dr> {
    private static NamespacedKey fromResourceLocation(aaj key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentAngle() {
        return du.a();
    }

    public final ArgumentType<?> _ArgumentAxis() {
        return fm.a();
    }

    public abstract ArgumentType<?> _ArgumentBlockPredicate();

    public abstract ArgumentType<?> _ArgumentBlockState();

    public final ArgumentType<?> _ArgumentChat() {
        return ef.a();
    }

    public final ArgumentType<?> _ArgumentChatComponent() {
        return dx.a();
    }

    public final ArgumentType<?> _ArgumentChatFormat() {
        return dw.a();
    }

    public ArgumentType<?> _ArgumentDimension() {
        return dz.a();
    }

    public abstract ArgumentType<?> _ArgumentEnchantment();

    public abstract ArgumentType<?> _ArgumentEntity(ArgumentSubType var1);

    public abstract ArgumentType<?> _ArgumentEntitySummon();

    public final ArgumentType<?> _ArgumentFloatRange() {
        return eo.b();
    }

    public final ArgumentType<?> _ArgumentIntRange() {
        return eo.a();
    }

    public abstract ArgumentType<?> _ArgumentItemPredicate();

    public abstract ArgumentType<?> _ArgumentItemStack();

    public final ArgumentType<?> _ArgumentMathOperation() {
        return el.a();
    }

    public final ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return eq.a();
    }

    public abstract ArgumentType<?> _ArgumentMobEffect();

    public final ArgumentType<?> _ArgumentNBTCompound() {
        return dy.a();
    }

    public abstract ArgumentType<?> _ArgumentParticle();

    public final ArgumentType<?> _ArgumentPosition() {
        return fh.a();
    }

    public final ArgumentType<?> _ArgumentPosition2D() {
        return fi.a();
    }

    public final ArgumentType<?> _ArgumentProfile() {
        return ed.a();
    }

    public final ArgumentType<?> _ArgumentRotation() {
        return fl.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ek.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardObjective() {
        return ej.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardSlot() {
        return et.a();
    }

    public final ArgumentType<?> _ArgumentScoreboardTeam() {
        return ex.a();
    }

    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> es.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> es.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public abstract ArgumentType<?> _ArgumentSyntheticBiome();

    public final ArgumentType<?> _ArgumentTag() {
        return fs.a();
    }

    public final ArgumentType<?> _ArgumentTime() {
        return fa.a();
    }

    public final ArgumentType<?> _ArgumentUUID() {
        return fb.a();
    }

    public final ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return fn.a((boolean)centerPosition);
    }

    public final ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return fo.a((boolean)centerPosition);
    }

    public abstract Map<String, HelpTopic> getHelpMap();

    public abstract String[] compatibleVersions();

    public abstract String convert(ItemStack var1);

    public abstract String convert(ParticleData<?> var1);

    public final String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    public final String convert(Sound sound) {
        return sound.getKey().toString();
    }

    private SimpleFunctionWrapper convertFunction(dm commandFunction) {
        ToIntFunction<dr> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).aA().a(commandFunction, css);
        dm.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_Common.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public abstract void createDispatcherFile(File var1, CommandDispatcher<dr> var2) throws IOException;

    public abstract HelpTopic generateHelpTopic(String var1, String var2, String var3, String var4);

    public abstract Advancement getAdvancement(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public final Component getAdventureChat(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)rm.a.a((rm)ef.a(cmdCtx, (String)key)));
    }

    public abstract NamedTextColor getAdventureChatColor(CommandContext<dr> var1, String var2);

    public final float getAngle(CommandContext<dr> cmdCtx, String key) {
        return du.a(cmdCtx, (String)key);
    }

    public final EnumSet<Axis> getAxis(CommandContext<dr> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = fm.a(cmdCtx, (String)key);
        for (gy.a element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case gy.a.a -> Axis.X;
                case gy.a.b -> Axis.Y;
                case gy.a.c -> Axis.Z;
            });
        }
        return set;
    }

    public abstract Predicate<Block> getBlockPredicate(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract BlockData getBlockState(CommandContext<dr> var1, String var2);

    public final CommandDispatcher<dr> getBrigadierDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a();
    }

    public abstract CommandDispatcher<dr> getResourcesDispatcher();

    public final BaseComponent[] getChat(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)rm.a.a((rm)ef.a(cmdCtx, (String)key)));
    }

    public final ChatColor getChatColor(CommandContext<dr> cmdCtx, String key) {
        return ChatColor.getByChar((char)dw.a(cmdCtx, (String)key).a());
    }

    public final BaseComponent[] getChatComponent(CommandContext<dr> cmdCtx, String key) {
        return ComponentSerializer.parse((String)rm.a.a((rm)dx.a(cmdCtx, (String)key)));
    }

    public abstract dr getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> var1);

    public final BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(dr css) {
        try {
            return this.wrapCommandSender(css.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public abstract World getDimension(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract Enchantment getEnchantment(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract EntityType getEntityType(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract FloatRange getFloatRange(CommandContext<dr> var1, String var2);

    public abstract FunctionWrapper[] getFunction(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        aaj resourceLocation = new aaj(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aA().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((dm)commandFunctionOptional.get());
        }
        throw new IllegalStateException("Failed to get defined function " + key + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (aaj resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aA().e()) {
            result.add(NMS_Common.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public abstract IntegerRange getIntRange(CommandContext<dr> var1, String var2);

    public abstract ItemStack getItemStack(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract Predicate<ItemStack> getItemStackPredicate(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract Location2D getLocation2DBlock(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public Location2D getLocation2DPrecise(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        dvs vecPos = fn.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dr)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public abstract Location getLocationBlock(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract Location getLocationPrecise(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract LootTable getLootTable(CommandContext<dr> var1, String var2);

    public final MathOperation getMathOperation(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        el.a(cmdCtx, (String)key);
        return MathOperation.fromString((String)CommandAPIHandler.getRawArgumentInput(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<dr> cmdCtx, String key) {
        return NMS_Common.fromResourceLocation(eq.e(cmdCtx, (String)key));
    }

    public final <NBTContainer> Object getNBTCompound(CommandContext<dr> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(dy.a(cmdCtx, (String)key));
    }

    public Objective getObjective(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ej.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    public final String getObjectiveCriteria(CommandContext<dr> cmdCtx, String key) {
        return ek.a(cmdCtx, (String)key).d();
    }

    public final OfflinePlayer getOfflinePlayer(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return Bukkit.getOfflinePlayer((UUID)((GameProfile)ed.a(cmdCtx, (String)key).iterator().next()).getId());
    }

    public abstract ParticleData<?> getParticle(CommandContext<dr> var1, String var2);

    public final Player getPlayer(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ed.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ed.a.create();
        }
        return target;
    }

    public abstract PotionEffectType getPotionEffect(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public abstract Recipe getRecipe(CommandContext<dr> var1, String var2) throws CommandSyntaxException;

    public final Rotation getRotation(CommandContext<dr> cmdCtx, String key) {
        dvs rotation = fl.a(cmdCtx, (String)key).b((dr)cmdCtx.getSource());
        return new Rotation(rotation.j, rotation.i);
    }

    public abstract ScoreboardSlot getScoreboardSlot(CommandContext<dr> var1, String var2);

    public final Collection<String> getScoreHolderMultiple(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return es.b(cmdCtx, (String)key);
    }

    public final String getScoreHolderSingle(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return es.a(cmdCtx, (String)key);
    }

    public abstract BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<dr> var1, boolean var2);

    public abstract SimpleCommandMap getSimpleCommandMap();

    public abstract Object getSound(CommandContext<dr> var1, String var2, ArgumentSubType var3);

    public abstract SuggestionProvider<dr> getSuggestionProvider(SuggestionProviders var1);

    public abstract SimpleFunctionWrapper[] getTag(NamespacedKey var1);

    public final Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (aaj resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aA().f()) {
            result.add(NMS_Common.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public Team getTeam(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ex.a(cmdCtx, (String)key).b();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    public final int getTime(CommandContext<dr> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    public final UUID getUUID(CommandContext<dr> cmdCtx, String key) {
        return fb.a(cmdCtx, (String)key);
    }

    public abstract boolean isVanillaCommandWrapper(Command var1);

    public abstract Command wrapToVanillaCommandWrapper(LiteralCommandNode<dr> var1);

    public abstract boolean isBukkitCommandWrapper(CommandNode<dr> var1);

    public abstract void reloadDataPacks();
}

