/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.GreedyArgument;
import dev.jorel.commandapi.arguments.PreviewInfo;
import dev.jorel.commandapi.arguments.Previewable;
import dev.jorel.commandapi.commandsenders.AbstractPlayer;
import dev.jorel.commandapi.commandsenders.BukkitPlayer;
import dev.jorel.commandapi.exceptions.SpigotNotFoundException;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.CommandArguments;
import dev.jorel.commandapi.wrappers.PreviewableFunction;
import java.util.Optional;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatArgument
extends Argument<BaseComponent[]>
implements GreedyArgument,
Previewable<ChatArgument, BaseComponent[]> {
    private PreviewableFunction<BaseComponent[]> preview;
    private boolean usePreview;

    public ChatArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentChat());
        try {
            Class.forName("org.spigotmc.SpigotConfig");
        }
        catch (ClassNotFoundException e) {
            throw new SpigotNotFoundException(this.getClass());
        }
    }

    public Class<BaseComponent[]> getPrimitiveType() {
        return BaseComponent[].class;
    }

    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.CHAT;
    }

    public <CommandSourceStack> BaseComponent[] parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        CommandSender sender = (CommandSender)CommandAPIBukkit.get().getCommandSenderFromCommandSource(cmdCtx.getSource()).getSource();
        BaseComponent[] component = CommandAPIBukkit.get().getChat(cmdCtx, key);
        Optional<PreviewableFunction<BaseComponent[]>> previewOptional = this.getPreview();
        if (this.usePreview && previewOptional.isPresent() && sender instanceof Player) {
            Player player = (Player)sender;
            try {
                BaseComponent[] previewComponent = (BaseComponent[])previewOptional.get().generatePreview(new PreviewInfo((AbstractPlayer)new BukkitPlayer(player), CommandAPIHandler.getRawArgumentInput(cmdCtx, (String)key), cmdCtx.getInput(), (Object)component));
                component = previewComponent;
            }
            catch (WrapperCommandSyntaxException e) {
                throw e.getException();
            }
        }
        return component;
    }

    public ChatArgument withPreview(PreviewableFunction<BaseComponent[]> preview) {
        this.preview = preview;
        return this;
    }

    public Optional<PreviewableFunction<BaseComponent[]>> getPreview() {
        return Optional.ofNullable(this.preview);
    }

    public boolean isLegacy() {
        return true;
    }

    public ChatArgument usePreview(boolean usePreview) {
        this.usePreview = usePreview;
        return this;
    }
}

