/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.arguments.GreedyArgument;
import dev.jorel.commandapi.executors.CommandArguments;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

public class MapArgument<K, V>
extends Argument<LinkedHashMap>
implements GreedyArgument {
    private final char delimiter;
    private final Function<String, K> keyMapper;
    private final Function<String, V> valueMapper;
    private final List<String> keyList;
    private final List<String> valueList;
    private final boolean allowValueDuplicates;
    private final boolean keyListEmpty;
    private final boolean valueListEmpty;
    private final Pattern keyPattern = Pattern.compile("([a-zA-Z0-9_\\.]+)");

    MapArgument(String nodeName, char delimiter, Function<String, K> keyMapper, Function<String, V> valueMapper, List<String> keyList, List<String> valueList, boolean allowValueDuplicates) {
        super(nodeName, (ArgumentType<?>)StringArgumentType.greedyString());
        this.delimiter = delimiter;
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
        this.keyList = keyList == null ? new ArrayList<String>() : new ArrayList<String>(keyList);
        this.valueList = valueList == null ? new ArrayList<String>() : new ArrayList<String>(valueList);
        this.allowValueDuplicates = allowValueDuplicates;
        this.keyListEmpty = keyList == null;
        this.valueListEmpty = valueList == null;
        this.applySuggestions();
    }

    private void applySuggestions() {
        super.replaceSuggestions((info, builder) -> {
            String currentArgument = info.currentArg();
            ArrayList<String> keyValues = new ArrayList<String>(this.keyList);
            ArrayList<String> valueValues = new ArrayList<String>(this.valueList);
            MapArgumentSuggestionInfo suggestionInfo = this.getSuggestionCode(currentArgument, keyValues, valueValues);
            switch (suggestionInfo.getSuggestionCode()) {
                case KEY_SUGGESTION: {
                    builder = builder.createOffset(builder.getStart() + currentArgument.length() - suggestionInfo.getCurrentKey().length());
                    for (String key : keyValues) {
                        if (!key.startsWith(suggestionInfo.getCurrentKey())) continue;
                        builder.suggest(key);
                    }
                    break;
                }
                case DELIMITER_SUGGESTION: {
                    builder = builder.createOffset(builder.getStart() + currentArgument.length());
                    builder.suggest(String.valueOf(this.delimiter));
                    break;
                }
                case QUOTATION_MARK_SUGGESTION: {
                    builder = builder.createOffset(builder.getStart() + currentArgument.length());
                    builder.suggest("\"");
                    break;
                }
                case VALUE_SUGGESTION: {
                    builder = builder.createOffset(builder.getStart() + currentArgument.length() - suggestionInfo.getCurrentValue().length());
                    for (String value : valueValues) {
                        if (!value.startsWith(suggestionInfo.getCurrentValue())) continue;
                        builder.suggest(value);
                    }
                    break;
                }
            }
            return builder.buildFuture();
        });
    }

    private MapArgumentSuggestionInfo getSuggestionCode(String currentArgument, List<String> keys, List<String> values) throws CommandSyntaxException {
        String currentKey = "";
        String currentValue = "";
        MapArgumentSuggestionInfo suggestionInfo = new MapArgumentSuggestionInfo(currentKey, currentValue, SuggestionCode.KEY_SUGGESTION);
        if (currentArgument.equals("")) {
            suggestionInfo.setSuggestionCode(SuggestionCode.KEY_SUGGESTION);
        }
        boolean isAKeyBeingBuilt = true;
        boolean isAValueBeingBuilt = false;
        boolean isFirstValueCharacter = true;
        StringBuilder keyBuilder = new StringBuilder();
        StringBuilder valueBuilder = new StringBuilder();
        StringBuilder visitedCharacters = new StringBuilder();
        char[] rawValuesChars = currentArgument.toCharArray();
        int currentIndex = -1;
        block0: for (char currentChar : rawValuesChars) {
            ++currentIndex;
            visitedCharacters.append(currentChar);
            if (isAKeyBeingBuilt) {
                currentValue = "";
                suggestionInfo.setCurrentValue(currentValue);
                if (currentChar == this.delimiter) {
                    isAKeyBeingBuilt = false;
                    isAValueBeingBuilt = true;
                    suggestionInfo.setSuggestionCode(SuggestionCode.QUOTATION_MARK_SUGGESTION);
                    continue;
                }
                if (currentChar == '\"') {
                    throw this.throwValueEarlyStart(visitedCharacters, String.valueOf(this.delimiter));
                }
                keyBuilder.append(currentChar);
                currentKey = keyBuilder.toString();
                suggestionInfo.setCurrentKey(currentKey);
                this.validateKey(visitedCharacters, this.keyPattern, keyBuilder.toString());
                for (String key : keys) {
                    if (key.equals(keyBuilder.toString())) {
                        suggestionInfo.setSuggestionCode(SuggestionCode.DELIMITER_SUGGESTION);
                        break;
                    }
                    suggestionInfo.setSuggestionCode(SuggestionCode.KEY_SUGGESTION);
                }
            }
            if (isAValueBeingBuilt) {
                if (isFirstValueCharacter) {
                    this.validateValueStart(currentChar, visitedCharacters);
                    suggestionInfo.setSuggestionCode(SuggestionCode.VALUE_SUGGESTION);
                    isFirstValueCharacter = false;
                    continue;
                }
                if (currentChar == '\\') {
                    if (rawValuesChars[currentIndex] != '\\' || rawValuesChars[currentIndex - 1] != '\\') continue;
                    valueBuilder.append('\\');
                    for (String value : values) {
                        if (value.equals(valueBuilder.toString())) {
                            suggestionInfo.setSuggestionCode(SuggestionCode.QUOTATION_MARK_SUGGESTION);
                            continue block0;
                        }
                        suggestionInfo.setSuggestionCode(SuggestionCode.VALUE_SUGGESTION);
                    }
                    continue;
                }
                if (currentChar == '\"') {
                    if (rawValuesChars[currentIndex - 1] == '\\' && rawValuesChars[currentIndex - 2] != '\\') {
                        valueBuilder.append('\"');
                        for (String value : values) {
                            if (value.equals(valueBuilder.toString())) {
                                suggestionInfo.setSuggestionCode(SuggestionCode.QUOTATION_MARK_SUGGESTION);
                                continue block0;
                            }
                            suggestionInfo.setSuggestionCode(SuggestionCode.VALUE_SUGGESTION);
                        }
                        continue;
                    }
                    currentKey = "";
                    suggestionInfo.setCurrentKey(currentKey);
                    isFirstValueCharacter = true;
                    keys.remove(keyBuilder.toString());
                    if (!this.allowValueDuplicates) {
                        values.remove(valueBuilder.toString());
                    }
                    keyBuilder.setLength(0);
                    valueBuilder.setLength(0);
                    isAValueBeingBuilt = false;
                    suggestionInfo.setSuggestionCode(SuggestionCode.KEY_SUGGESTION);
                    continue;
                }
                valueBuilder.append(currentChar);
                currentValue = valueBuilder.toString();
                suggestionInfo.setCurrentValue(currentValue);
                for (String value : values) {
                    if (value.equals(valueBuilder.toString())) {
                        suggestionInfo.setSuggestionCode(SuggestionCode.QUOTATION_MARK_SUGGESTION);
                        break;
                    }
                    suggestionInfo.setSuggestionCode(SuggestionCode.VALUE_SUGGESTION);
                }
            }
            if (isAKeyBeingBuilt || isAValueBeingBuilt || currentChar == ' ') continue;
            isAKeyBeingBuilt = true;
            keyBuilder.append(currentChar);
            suggestionInfo.setSuggestionCode(SuggestionCode.KEY_SUGGESTION);
            suggestionInfo.setCurrentKey(keyBuilder.toString());
        }
        return suggestionInfo;
    }

    public Class<LinkedHashMap> getPrimitiveType() {
        return LinkedHashMap.class;
    }

    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.MAP;
    }

    public <Source> LinkedHashMap<K, V> parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        String rawValues = (String)cmdCtx.getArgument(key, String.class);
        LinkedHashMap results = new LinkedHashMap();
        Object mapKey = null;
        Object mapValue = null;
        boolean isAKeyBeingBuilt = true;
        boolean isAValueBeingBuilt = false;
        boolean isFirstValueCharacter = true;
        StringBuilder keyValueBuffer = new StringBuilder();
        StringBuilder visitedCharacters = new StringBuilder();
        char[] rawValuesChars = rawValues.toCharArray();
        int currentIndex = -1;
        for (char currentChar : rawValuesChars) {
            ++currentIndex;
            visitedCharacters.append(currentChar);
            if (isAKeyBeingBuilt) {
                if (currentChar == this.delimiter) {
                    if (!this.keyList.contains(keyValueBuffer.toString()) && !this.keyListEmpty) {
                        throw this.throwInvalidKey(visitedCharacters, keyValueBuffer.toString(), true);
                    }
                    if (currentIndex == rawValuesChars.length - 1) {
                        throw this.missingQuotationMark(visitedCharacters);
                    }
                    try {
                        mapKey = this.keyMapper.apply(keyValueBuffer.toString());
                    }
                    catch (Exception e) {
                        throw this.cannotParseKey(visitedCharacters, keyValueBuffer);
                    }
                    if (results.containsKey(mapKey)) {
                        throw this.duplicateKey(visitedCharacters);
                    }
                    keyValueBuffer.setLength(0);
                    isAKeyBeingBuilt = false;
                    isAValueBeingBuilt = true;
                    continue;
                }
                if (currentChar == '\"') {
                    throw this.throwValueEarlyStart(visitedCharacters, String.valueOf(this.delimiter));
                }
                keyValueBuffer.append(currentChar);
                String keyValueBufferString = keyValueBuffer.toString();
                boolean isInvalidKey = this.validateKey(visitedCharacters, this.keyPattern, keyValueBufferString);
                if (currentIndex == rawValuesChars.length - 1) {
                    if (isInvalidKey) {
                        throw this.throwInvalidKey(visitedCharacters, keyValueBufferString, false);
                    }
                    throw this.missingDelimiter(visitedCharacters);
                }
            }
            if (isAValueBeingBuilt) {
                if (isFirstValueCharacter) {
                    this.validateValueStart(currentChar, visitedCharacters);
                    if (currentIndex == rawValuesChars.length - 1) {
                        throw this.missingValue(visitedCharacters);
                    }
                    isFirstValueCharacter = false;
                    continue;
                }
                if (currentChar == '\\') {
                    if (rawValuesChars[currentIndex] != '\\' || rawValuesChars[currentIndex - 1] != '\\') continue;
                    keyValueBuffer.append('\\');
                    continue;
                }
                if (currentChar == '\"') {
                    if (rawValuesChars[currentIndex - 1] == '\\' && rawValuesChars[currentIndex - 2] != '\\') {
                        keyValueBuffer.append('\"');
                        continue;
                    }
                    if (!this.valueList.contains(keyValueBuffer.toString()) && !this.valueListEmpty) {
                        throw this.throwInvalidValue(visitedCharacters, keyValueBuffer.toString());
                    }
                    try {
                        mapValue = this.valueMapper.apply(keyValueBuffer.toString());
                    }
                    catch (Exception e) {
                        throw this.cannotParseValue(visitedCharacters, keyValueBuffer);
                    }
                    if (results.containsValue(mapValue) && !this.allowValueDuplicates) {
                        throw this.duplicateValue(visitedCharacters);
                    }
                    keyValueBuffer.setLength(0);
                    isFirstValueCharacter = true;
                    results.put(mapKey, mapValue);
                    mapKey = null;
                    isAValueBeingBuilt = false;
                    continue;
                }
                keyValueBuffer.append(currentChar);
            }
            if (isAKeyBeingBuilt || isAValueBeingBuilt || currentChar == ' ') continue;
            isAKeyBeingBuilt = true;
            keyValueBuffer.append(currentChar);
        }
        this.validateValueInput(keyValueBuffer, visitedCharacters);
        return results;
    }

    private boolean validateKey(StringBuilder visitedCharacters, Pattern keyPattern, String keyValueBufferString) throws CommandSyntaxException {
        if (!keyPattern.matcher(keyValueBufferString).matches()) {
            throw this.throwInvalidKeyCharacter(visitedCharacters);
        }
        return !this.keyList.contains(keyValueBufferString) && !this.keyListEmpty;
    }

    private void validateValueStart(char currentChar, StringBuilder visitedCharacters) throws CommandSyntaxException {
        if (currentChar != '\"') {
            String context = visitedCharacters.toString();
            StringReader reader = new StringReader(context.substring(0, context.length() - 1));
            reader.setCursor(context.substring(0, context.length() - 1).length());
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"A value must start with a quotation mark");
        }
    }

    private void validateValueInput(StringBuilder valueBuilder, StringBuilder visitedCharacters) throws CommandSyntaxException {
        if (valueBuilder.length() != 0) {
            StringReader reader = new StringReader(visitedCharacters.toString());
            reader.setCursor(visitedCharacters.toString().length());
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"A value must end with a quotation mark");
        }
    }

    private CommandSyntaxException throwInvalidKeyCharacter(StringBuilder visitedCharacters) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context);
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"A key must only contain letters from a-z and A-Z, numbers, underscores and periods");
    }

    private CommandSyntaxException throwValueEarlyStart(StringBuilder visitedCharacters, String delimiter) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context);
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)("You must separate a key/value pair with a '" + delimiter + "'"));
    }

    private CommandSyntaxException throwInvalidKey(StringBuilder visitedCharacters, String key, boolean cutLastCharacter) {
        String context = visitedCharacters.toString();
        StringReader reader = cutLastCharacter ? new StringReader(context.substring(0, context.length() - 1)) : new StringReader(context);
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)("Invalid key: " + key));
    }

    private CommandSyntaxException throwInvalidValue(StringBuilder visitedCharacters, String value) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context.substring(0, context.length() - 1));
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)("Invalid value: " + value));
    }

    private CommandSyntaxException duplicateKey(StringBuilder visitedCharacters) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context.substring(0, context.length() - 1));
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"Duplicate keys are not allowed");
    }

    private CommandSyntaxException duplicateValue(StringBuilder visitedCharacters) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context.substring(0, context.length() - 1));
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"Duplicate values are not allowed here");
    }

    private CommandSyntaxException missingDelimiter(StringBuilder visitedCharacters) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context);
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"Delimiter required after writing a key");
    }

    private CommandSyntaxException missingQuotationMark(StringBuilder visitedCharacters) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context);
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"Quotation mark required after writing the delimiter");
    }

    private CommandSyntaxException missingValue(StringBuilder visitedCharacters) {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context);
        reader.setCursor(context.length());
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)"Value required after opening quotation mark");
    }

    private CommandSyntaxException cannotParseKey(StringBuilder visitedCharacters, StringBuilder keyValueBuffer) throws CommandSyntaxException {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context.substring(0, context.length() - 1));
        reader.setCursor(context.length() - 1);
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)("Invalid key (" + keyValueBuffer + "): cannot be converted to a key"));
    }

    private CommandSyntaxException cannotParseValue(StringBuilder visitedCharacters, StringBuilder keyValueBuffer) throws CommandSyntaxException {
        String context = visitedCharacters.toString();
        StringReader reader = new StringReader(context);
        reader.setCursor(context.length());
        throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().createWithContext((ImmutableStringReader)reader, (Object)("Invalid value (" + keyValueBuffer + "): cannot be converted to a value"));
    }

    private static class MapArgumentSuggestionInfo {
        private String currentKey;
        private String currentValue;
        private SuggestionCode suggestionCode;

        MapArgumentSuggestionInfo(String currentKey, String currentValue, SuggestionCode suggestionCode) {
            this.currentKey = currentKey;
            this.currentValue = currentValue;
            this.suggestionCode = suggestionCode;
        }

        public String getCurrentKey() {
            return this.currentKey;
        }

        public void setCurrentKey(String currentKey) {
            this.currentKey = currentKey;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }

        public SuggestionCode getSuggestionCode() {
            return this.suggestionCode;
        }

        public void setSuggestionCode(SuggestionCode suggestionCode) {
            this.suggestionCode = suggestionCode;
        }
    }

    private static enum SuggestionCode {
        KEY_SUGGESTION,
        DELIMITER_SUGGESTION,
        QUOTATION_MARK_SUGGESTION,
        VALUE_SUGGESTION;

    }
}

