/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R3.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftSound;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R3.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R3.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_19_4_R3
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final SafeVarHandle<fu, re> itemInput;
    private static final Field serverFunctionLibraryDispatcher;
    private static final dl COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(add key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return fd.a((dl)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return fe.a((dl)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return en.a((dl)COMMAND_BUILD_CONTEXT, (adc)jb.q);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> eb.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> eb.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> eb.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> eb.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return fw.a((dl)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return ft.a((dl)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return el.a((dl)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return en.a((dl)COMMAND_BUILD_CONTEXT, (adc)jb.an);
    }

    public final Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.19.4"};
    }

    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).v().f_();
    }

    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private final SimpleFunctionWrapper convertFunction(dm commandFunction) {
        ToIntFunction<dr> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).aA().a(commandFunction, css);
        dm.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_4_R3.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<dr> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)gh.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return ep.a(cmdCtx, (String)key).bukkit;
    }

    public NamedTextColor getAdventureChatColor(CommandContext<dr> cmdCtx, String key) {
        Integer color = dw.a(cmdCtx, (String)key).f();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public final Component getAdventureChatComponent(CommandContext<dr> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)tj.a.a((tj)dx.a(cmdCtx, (String)key)));
    }

    public final Object getBiome(CommandContext<dr> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        add resourceLocation = en.a(cmdCtx, (String)key, (adc)jb.an).g().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_19_4_R3.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fd.a(cmdCtx, (String)key);
        return block -> predicate.test(new dbu((cml)((dr)cmdCtx.getSource()).e(), new gt(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<dr> cmdCtx, String key) {
        return CraftBlockData.fromData((dbq)fe.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<dr> getResourcesDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).aC().a();
    }

    public dr getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final World getDimension(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return dz.a(cmdCtx, (String)key).getWorld();
    }

    public final Enchantment getEnchantment(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_1_19_4_R3.fromResourceLocation(ja.g.b((Object)((ckc)en.g(cmdCtx, (String)key).a()))));
    }

    public final Object getEntitySelector(CommandContext<dr> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        fz argument = (fz)cmdCtx.getArgument(str, fz.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (bfh entity : argument.b((dr)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (aiq player : argument.d((dr)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dr)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dr)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final EntityType getEntityType(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)bfl.a((bfl)((bfl)en.e(cmdCtx, (String)key).a())).a());
    }

    public FloatRange getFloatRange(CommandContext<dr> cmdCtx, String key) {
        ci.c range = em.a.a(cmdCtx, (String)key);
        Double lowBoxed = (Double)range.a();
        Double highBoxed = (Double)range.b();
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public final FunctionWrapper[] getFunction(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dr css = ((dr)cmdCtx.getSource()).a().b(2);
        for (dm commandFunction : fs.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dr)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public IntegerRange getIntRange(CommandContext<dr> cmdCtx, String key) {
        ci.d range = em.b.a(cmdCtx, (String)key);
        Integer lowBoxed = (Integer)range.a();
        Integer highBoxed = (Integer)range.b();
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public final ItemStack getItemStack(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        fu input = ft.a(cmdCtx, (String)key);
        cfv itemWithMaybeTag = input.a(1, false);
        re tag = (re)itemInput.get((Object)input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((cfv)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((cfv)itemWithMaybeTag));
        return result;
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fw.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public final Location2D getLocation2DBlock(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        aig blockPos = fi.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dr)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        edd vecPos = fn.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dr)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        gt blockPos = fh.c(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((dr)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        ede vecPos = fo.b(cmdCtx, (String)key).a((dr)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dr)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<dr> cmdCtx, String key) {
        add resourceLocation = ep.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_19_4_R3.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aH().a(resourceLocation));
    }

    public final ParticleData<?> getParticle(CommandContext<dr> cmdCtx, String key) {
        is particleOptions = el.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((is)particleOptions);
        if (particleOptions instanceof ix) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof im) {
            im options = (im)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((dbq)options.c()));
        }
        if (particleOptions instanceof in) {
            in options = (in)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof io) {
            io options = (io)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof iq) {
            iq options = (iq)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((cfv)options.c()));
        }
        if (particleOptions instanceof iy) {
            iy options = (iy)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof iw) {
            iw options = (iw)particleOptions;
            return new ParticleData(particle, (Object)options.c());
        }
        if (particleOptions instanceof iv) {
            iv options = (iv)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, in options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<dr> cmdCtx, Particle particle, iy options) {
        ede origin = ((dr)cmdCtx.getSource()).d();
        aip level = ((dr)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        dge dge2 = options.c();
        if (!(dge2 instanceof dfw)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + options.c());
            return new ParticleData(particle, null);
        }
        dfw positionSource = (dfw)dge2;
        ede to = (ede)positionSource.a((cmi)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.d()));
    }

    public PotionEffectType getPotionEffect(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_19_4_R3.fromResourceLocation(ja.e.b((Object)((bew)en.f(cmdCtx, (String)key).a()))));
    }

    public final Recipe getRecipe(CommandContext<dr> cmdCtx, String key) throws CommandSyntaxException {
        ciy recipe = ep.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_19_4_R3.fromResourceLocation(recipe.e()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<dr> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)et.a(cmdCtx, (String)key));
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<dr> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dr css = (dr)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        ede pos = css.d();
        edd rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        bfh proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<dr> cmdCtx, String key, ArgumentSubType subType) {
        add soundResource = ep.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                amq soundEvent = (amq)ja.c.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((amq)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SuggestionProvider<dr> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                adr functionData = ((MinecraftServer)this.getMinecraftServer()).aA();
                dt.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return dt.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> gj.b;
            case SuggestionProviders.SOUNDS -> gj.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dt.a(((MinecraftServer)this.getMinecraftServer()).az().a().stream().map(ae::i), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dt.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aH().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> gj.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).aA().b(new add(key.getNamespace(), key.getKey()));
        return customFunctions.toArray(new SimpleFunctionWrapper[0]);
    }

    public World getWorldForCSS(dr css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public final boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public Command wrapToVanillaCommandWrapper(LiteralCommandNode<dr> node) {
        return new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<dr> node) {
        return node.getCommand() instanceof BukkitCommandWrapper;
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = ((MinecraftServer)this.getMinecraftServer()).au;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aC();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aB().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aW().F().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aB().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        hr.b registryAccess = ((MinecraftServer)this.getMinecraftServer()).aX();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            aks serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aB();
            ArrayList<ajv> packResources = new ArrayList<ajv>();
            for (String packID : collection) {
                akq pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ala resourceManager = new ala(ajw.b, packResources);
            CompletableFuture simpleReloadInstance = aln.a((alh)resourceManager, (List)serverResources.b().h(), (Executor)((MinecraftServer)this.getMinecraftServer()).as, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(aqi.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).au.close();
            ((MinecraftServer)this.getMinecraftServer()).au = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aB().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aB().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aB().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aW().a(new cna(new clw((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).aW().F().b()));
            ((MinecraftServer)this.getMinecraftServer()).au.b().a((hr)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aV().a((alh)((MinecraftServer)this.getMinecraftServer()).au.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bn()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return tj.a.a((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return en.a((dl)COMMAND_BUILD_CONTEXT, (adc)jb.N);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return en.a((dl)COMMAND_BUILD_CONTEXT, (adc)jb.r);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = dl.a((hr)server2.getServer().aX(), (cau)server2.getServer().aW().F().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(fz.class, (String)"p", (String)"usesSelector");
        itemInput = SafeVarHandle.ofOrNull(fu.class, (String)"c", (String)"tag", re.class);
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(adq.class, (String)"g", (String)"dispatcher");
    }
}

