/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerFunctionLibrary;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftSound;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_19_3_R2
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final SafeVarHandle<ItemInput, CompoundTag> itemInput;
    private static final CommandBuildContext COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return BlockPredicateArgument.blockPredicate((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return BlockStateArgument.block((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ENCHANTMENT);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> EntityArgument.entities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> EntityArgument.players();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> EntityArgument.entity();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> EntityArgument.player();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return ItemPredicateArgument.itemPredicate((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return ItemArgument.item((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return ParticleArgument.particle((CommandBuildContext)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.BIOME);
    }

    public final void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        ((Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getServer().getHelpMap()))).putAll(helpTopicsToAdd);
    }

    public String[] compatibleVersions() {
        return new String[]{"1.19.3"};
    }

    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().getAsString();
    }

    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).writeToString();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction commandFunction) {
        ToIntFunction<CommandSourceStack> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).getFunctions().execute(commandFunction, css);
        CommandFunction.Entry[] cArr = commandFunction.getEntries();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_3_R2.fromResourceLocation(commandFunction.getId()), appliedObj, result);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<CommandSourceStack> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentUtils.serializeNodeToJson(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public final Component getAdventureChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)Component.Serializer.toJson((net.minecraft.network.chat.Component)ComponentArgument.getComponent(cmdCtx, (String)key)));
    }

    public final Object getBiome(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        ResourceLocation resourceLocation = ResourceArgument.getResource(cmdCtx, (String)key, (ResourceKey)Registries.BIOME).key().location();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.getPath().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_19_3_R2.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = BlockPredicateArgument.getBlockPredicate(cmdCtx, (String)key);
        return block -> predicate.test(new BlockInWorld((LevelReader)((CommandSourceStack)cmdCtx.getSource()).getLevel(), new BlockPos(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return CraftBlockData.fromData((BlockState)BlockStateArgument.getBlock(cmdCtx, (String)key).getState());
    }

    public final CommandDispatcher<CommandSourceStack> getBrigadierDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.getDispatcher();
    }

    public CommandSourceStack getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final World getDimension(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return DimensionArgument.getDimension(cmdCtx, (String)key).getWorld();
    }

    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.enchantments.Enchantment.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(BuiltInRegistries.ENCHANTMENT.getKey((Object)((Enchantment)ResourceArgument.getEnchantment(cmdCtx, (String)key).value()))));
    }

    public final Object getEntitySelector(CommandContext<CommandSourceStack> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            CommandAPIHandler.getField(EntitySelector.class, (String)"p", (String)"usesSelector").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.findEntities((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ServerPlayer player : argument.findPlayers((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.findSingleEntity((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.findSinglePlayer((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final org.bukkit.entity.EntityType getEntityType(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return org.bukkit.entity.EntityType.fromName((String)EntityType.getKey((EntityType)((EntityType)ResourceArgument.getSummonableEntityType(cmdCtx, (String)key).value())).getPath());
    }

    public final FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandSourceStack css = ((CommandSourceStack)cmdCtx.getSource()).withSuppressedOutput().withMaximumPermission(2);
        for (CommandFunction commandFunction : FunctionArgument.getFunctions(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((CommandSourceStack)cmdCtx.getSource()).withEntity(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public final ItemStack getItemStack(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ItemInput input = ItemArgument.getItem(cmdCtx, (String)key);
        net.minecraft.world.item.ItemStack itemWithMaybeTag = input.createItemStack(1, false);
        CompoundTag tag = (CompoundTag)itemInput.get((Object)input);
        if (tag != null) {
            byte count = tag.getByte("Count");
            itemWithMaybeTag = input.createItemStack((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)itemWithMaybeTag));
        return result;
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ItemPredicateArgument.getItemPredicate(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public final Location2D getLocation2DBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ColumnPos blockPos = ColumnPosArgument.getColumnPos(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPos.x(), (double)blockPos.z());
    }

    public final Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec2 vecPos = Vec2Argument.getVec2(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)vecPos.x, (double)vecPos.y);
    }

    public final Location getLocationBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        BlockPos blockPos = BlockPosArgument.getSpawnablePos(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    public final Location getLocationPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec3 vecPos = Vec3Argument.getCoordinates(cmdCtx, (String)key).getPosition((CommandSourceStack)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x(), vecPos.y(), vecPos.z());
    }

    public final LootTable getLootTable(CommandContext<CommandSourceStack> cmdCtx, String key) {
        ResourceLocation resourceLocation = ResourceLocationArgument.getId(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_19_3_R2.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).getLootTables().get(resourceLocation));
    }

    public final ParticleData<?> getParticle(CommandContext<CommandSourceStack> cmdCtx, String key) {
        ParticleOptions particleOptions = ParticleArgument.getParticle(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleOptions)particleOptions);
        if (particleOptions instanceof SimpleParticleType) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof BlockParticleOption) {
            BlockParticleOption options = (BlockParticleOption)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((BlockState)options.getState()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof DustParticleOptions) {
            DustParticleOptions options = (DustParticleOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.getScale()));
        }
        if (particleOptions instanceof ItemParticleOption) {
            ItemParticleOption options = (ItemParticleOption)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.getItem()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData(particle, (Object)options.getDelay());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.roll()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.getToColor().x() * 255.0f)), (int)((int)(options.getToColor().y() * 255.0f)), (int)((int)(options.getToColor().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.getScale()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandSourceStack> cmdCtx, Particle particle, VibrationParticleOption options) {
        Vec3 origin = ((CommandSourceStack)cmdCtx.getSource()).getPosition();
        ServerLevel level = ((CommandSourceStack)cmdCtx.getSource()).getLevel();
        Location from = new Location((World)level.getWorld(), origin.x, origin.y, origin.z);
        PositionSource positionSource = options.getDestination();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + options.getDestination());
            return new ParticleData(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3 to = (Vec3)positionSource2.getPosition((Level)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.x(), to.y(), to.z()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.getArrivalInTicks()));
    }

    public PotionEffectType getPotionEffect(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)ResourceArgument.getMobEffect(cmdCtx, (String)key).value()))));
    }

    public final org.bukkit.inventory.Recipe getRecipe(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Recipe recipe = ResourceLocationArgument.getRecipe(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_19_3_R2.fromResourceLocation(recipe.getId()), recipe.toBukkitRecipe());
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandSourceStack> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandSourceStack css = (CommandSourceStack)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3 pos = css.getPosition();
        Vec2 rot = css.getRotation();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.x(), pos.y(), pos.z(), rot.y, rot.x);
        Entity proxyEntity = css.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<CommandSourceStack> cmdCtx, String key, ArgumentSubType subType) {
        ResourceLocation soundResource = ResourceLocationArgument.getId(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                SoundEvent soundEvent = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((SoundEvent)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.getNamespace() + ":" + soundResource.getPath()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SuggestionProvider<CommandSourceStack> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                ServerFunctionManager functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctions();
                SharedSuggestionProvider.suggestResource((Iterable)functionData.getTagNames(), (SuggestionsBuilder)builder, (String)"#");
                return SharedSuggestionProvider.suggestResource((Iterable)functionData.getFunctionNames(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> net.minecraft.commands.synchronization.SuggestionProviders.ALL_RECIPES;
            case SuggestionProviders.SOUNDS -> net.minecraft.commands.synchronization.SuggestionProviders.AVAILABLE_SOUNDS;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource(((MinecraftServer)this.getMinecraftServer()).getAdvancements().getAllAdvancements().stream().map(Advancement::getId), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)((MinecraftServer)this.getMinecraftServer()).getLootTables().getIds(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> net.minecraft.commands.synchronization.SuggestionProviders.SUMMONABLE_ENTITIES;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).getFunctions().getTag(new ResourceLocation(key.getNamespace(), key.getKey()));
        return customFunctions.toArray(new SimpleFunctionWrapper[0]);
    }

    public World getWorldForCSS(CommandSourceStack css) {
        return css.getLevel() == null ? null : css.getLevel().getWorld();
    }

    public final boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).resources;
        serverResources.managers().commands = ((MinecraftServer)this.getMinecraftServer()).getCommands();
        try {
            CommandAPIHandler.getField(ServerFunctionLibrary.class, (String)"g", (String)"dispatcher").set(serverResources.managers().getFunctionLibrary(), this.getBrigadierDispatcher());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).getPackRepository().getSelectedIds());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).getWorldData().getDataConfiguration().dataPacks().getDisabled();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).getPackRepository().getAvailableIds()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        RegistryAccess.Frozen registryAccess = ((MinecraftServer)this.getMinecraftServer()).registryAccess();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            PackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).getPackRepository();
            ArrayList<PackResources> packResources = new ArrayList<PackResources>();
            for (String packID : collection) {
                Pack pack = serverPackRepository.getPack(packID);
                if (pack == null) continue;
                packResources.add(pack.open());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            MultiPackResourceManager resourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, packResources);
            CompletableFuture simpleReloadInstance = SimpleReloadInstance.create((ResourceManager)resourceManager, (List)serverResources.managers().listeners(), (Executor)((MinecraftServer)this.getMinecraftServer()).executor, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.INSTANCE), (boolean)LogUtils.getLogger().isDebugEnabled()).done();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).resources.close();
            ((MinecraftServer)this.getMinecraftServer()).resources = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).getPackRepository().setSelected(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).getPackRepository().getSelectedIds();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).getPackRepository().getAvailableIds());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).getWorldData().setDataConfiguration(new WorldDataConfiguration(new DataPackConfig((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).getWorldData().getDataConfiguration().enabledFeatures()));
            ((MinecraftServer)this.getMinecraftServer()).resources.managers().updateRegistryTags((RegistryAccess)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).getStructureManager().onResourceManagerReload((ResourceManager)((MinecraftServer)this.getMinecraftServer()).resources.resourceManager());
        });
        if (((MinecraftServer)this.getMinecraftServer()).isSameThread()) {
            ((MinecraftServer)this.getMinecraftServer()).managedBlock(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public final void resendPackets(Player player) {
        ((MinecraftServer)this.getMinecraftServer()).getCommands().sendCommands(((CraftPlayer)player).getHandle());
    }

    public Message generateMessageFromJson(String json) {
        return Component.Serializer.fromJson((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.MOB_EFFECT);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.resource((CommandBuildContext)COMMAND_BUILD_CONTEXT, (ResourceKey)Registries.ENTITY_TYPE);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = CommandBuildContext.configurable((RegistryAccess)server2.getServer().registryAccess(), (FeatureFlagSet)server2.getServer().getWorldData().getDataConfiguration().enabledFeatures());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        itemInput = SafeVarHandle.ofOrNull(ItemInput.class, (String)"c", (String)"tag", CompoundTag.class);
    }
}

