/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftSound;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_19_3_R2
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final SafeVarHandle<fq, qp> itemInput;
    private static final di COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(acf key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ez.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return fa.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.p);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> dy.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> dy.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> dy.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> dy.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return fs.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return fp.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return eh.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.al);
    }

    public final void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        ((Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getServer().getHelpMap()))).putAll(helpTopicsToAdd);
    }

    public String[] compatibleVersions() {
        return new String[]{"1.19.3"};
    }

    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).v().f_();
    }

    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private final SimpleFunctionWrapper convertFunction(dj commandFunction) {
        ToIntFunction<dn> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).az().a(commandFunction, css);
        dj.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_3_R2.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<dn> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)gd.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public final Component getAdventureChatComponent(CommandContext<dn> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)ss.a.a((ss)du.a(cmdCtx, (String)key)));
    }

    public final Object getBiome(CommandContext<dn> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        acf resourceLocation = ej.a(cmdCtx, (String)key, (ace)ix.al).g().a();
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var5_7 = biome;
                yield var5_7;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var5_8;
                yield var5_8 = NMS_1_19_3_R2.fromResourceLocation(resourceLocation);
            }
            default -> {
                NamespacedKey var5_9;
                yield var5_9 = null;
            }
        };
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ez.a(cmdCtx, (String)key);
        return block -> predicate.test(new cyx((cjz)((dn)cmdCtx.getSource()).e(), new gp(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<dn> cmdCtx, String key) {
        return CraftBlockData.fromData((cyt)fa.a(cmdCtx, (String)key).a());
    }

    public final CommandDispatcher<dn> getBrigadierDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a();
    }

    public dn getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)sender.getSource()));
    }

    public final World getDimension(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return dw.a(cmdCtx, (String)key).getWorld();
    }

    public final Enchantment getEnchantment(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(iw.g.b((Object)((chq)ej.g(cmdCtx, (String)key).a()))));
    }

    public final Object getEntitySelector(CommandContext<dn> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        fv argument = (fv)cmdCtx.getArgument(str, fv.class);
        try {
            CommandAPIHandler.getField(fv.class, (String)"p", (String)"usesSelector").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (bdr entity : argument.b((dn)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ahn player : argument.d((dn)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dn)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dn)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final EntityType getEntityType(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)bdv.a((bdv)((bdv)ej.e(cmdCtx, (String)key).a())).a());
    }

    public final FunctionWrapper[] getFunction(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dn css = ((dn)cmdCtx.getSource()).a().b(2);
        for (dj commandFunction : fo.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dn)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public final ItemStack getItemStack(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        fq input = fp.a(cmdCtx, (String)key);
        cdt itemWithMaybeTag = input.a(1, false);
        qp tag = (qp)itemInput.get((Object)input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((cdt)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((cdt)itemWithMaybeTag));
        return result;
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fs.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public final Location2D getLocation2DBlock(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        ahd blockPos = fe.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dn)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        ead vecPos = fj.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dn)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        gp blockPos = fd.b(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((dn)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        eae vecPos = fk.b(cmdCtx, (String)key).a((dn)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dn)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<dn> cmdCtx, String key) {
        acf resourceLocation = el.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_19_3_R2.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aG().a(resourceLocation));
    }

    public final ParticleData<?> getParticle(CommandContext<dn> cmdCtx, String key) {
        io particleOptions = eh.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((io)particleOptions);
        if (particleOptions instanceof it) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof ii) {
            ii options = (ii)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((cyt)options.c()));
        }
        if (particleOptions instanceof ij) {
            ij options = (ij)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ik) {
            ik options = (ik)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof im) {
            im options = (im)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((cdt)options.c()));
        }
        if (particleOptions instanceof iu) {
            iu options = (iu)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof is) {
            is options = (is)particleOptions;
            return new ParticleData(particle, (Object)options.c());
        }
        if (particleOptions instanceof ir) {
            ir options = (ir)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, ij options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<dn> cmdCtx, Particle particle, iu options) {
        eae origin = ((dn)cmdCtx.getSource()).d();
        ahm level = ((dn)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        ddg ddg2 = options.c();
        if (!(ddg2 instanceof dcy)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + options.c());
            return new ParticleData(particle, null);
        }
        dcy positionSource = (dcy)ddg2;
        eae to = (eae)positionSource.a((cjw)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.d()));
    }

    public PotionEffectType getPotionEffect(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(iw.e.b((Object)((bdi)ej.f(cmdCtx, (String)key).a()))));
    }

    public final Recipe getRecipe(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        cgo recipe = el.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_19_3_R2.fromResourceLocation(recipe.f()), recipe.toBukkitRecipe());
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<dn> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dn css = (dn)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        eae pos = css.d();
        ead rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        bdr proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<dn> cmdCtx, String key, ArgumentSubType subType) {
        acf soundResource = el.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                aln soundEvent = (aln)iw.c.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((aln)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SuggestionProvider<dn> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                act functionData = ((MinecraftServer)this.getMinecraftServer()).az();
                dq.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return dq.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> gf.b;
            case SuggestionProviders.SOUNDS -> gf.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dq.a(((MinecraftServer)this.getMinecraftServer()).ay().a().stream().map(ac::h), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dq.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aG().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> gf.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = ((MinecraftServer)this.getMinecraftServer()).az().b(new acf(key.getNamespace(), key.getKey()));
        return customFunctions.toArray(new SimpleFunctionWrapper[0]);
    }

    public World getWorldForCSS(dn css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public final boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = ((MinecraftServer)this.getMinecraftServer()).at;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aB();
        try {
            CommandAPIHandler.getField(acs.class, (String)"g", (String)"dispatcher").set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aA().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aV().F().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aA().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        hn.b registryAccess = ((MinecraftServer)this.getMinecraftServer()).aW();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ajp serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aA();
            ArrayList<ais> packResources = new ArrayList<ais>();
            for (String packID : collection) {
                ajn pack = serverPackRepository.a(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ajx resourceManager = new ajx(ait.b, packResources);
            CompletableFuture simpleReloadInstance = akk.a((ake)resourceManager, (List)serverResources.b().h(), (Executor)((MinecraftServer)this.getMinecraftServer()).ar, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(aoz.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).at.close();
            ((MinecraftServer)this.getMinecraftServer()).at = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).aA().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aA().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aA().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aV().a(new cko(new cjk((List)enabledIDs, disabledIDs), ((MinecraftServer)this.getMinecraftServer()).aV().F().b()));
            ((MinecraftServer)this.getMinecraftServer()).at.b().a((hn)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aU().a((ake)((MinecraftServer)this.getMinecraftServer()).at.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bm()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public final void resendPackets(Player player) {
        ((MinecraftServer)this.getMinecraftServer()).aB().a(((CraftPlayer)player).getHandle());
    }

    public Message generateMessageFromJson(String json) {
        return ss.a.a((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.M);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.q);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            COMMAND_BUILD_CONTEXT = di.a((hn)server2.getServer().aW(), (byx)server2.getServer().aV().F().b());
        } else {
            COMMAND_BUILD_CONTEXT = null;
        }
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
        itemInput = SafeVarHandle.ofOrNull(fq.class, (String)"c", (String)"tag", qp.class);
    }
}

