/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_18_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_18_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R1.CraftServer;
import org.bukkit.craftbukkit.v1_18_R1.CraftSound;
import org.bukkit.craftbukkit.v1_18_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_18_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_18_R1
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
    private static final Field entitySelectorUsesSelector = CommandAPIHandler.getField(fn.class, (String)"o", (String)"usesSelector");
    private static final SafeVarHandle<fi, oc> itemInput = SafeVarHandle.ofOrNull(fi.class, (String)"c", (String)"tag", oc.class);
    private static final Field serverFunctionLibraryDispatcher = CommandAPIHandler.getField(ys.class, (String)"i", (String)"dispatcher");

    private static NamespacedKey fromResourceLocation(yh key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return er.a();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return es.a();
    }

    public ArgumentType<?> _ArgumentEnchantment() {
        return dz.a();
    }

    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> dw.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> dw.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> dw.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> dw.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return dx.a();
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return fk.a();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return fh.a();
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return eb.a();
    }

    public ArgumentType<?> _ArgumentParticle() {
        return eh.a();
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.18", "1.18.1"};
    }

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).t().e_();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(dj commandFunction) {
        ToIntFunction<dm> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).ay().a(commandFunction, css);
        dj.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_18_R1.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<dm> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)fu.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return ej.a(cmdCtx, (String)key).bukkit;
    }

    public NamedTextColor getAdventureChatColor(CommandContext<dm> cmdCtx, String key) {
        Integer color = dr.a(cmdCtx, (String)key).e();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.ofExact((int)color);
    }

    public Component getAdventureChatComponent(CommandContext<dm> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)pz.a.a((pz)ds.a(cmdCtx, (String)key)));
    }

    public Object getBiome(CommandContext<dm> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)((yh)cmdCtx.getArgument(key, yh.class)).a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var4_6 = biome;
                yield var4_6;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var4_7;
                yield var4_7 = NMS_1_18_R1.fromResourceLocation((yh)cmdCtx.getArgument(key, yh.class));
            }
            default -> {
                NamespacedKey var4_8;
                yield var4_8 = null;
            }
        };
    }

    public Predicate<Block> getBlockPredicate(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = er.a(cmdCtx, (String)key);
        return block -> predicate.test(new cog((cag)((dm)cmdCtx.getSource()).e(), new gh(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<dm> cmdCtx, String key) {
        return CraftBlockData.fromData((coc)es.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<dm> getResourcesDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).aA().a();
    }

    public dm getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)senderWrapper.getSource()));
    }

    public Enchantment getEnchantment(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_1_18_R1.fromResourceLocation(gx.Y.b((Object)dz.a(cmdCtx, (String)key))));
    }

    public final World getDimension(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return du.a(cmdCtx, (String)key).getWorld();
    }

    public Object getEntitySelector(CommandContext<dm> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        fn argument = (fn)cmdCtx.getArgument(str, fn.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (awt entity : argument.b((dm)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (adj player : argument.d((dm)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dm)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dm)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public EntityType getEntityType(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)awx.a((awx)((awx)gx.Z.a(dx.a(cmdCtx, (String)key)))).a());
    }

    public FloatRange getFloatRange(CommandContext<dm> cmdCtx, String key) {
        cj.c range = ei.a.a(cmdCtx, (String)key);
        Double lowBoxed = (Double)range.a();
        Double highBoxed = (Double)range.b();
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public FunctionWrapper[] getFunction(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dm css = ((dm)cmdCtx.getSource()).a().b(2);
        for (dj commandFunction : fg.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dm)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        yh resourceLocation = new yh(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).ay().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((dj)commandFunctionOptional.get());
        }
        throw new IllegalStateException("Failed to get defined function " + key + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (yh resourceLocation : ((MinecraftServer)this.getMinecraftServer()).ay().e()) {
            result.add(NMS_1_18_R1.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public IntegerRange getIntRange(CommandContext<dm> cmdCtx, String key) {
        cj.d range = ei.b.a(cmdCtx, (String)key);
        Integer lowBoxed = (Integer)range.a();
        Integer highBoxed = (Integer)range.b();
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public ItemStack getItemStack(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        fi input = fh.a(cmdCtx, (String)key);
        bue itemWithMaybeTag = input.a(1, false);
        oc tag = (oc)itemInput.get((Object)input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((bue)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((bue)itemWithMaybeTag));
        return result;
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fk.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        acz blockPos = ew.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)blockPos.a, (double)blockPos.b);
    }

    public Location2D getLocation2DPrecise(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        dol vecPos = fb.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public Location getLocationBlock(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        gh blockPos = ev.b(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public Location getLocationPrecise(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        dom vecPos = fc.b(cmdCtx, (String)key).a((dm)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dm)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public LootTable getLootTable(CommandContext<dm> cmdCtx, String key) {
        yh resourceLocation = ej.f(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_18_R1.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aG().a(resourceLocation));
    }

    public NamespacedKey getMinecraftKey(CommandContext<dm> cmdCtx, String key) {
        return NMS_1_18_R1.fromResourceLocation(ej.f(cmdCtx, (String)key));
    }

    public ParticleData<?> getParticle(CommandContext<dm> cmdCtx, String key) {
        hv particleOptions = eh.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((hv)particleOptions);
        if (particleOptions instanceof hy) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof hp) {
            hp options = (hp)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((coc)options.c()));
        }
        if (particleOptions instanceof hq) {
            hq options = (hq)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof hr) {
            hr options = (hr)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ht) {
            ht options = (ht)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((bue)options.c()));
        }
        if (particleOptions instanceof hz) {
            hz options = (hz)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, hq options) {
        Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<dm> cmdCtx, Particle particle, hz options) {
        gh origin = options.c().b();
        adi level = ((dm)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), (double)origin.u(), (double)origin.v(), (double)origin.w());
        csk csk2 = options.c().c();
        if (!(csk2 instanceof csd)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + options.c().c());
            return new ParticleData(particle, null);
        }
        csd positionSource = (csd)csk2;
        gh to = (gh)positionSource.a((cad)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.u(), (double)to.v(), (double)to.w()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c().a()));
    }

    public PotionEffectType getPotionEffect(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_18_R1.fromResourceLocation(gx.W.b((Object)eb.a(cmdCtx, (String)key))));
    }

    public final Recipe getRecipe(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        bww recipe = ej.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_18_R1.fromResourceLocation(recipe.f()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<dm> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)el.a(cmdCtx, (String)key));
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<dm> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dm css = (dm)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        dom pos = css.d();
        dol rot = css.i();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        awt proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<dm> cmdCtx, String key, ArgumentSubType subType) {
        yh soundResource = ej.f(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                agu soundEvent = (agu)gx.U.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((agu)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SuggestionProvider<dm> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                yt functionData = ((MinecraftServer)this.getMinecraftServer()).ay();
                dp.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return dp.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> fw.b;
            case SuggestionProviders.SOUNDS -> fw.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dp.a(((MinecraftServer)this.getMinecraftServer()).ax().a().stream().map(af::h), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dp.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aG().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> fw.d;
            case SuggestionProviders.ENTITIES -> fw.e;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).ay().b(new yh(key.getNamespace(), key.getKey())).b();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((dj)customFunctions.get(i));
        }
        return result;
    }

    public World getWorldForCSS(dm css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public Command wrapToVanillaCommandWrapper(LiteralCommandNode<dm> node) {
        return new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<dm> node) {
        return node.getCommand() instanceof BukkitCommandWrapper;
    }

    public void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        yv serverResources = ((MinecraftServer)this.getMinecraftServer()).aB;
        serverResources.c = ((MinecraftServer)this.getMinecraftServer()).aA();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        CompletableFuture unitCompletableFuture = ((afi)serverResources.i()).a((Executor)ad.g(), Runnable::run, ((MinecraftServer)this.getMinecraftServer()).az().f(), CompletableFuture.completedFuture(null));
        CompletionStage completablefuture = ((CompletableFuture)unitCompletableFuture.whenComplete((u, t) -> {
            if (t != null) {
                serverResources.close();
            }
        })).thenApply(u -> serverResources);
        try {
            ((yv)((CompletableFuture)completablefuture).get()).j();
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return pz.a.a((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }
}

