/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_18_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_18_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftSound;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_18_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_18_R2
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
    private static final Field entitySelectorUsesSelector = CommandAPIHandler.getField(fp.class, (String)"o", (String)"usesSelector");
    private static final SafeVarHandle<fk, ok> itemInput = SafeVarHandle.ofOrNull(fk.class, (String)"c", (String)"tag", ok.class);
    private static final Field serverFunctionLibraryDispatcher = CommandAPIHandler.getField(zf.class, (String)"i", (String)"dispatcher");

    private static NamespacedKey fromResourceLocation(yt key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return et.a();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return eu.a();
    }

    public ArgumentType<?> _ArgumentEnchantment() {
        return dz.a();
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return eb.a();
    }

    public ArgumentType<?> _ArgumentParticle() {
        return eh.a();
    }

    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> dw.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> dw.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> dw.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> dw.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return dx.a();
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return fm.a();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return fj.a();
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return el.a((ys)hb.aP);
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.18.2"};
    }

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).u().e_();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(dj commandFunction) {
        ToIntFunction<dm> appliedObj = css -> ((MinecraftServer)this.getMinecraftServer()).ay().a(commandFunction, css);
        dj.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_18_R2.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<dm> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)fw.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Advancement getAdvancement(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return ek.a(cmdCtx, (String)key).bukkit;
    }

    public NamedTextColor getAdventureChatColor(CommandContext<dm> cmdCtx, String key) {
        Integer color = dr.a(cmdCtx, (String)key).e();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public Component getAdventureChatComponent(CommandContext<dm> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)qk.a.a((qk)ds.a(cmdCtx, (String)key)));
    }

    public Object getBiome(CommandContext<dm> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        el.b biomeResult = el.a(cmdCtx, (String)key);
        if (biomeResult.a().left().isPresent()) {
            yt resourceLocation = ((ys)biomeResult.a().left().get()).a();
            return switch (subType) {
                case ArgumentSubType.BIOME_BIOME -> {
                    Biome biome = null;
                    try {
                        biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                    }
                    catch (IllegalArgumentException biomeNotFound) {
                        biome = null;
                    }
                    Biome var6_8 = biome;
                    yield var6_8;
                }
                case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                    NamespacedKey var6_9;
                    yield var6_9 = NMS_1_18_R2.fromResourceLocation(resourceLocation);
                }
                default -> {
                    NamespacedKey var6_10;
                    yield var6_10 = null;
                }
            };
        }
        throw new DynamicCommandExceptionType(x -> new qy("commands.locatebiome.invalid", new Object[]{x})).create((Object)biomeResult.b());
    }

    public Predicate<Block> getBlockPredicate(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = et.a(cmdCtx, (String)key);
        return block -> predicate.test(new coz((cay)((dm)cmdCtx.getSource()).e(), new gj(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<dm> cmdCtx, String key) {
        return CraftBlockData.fromData((cov)eu.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<dm> getResourcesDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).aA().a();
    }

    public dm getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)senderWrapper.getSource()));
    }

    public Enchantment getEnchantment(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_1_18_R2.fromResourceLocation(hb.V.b((Object)dz.a(cmdCtx, (String)key))));
    }

    public final World getDimension(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return du.a(cmdCtx, (String)key).getWorld();
    }

    public Object getEntitySelector(CommandContext<dm> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        fp argument = (fp)cmdCtx.getArgument(str, fp.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (axk entity : argument.b((dm)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (adx player : argument.d((dm)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dm)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dm)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public EntityType getEntityType(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)axo.a((axo)((axo)hb.W.a(dx.a(cmdCtx, (String)key)))).a());
    }

    public FloatRange getFloatRange(CommandContext<dm> cmdCtx, String key) {
        cj.c range = ei.a.a(cmdCtx, (String)key);
        Double lowBoxed = (Double)range.a();
        Double highBoxed = (Double)range.b();
        double low = lowBoxed == null ? -3.4028234663852886E38 : lowBoxed;
        double high = highBoxed == null ? 3.4028234663852886E38 : highBoxed;
        return new FloatRange((float)low, (float)high);
    }

    public FunctionWrapper[] getFunction(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dm css = ((dm)cmdCtx.getSource()).a().b(2);
        for (dj commandFunction : fi.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dm)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        yt resourceLocation = new yt(key.getNamespace(), key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).ay().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((dj)commandFunctionOptional.get());
        }
        throw new IllegalStateException("Failed to get defined function " + key + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (yt resourceLocation : ((MinecraftServer)this.getMinecraftServer()).ay().e()) {
            result.add(NMS_1_18_R2.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public IntegerRange getIntRange(CommandContext<dm> cmdCtx, String key) {
        cj.d range = ei.b.a(cmdCtx, (String)key);
        Integer lowBoxed = (Integer)range.a();
        Integer highBoxed = (Integer)range.b();
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    public ItemStack getItemStack(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        fk input = fj.a(cmdCtx, (String)key);
        buw itemWithMaybeTag = input.a(1, false);
        ok tag = (ok)itemInput.get((Object)input);
        if (tag != null) {
            byte count = tag.f("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((buw)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((buw)itemWithMaybeTag));
        return result;
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fm.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        adn blockPos = ey.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)blockPos.a, (double)blockPos.b);
    }

    public Location2D getLocation2DPrecise(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        dpn vecPos = fd.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public Location getLocationBlock(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        gj blockPos = ex.b(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public Location getLocationPrecise(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        dpo vecPos = fe.b(cmdCtx, (String)key).a((dm)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dm)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public LootTable getLootTable(CommandContext<dm> cmdCtx, String key) {
        yt resourceLocation = ek.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_18_R2.fromResourceLocation(resourceLocation), ((MinecraftServer)this.getMinecraftServer()).aF().a(resourceLocation));
    }

    public NamespacedKey getMinecraftKey(CommandContext<dm> cmdCtx, String key) {
        return NMS_1_18_R2.fromResourceLocation(ek.e(cmdCtx, (String)key));
    }

    public ParticleData<?> getParticle(CommandContext<dm> cmdCtx, String key) {
        ia particleOptions = eh.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ia)particleOptions);
        if (particleOptions instanceof id) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof hu) {
            hu options = (hu)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((cov)options.c()));
        }
        if (particleOptions instanceof hv) {
            hv options = (hv)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof hw) {
            hw options = (hw)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof hy) {
            hy options = (hy)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((buw)options.c()));
        }
        if (particleOptions instanceof ie) {
            ie options = (ie)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, hv options) {
        Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<dm> cmdCtx, Particle particle, ie options) {
        gj origin = options.c().b();
        adw level = ((dm)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), (double)origin.u(), (double)origin.v(), (double)origin.w());
        ctc ctc2 = options.c().c();
        if (!(ctc2 instanceof csv)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + options.c().c());
            return new ParticleData(particle, null);
        }
        csv positionSource = (csv)ctc2;
        gj to = (gj)positionSource.a((cav)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.u(), (double)to.v(), (double)to.w()));
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c().a()));
    }

    public PotionEffectType getPotionEffect(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_18_R2.fromResourceLocation(hb.T.b((Object)eb.a(cmdCtx, (String)key))));
    }

    public final Recipe getRecipe(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        bxo recipe = ek.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_18_R2.fromResourceLocation(recipe.f()), recipe.toBukkitRecipe());
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<dm> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)en.a(cmdCtx, (String)key));
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<dm> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dm css = (dm)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        dpo pos = css.d();
        dpn rot = css.i();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.j, rot.i);
        axk proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<dm> cmdCtx, String key, ArgumentSubType subType) {
        yt soundResource = ek.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                ahj soundEvent = (ahj)hb.R.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((ahj)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SuggestionProvider<dm> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                zg functionData = ((MinecraftServer)this.getMinecraftServer()).ay();
                dp.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return dp.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> fy.b;
            case SuggestionProviders.SOUNDS -> fy.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dp.a(((MinecraftServer)this.getMinecraftServer()).ax().a().stream().map(af::h), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dp.a((Iterable)((MinecraftServer)this.getMinecraftServer()).aF().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> fy.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).ay().b(new yt(key.getNamespace(), key.getKey())).a();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((dj)customFunctions.get(i));
        }
        return result;
    }

    public World getWorldForCSS(dm css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public Command wrapToVanillaCommandWrapper(LiteralCommandNode<dm> node) {
        return new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<dm> node) {
        return node.getCommand() instanceof BukkitCommandWrapper;
    }

    public void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = ((MinecraftServer)this.getMinecraftServer()).aB;
        serverResources.b().c = ((MinecraftServer)this.getMinecraftServer()).aA();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).az().d());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aT().D().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).az().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        hc.a registryAccess = ((MinecraftServer)this.getMinecraftServer()).aU();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            afn serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).az();
            ArrayList<afa> packResources = new ArrayList<afa>();
            for (String packID : collection) {
                afl pack = serverPackRepository.a(packID);
                if (pack == null) continue;
                packResources.add(pack.d());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            afu resourceManager = new afu(afb.b, packResources);
            CompletableFuture simpleReloadInstance = agf.a((aga)resourceManager, (List)serverResources.b().h(), (Executor)((MinecraftServer)this.getMinecraftServer()).az, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(aka.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).aB.close();
            ((MinecraftServer)this.getMinecraftServer()).aB = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            ((MinecraftServer)this.getMinecraftServer()).az().a(collection);
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).az().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).az().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aT().a(new caj((List)enabledIDs, disabledIDs));
            ((MinecraftServer)this.getMinecraftServer()).aB.b().a((hc)registryAccess);
            ((MinecraftServer)this.getMinecraftServer()).aS().a((aga)((MinecraftServer)this.getMinecraftServer()).aB.a());
        });
        if (((MinecraftServer)this.getMinecraftServer()).bk()) {
            ((MinecraftServer)this.getMinecraftServer()).c(((CompletableFuture)third)::isDone);
        }
        try {
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return qk.a.a((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }
}

