/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.SafeVarHandle;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.exceptions.UnimplementedArgumentException;
import dev.jorel.commandapi.nms.NMSWrapper_1_16_R1;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FloatRange;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.IntegerRange;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.MathOperation;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.Rotation;
import dev.jorel.commandapi.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_16_R1.Advancement;
import net.minecraft.server.v1_16_R1.ArgumentBlockPredicate;
import net.minecraft.server.v1_16_R1.ArgumentChat;
import net.minecraft.server.v1_16_R1.ArgumentChatComponent;
import net.minecraft.server.v1_16_R1.ArgumentChatFormat;
import net.minecraft.server.v1_16_R1.ArgumentCriterionValue;
import net.minecraft.server.v1_16_R1.ArgumentDimension;
import net.minecraft.server.v1_16_R1.ArgumentEnchantment;
import net.minecraft.server.v1_16_R1.ArgumentEntity;
import net.minecraft.server.v1_16_R1.ArgumentEntitySummon;
import net.minecraft.server.v1_16_R1.ArgumentItemPredicate;
import net.minecraft.server.v1_16_R1.ArgumentItemStack;
import net.minecraft.server.v1_16_R1.ArgumentMathOperation;
import net.minecraft.server.v1_16_R1.ArgumentMinecraftKeyRegistered;
import net.minecraft.server.v1_16_R1.ArgumentMobEffect;
import net.minecraft.server.v1_16_R1.ArgumentNBTTag;
import net.minecraft.server.v1_16_R1.ArgumentParticle;
import net.minecraft.server.v1_16_R1.ArgumentPosition;
import net.minecraft.server.v1_16_R1.ArgumentPredicateItemStack;
import net.minecraft.server.v1_16_R1.ArgumentProfile;
import net.minecraft.server.v1_16_R1.ArgumentRegistry;
import net.minecraft.server.v1_16_R1.ArgumentRotation;
import net.minecraft.server.v1_16_R1.ArgumentRotationAxis;
import net.minecraft.server.v1_16_R1.ArgumentScoreboardCriteria;
import net.minecraft.server.v1_16_R1.ArgumentScoreboardObjective;
import net.minecraft.server.v1_16_R1.ArgumentScoreboardSlot;
import net.minecraft.server.v1_16_R1.ArgumentScoreboardTeam;
import net.minecraft.server.v1_16_R1.ArgumentScoreholder;
import net.minecraft.server.v1_16_R1.ArgumentTag;
import net.minecraft.server.v1_16_R1.ArgumentTile;
import net.minecraft.server.v1_16_R1.ArgumentTime;
import net.minecraft.server.v1_16_R1.ArgumentUUID;
import net.minecraft.server.v1_16_R1.ArgumentVec2;
import net.minecraft.server.v1_16_R1.ArgumentVec2I;
import net.minecraft.server.v1_16_R1.ArgumentVec3;
import net.minecraft.server.v1_16_R1.BlockPosition;
import net.minecraft.server.v1_16_R1.BlockPosition2D;
import net.minecraft.server.v1_16_R1.CommandListenerWrapper;
import net.minecraft.server.v1_16_R1.CompletionProviders;
import net.minecraft.server.v1_16_R1.CriterionConditionValue;
import net.minecraft.server.v1_16_R1.CustomFunction;
import net.minecraft.server.v1_16_R1.CustomFunctionData;
import net.minecraft.server.v1_16_R1.CustomFunctionManager;
import net.minecraft.server.v1_16_R1.DataPackResources;
import net.minecraft.server.v1_16_R1.Entity;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.EntitySelector;
import net.minecraft.server.v1_16_R1.EntityTypes;
import net.minecraft.server.v1_16_R1.EnumChatFormat;
import net.minecraft.server.v1_16_R1.EnumDirection;
import net.minecraft.server.v1_16_R1.IBlockData;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.ICompletionProvider;
import net.minecraft.server.v1_16_R1.IRecipe;
import net.minecraft.server.v1_16_R1.IRegistry;
import net.minecraft.server.v1_16_R1.IReloadableResourceManager;
import net.minecraft.server.v1_16_R1.IWorldReader;
import net.minecraft.server.v1_16_R1.MinecraftKey;
import net.minecraft.server.v1_16_R1.MinecraftServer;
import net.minecraft.server.v1_16_R1.NBTTagCompound;
import net.minecraft.server.v1_16_R1.ParticleParam;
import net.minecraft.server.v1_16_R1.ParticleParamBlock;
import net.minecraft.server.v1_16_R1.ParticleParamItem;
import net.minecraft.server.v1_16_R1.ParticleParamRedstone;
import net.minecraft.server.v1_16_R1.ParticleType;
import net.minecraft.server.v1_16_R1.ShapeDetectorBlock;
import net.minecraft.server.v1_16_R1.SystemUtils;
import net.minecraft.server.v1_16_R1.Vec2F;
import net.minecraft.server.v1_16_R1.Vec3D;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.Axis;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_16_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_16_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_16_R1.CraftServer;
import org.bukkit.craftbukkit.v1_16_R1.CraftSound;
import org.bukkit.craftbukkit.v1_16_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_16_R1.command.BukkitCommandWrapper;
import org.bukkit.craftbukkit.v1_16_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_16_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_16_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R1.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_16_R1.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class NMS_1_16_R1
extends NMSWrapper_1_16_R1 {
    private static final Field entitySelectorCheckPermissions = CommandAPIHandler.getField(EntitySelector.class, (String)"checkPermissions", (String)"checkPermissions");
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, (String)"helpTopics", (String)"helpTopics", Map.class);
    private static final SafeVarHandle<ParticleParamBlock, IBlockData> particleParamBlockData = SafeVarHandle.ofOrNull(ParticleParamBlock.class, (String)"c", (String)"c", IBlockData.class);
    private static final SafeVarHandle<ParticleParamItem, net.minecraft.server.v1_16_R1.ItemStack> particleParamItemStack = SafeVarHandle.ofOrNull(ParticleParamItem.class, (String)"c", (String)"c", net.minecraft.server.v1_16_R1.ItemStack.class);
    private static final SafeVarHandle<ParticleParamRedstone, Float> particleParamRedstoneSize = SafeVarHandle.ofOrNull(ParticleParamRedstone.class, (String)"f", (String)"f", Float.TYPE);
    private static final SafeVarHandle<ArgumentPredicateItemStack, NBTTagCompound> itemStackPredicateArgument = SafeVarHandle.ofOrNull(ArgumentPredicateItemStack.class, (String)"c", (String)"c", NBTTagCompound.class);
    private static final SafeVarHandle<CraftSound, String> craftSoundMinecraftKey = SafeVarHandle.ofOrNull(CraftSound.class, (String)"minecraftKey", (String)"minecraftKey", String.class);
    private static final Field customFunctionManagerBrigadierDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, (String)"g", (String)"g");
    private static final SafeVarHandle<DataPackResources, IReloadableResourceManager> dataPackResources = SafeVarHandle.ofOrNull(DataPackResources.class, (String)"b", (String)"b", IReloadableResourceManager.class);

    private static NamespacedKey fromMinecraftKey(MinecraftKey key) {
        return new NamespacedKey(key.getNamespace(), key.getKey());
    }

    public ArgumentType<?> _ArgumentAngle() {
        throw new UnimplementedArgumentException("AngleArgument", "1.16.2");
    }

    public ArgumentType<?> _ArgumentAxis() {
        return ArgumentRotationAxis.a();
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    public ArgumentType<?> _ArgumentChat() {
        return ArgumentChat.a();
    }

    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a();
    }

    public ArgumentType<?> _ArgumentChatFormat() {
        return ArgumentChatFormat.a();
    }

    public ArgumentType<?> _ArgumentDimension() {
        return ArgumentDimension.a();
    }

    public ArgumentType<?> _ArgumentEnchantment() {
        return ArgumentEnchantment.a();
    }

    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> ArgumentEntity.multipleEntities();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> ArgumentEntity.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> ArgumentEntity.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> ArgumentEntity.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return ArgumentEntitySummon.a();
    }

    public ArgumentType<?> _ArgumentFloatRange() {
        return new ArgumentCriterionValue.a();
    }

    public ArgumentType<?> _ArgumentIntRange() {
        return new ArgumentCriterionValue.b();
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    public ArgumentType<?> _ArgumentMathOperation() {
        return ArgumentMathOperation.a();
    }

    public ArgumentType<?> _ArgumentMinecraftKeyRegistered() {
        return ArgumentMinecraftKeyRegistered.a();
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return ArgumentMobEffect.a();
    }

    public ArgumentType<?> _ArgumentNBTCompound() {
        return ArgumentNBTTag.a();
    }

    public ArgumentType<?> _ArgumentParticle() {
        return ArgumentParticle.a();
    }

    public ArgumentType<?> _ArgumentPosition() {
        return ArgumentPosition.a();
    }

    public ArgumentType<?> _ArgumentPosition2D() {
        return ArgumentVec2I.a();
    }

    public ArgumentType<?> _ArgumentProfile() {
        return ArgumentProfile.a();
    }

    public ArgumentType<?> _ArgumentRotation() {
        return ArgumentRotation.a();
    }

    public ArgumentType<?> _ArgumentScoreboardCriteria() {
        return ArgumentScoreboardCriteria.a();
    }

    public ArgumentType<?> _ArgumentScoreboardObjective() {
        return ArgumentScoreboardObjective.a();
    }

    public ArgumentType<?> _ArgumentScoreboardSlot() {
        return ArgumentScoreboardSlot.a();
    }

    public ArgumentType<?> _ArgumentScoreboardTeam() {
        return ArgumentScoreboardTeam.a();
    }

    public final ArgumentType<?> _ArgumentScoreholder(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.SCOREHOLDER_SINGLE -> ArgumentScoreholder.a();
            case ArgumentSubType.SCOREHOLDER_MULTIPLE -> ArgumentScoreholder.b();
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    public ArgumentType<?> _ArgumentTag() {
        return ArgumentTag.a();
    }

    public ArgumentType<?> _ArgumentTime() {
        return ArgumentTime.a();
    }

    public ArgumentType<?> _ArgumentUUID() {
        return ArgumentUUID.a();
    }

    public ArgumentType<?> _ArgumentVec2(boolean centerPosition) {
        return new ArgumentVec2(centerPosition);
    }

    public ArgumentType<?> _ArgumentVec3(boolean centerPosition) {
        return ArgumentVec3.a((boolean)centerPosition);
    }

    public Map<String, HelpTopic> getHelpMap() {
        return (Map)helpMapTopics.get((Object)((SimpleHelpMap)Bukkit.getHelpMap()));
    }

    public String[] compatibleVersions() {
        return new String[]{"1.16.1"};
    }

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().toString();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    public String convert(PotionEffectType potion) {
        return potion.getName().toLowerCase(Locale.ENGLISH);
    }

    public String convert(Sound sound) {
        return CraftSound.getSound((Sound)sound);
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction customFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = clw -> ((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(customFunction, clw);
        CustomFunction.c[] cArr = customFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_16_R1.fromMinecraftKey(customFunction.a()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentRegistry.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public org.bukkit.advancement.Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key).bukkit;
    }

    public Component getAdventureChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    public NamedTextColor getAdventureChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Integer color = ArgumentChatFormat.a(cmdCtx, (String)key).e();
        return color == null ? NamedTextColor.WHITE : NamedTextColor.namedColor((int)color);
    }

    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    public float getAngle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        throw new UnimplementedArgumentException("AngleArgument", "1.16.2");
    }

    public EnumSet<Axis> getAxis(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        EnumSet<Axis> set = EnumSet.noneOf(Axis.class);
        EnumSet parsedEnumSet = ArgumentRotationAxis.a(cmdCtx, (String)key);
        for (EnumDirection.EnumAxis element : parsedEnumSet) {
            set.add(switch (element) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.EnumAxis.X -> Axis.X;
                case EnumDirection.EnumAxis.Y -> Axis.Y;
                case EnumDirection.EnumAxis.Z -> Axis.Z;
            });
        }
        return set;
    }

    public Object getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> Biome.valueOf((String)((MinecraftKey)cmdCtx.getArgument(key, MinecraftKey.class)).getKey().toUpperCase());
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> NMS_1_16_R1.fromMinecraftKey((MinecraftKey)cmdCtx.getArgument(key, MinecraftKey.class));
            default -> null;
        };
    }

    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).getWorld(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher.a();
    }

    public CommandDispatcher<CommandListenerWrapper> getResourcesDispatcher() {
        return ((MinecraftServer)this.getMinecraftServer()).getCommandDispatcher().a();
    }

    public BaseComponent[] getChat(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChat.a(cmdCtx, (String)key)));
    }

    public ChatColor getChatColor(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftChatMessage.getColor((EnumChatFormat)ArgumentChatFormat.a(cmdCtx, (String)key));
    }

    public BaseComponent[] getChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ComponentSerializer.parse((String)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> senderWrapper) {
        return VanillaCommandWrapper.getListener((CommandSender)((CommandSender)senderWrapper.getSource()));
    }

    public BukkitCommandSender<? extends CommandSender> getCommandSenderFromCommandSource(CommandListenerWrapper clw) {
        try {
            return this.wrapCommandSender(clw.getBukkitSender());
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public org.bukkit.World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    public Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new CraftEnchantment(ArgumentEnchantment.a(cmdCtx, (String)key));
    }

    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, ArgumentSubType subType, boolean allowEmpty) throws CommandSyntaxException {
        Object object;
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorCheckPermissions.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        switch (subType) {
            case ENTITYSELECTOR_MANY_ENTITIES: {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (Entity entity : argument.getEntities((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.d.create();
                    }
                    ArrayList<CraftEntity> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_MANY_PLAYERS: {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    if (result.isEmpty() && !allowEmpty) {
                        throw ArgumentEntity.e.create();
                    }
                    ArrayList<CraftPlayer> arrayList = result;
                    object = arrayList;
                    break;
                }
                catch (CommandSyntaxException e) {
                    if (allowEmpty) {
                        ArrayList arrayList = new ArrayList();
                        object = arrayList;
                        break;
                    }
                    throw e;
                }
            }
            case ENTITYSELECTOR_ONE_ENTITY: {
                CraftEntity craftEntity;
                object = craftEntity = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                break;
            }
            case ENTITYSELECTOR_ONE_PLAYER: {
                CraftPlayer craftPlayer = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                object = craftPlayer;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
            }
        }
        return object;
    }

    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ((EntityTypes)IRegistry.ENTITY_TYPE.get(ArgumentEntitySummon.a(cmdCtx, (String)key))).a((World)((CraftWorld)this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource())).getHandle()).getBukkitEntity().getType();
    }

    public FloatRange getFloatRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.FloatRange range = (CriterionConditionValue.FloatRange)cmdCtx.getArgument(key, CriterionConditionValue.FloatRange.class);
        float low = range.a() == null ? -3.4028235E38f : ((Float)range.a()).floatValue();
        float high = range.b() == null ? Float.MAX_VALUE : ((Float)range.b()).floatValue();
        return new FloatRange(low, high);
    }

    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper commandListenerWrapper = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction customFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(customFunction), (Object)commandListenerWrapper, e -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)e).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.convertFunction((CustomFunction)((MinecraftServer)this.getMinecraftServer()).getFunctionData().a(new MinecraftKey(key.getNamespace(), key.getKey())).get());
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().f()) {
            functions.add(NMS_1_16_R1.fromMinecraftKey(key));
        }
        return functions;
    }

    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        int low = range.a() == null ? Integer.MIN_VALUE : (Integer)range.a();
        int high = range.b() == null ? Integer.MAX_VALUE : (Integer)range.b();
        return new IntegerRange(low, high);
    }

    public ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        net.minecraft.server.v1_16_R1.ItemStack itemWithMaybeTag = input.a(1, false);
        NBTTagCompound tag = (NBTTagCompound)itemStackPredicateArgument.get((Object)input);
        if (tag != null) {
            byte count = tag.getByte("Count");
            itemWithMaybeTag = input.a((int)(count == 0 ? (byte)1 : count), false);
        }
        ItemStack result = CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R1.ItemStack)itemWithMaybeTag);
        result.setItemMeta(CraftItemStack.getItemMeta((net.minecraft.server.v1_16_R1.ItemStack)itemWithMaybeTag));
        return result;
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.a, (double)blockPos.b);
    }

    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.b(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.x, vecPos.y, vecPos.z);
    }

    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey minecraftKey = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_16_R1.fromMinecraftKey(minecraftKey), ((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().getLootTable(minecraftKey));
    }

    public MathOperation getMathOperation(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentMathOperation.a(cmdCtx, (String)key);
        return MathOperation.fromString((String)CommandAPIHandler.getRawArgumentInput(cmdCtx, (String)key));
    }

    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return new NamespacedKey(resourceLocation.getNamespace(), resourceLocation.getKey());
    }

    public <NBTContainer> Object getNBTCompound(CommandContext<CommandListenerWrapper> cmdCtx, String key, Function<Object, NBTContainer> nbtContainerConstructor) {
        return nbtContainerConstructor.apply(ArgumentNBTTag.a(cmdCtx, (String)key));
    }

    public Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws IllegalArgumentException, CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    public String getObjectiveCriteria(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentScoreboardCriteria.a(cmdCtx, (String)key).getName();
    }

    public OfflinePlayer getOfflinePlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((IBlockData)((IBlockData)particleParamBlockData.get((Object)options))));
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            return this.getParticleDataAsDustOptions(particle, options);
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R1.ItemStack)((net.minecraft.server.v1_16_R1.ItemStack)particleParamItemStack.get((Object)options))));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustOptions> getParticleDataAsDustOptions(Particle particle, ParticleParamRedstone options) {
        String optionsStr = options.a();
        String[] optionsArr = optionsStr.split(" ");
        float red = Float.parseFloat(optionsArr[1]);
        float green = Float.parseFloat(optionsArr[2]);
        float blue = Float.parseFloat(optionsArr[3]);
        Color color = Color.fromRGB((int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustOptions(color, ((Float)particleParamRedstoneSize.get((Object)options)).floatValue()));
    }

    public Player getPlayer(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Player target = Bukkit.getPlayer((UUID)((GameProfile)ArgumentProfile.a(cmdCtx, (String)key).iterator().next()).getId());
        if (target == null) {
            throw ArgumentProfile.a.create();
        }
        return target;
    }

    public Object getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.POTION_EFFECT_POTION_EFFECT -> new CraftPotionEffectType(ArgumentMobEffect.a(cmdCtx, (String)key));
            case ArgumentSubType.POTION_EFFECT_NAMESPACEDKEY -> NMS_1_16_R1.fromMinecraftKey(ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public ComplexRecipe getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        IRecipe recipe = ArgumentMinecraftKeyRegistered.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_16_R1.fromMinecraftKey(recipe.getKey()), recipe.toBukkitRecipe());
    }

    public Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F vec = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(vec.j, vec.i);
    }

    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft((int)ArgumentScoreboardSlot.a(cmdCtx, (String)key));
    }

    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.b(cmdCtx, (String)key);
    }

    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key);
    }

    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper clw = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = clw.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        Vec3D pos = clw.getPosition();
        Vec2F rot = clw.i();
        org.bukkit.World world = this.getWorldForCSS(clw);
        Location location = new Location(world, pos.getX(), pos.getY(), pos.getZ(), rot.j, rot.i);
        Entity proxyEntity = clw.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world));
        }
        return this.wrapCommandSender(sender);
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, ArgumentSubType subType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                for (CraftSound sound : CraftSound.values()) {
                    if (!((String)craftSoundMinecraftKey.get((Object)sound)).equals(soundResource.getKey())) continue;
                    yield Sound.valueOf((String)sound.name());
                }
                yield null;
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NMS_1_16_R1.fromMinecraftKey(soundResource);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(subType));
        };
    }

    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).getFunctionData();
                ICompletionProvider.a((Iterable)functionData.g(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.f(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> CompletionProviders.b;
            case SuggestionProviders.SOUNDS -> CompletionProviders.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).getAdvancementData().getAdvancements().stream().map(Advancement::getName), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).getLootTableRegistry().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> CompletionProviders.d;
            case SuggestionProviders.ENTITIES -> CompletionProviders.e;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)IRegistry.MOB_EFFECT.keySet(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        ArrayList customFunctions = new ArrayList(((MinecraftServer)this.getMinecraftServer()).getFunctionData().b(new MinecraftKey(key.getNamespace(), key.getKey())).getTagged());
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((CustomFunction)customFunctions.get(i));
        }
        return result;
    }

    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> functions = new HashSet<NamespacedKey>();
        for (MinecraftKey key : ((MinecraftServer)this.getMinecraftServer()).getFunctionData().g()) {
            functions.add(NMS_1_16_R1.fromMinecraftKey(key));
        }
        return functions;
    }

    public Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).getName();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    public int getTime(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return (Integer)cmdCtx.getArgument(key, Integer.class);
    }

    public UUID getUUID(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ArgumentUUID.a(cmdCtx, (String)key);
    }

    public org.bukkit.World getWorldForCSS(CommandListenerWrapper clw) {
        return clw.getWorld() == null ? null : clw.getWorld().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public Command wrapToVanillaCommandWrapper(CommandNode<CommandListenerWrapper> node) {
        return new VanillaCommandWrapper(((MinecraftServer)this.getMinecraftServer()).vanillaCommandDispatcher, node);
    }

    public boolean isBukkitCommandWrapper(CommandNode<CommandListenerWrapper> node) {
        return node.getCommand() instanceof BukkitCommandWrapper;
    }

    public void reloadDataPacks() {
        CommandAPI.getLogger().info("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        DataPackResources datapackResources = ((MinecraftServer)this.getMinecraftServer()).dataPackResources;
        datapackResources.commandDispatcher = ((MinecraftServer)this.getMinecraftServer()).getCommandDispatcher();
        try {
            customFunctionManagerBrigadierDispatcher.set(datapackResources.a(), this.getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        CompletableFuture unitCompletableFuture = ((IReloadableResourceManager)dataPackResources.get((Object)datapackResources)).a(SystemUtils.f(), Runnable::run, ((MinecraftServer)this.getMinecraftServer()).getResourcePackRepository().f(), CompletableFuture.completedFuture(null));
        CompletionStage completablefuture = ((CompletableFuture)unitCompletableFuture.whenComplete((u, t) -> {
            if (t != null) {
                datapackResources.close();
            }
        })).thenApply(u -> datapackResources);
        try {
            ((DataPackResources)((CompletableFuture)completablefuture).get()).i();
            this.registerBukkitRecipesSafely(recipes);
            CommandAPI.getLogger().info("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }
}

