/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.netty.channel.Channel;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Server;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_19_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_19_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R2.CraftServer;
import org.bukkit.craftbukkit.v1_19_R2.CraftSound;
import org.bukkit.craftbukkit.v1_19_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_19_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_19_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_19_3_R2
extends NMS_Common {
    private static final MinecraftServer MINECRAFT_SERVER;
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID;
    private static final di COMMAND_BUILD_CONTEXT;

    private static NamespacedKey fromResourceLocation(acf key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public final ArgumentType<?> _ArgumentBlockPredicate() {
        return ez.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentBlockState() {
        return fa.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentEnchantment() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.p);
    }

    public final ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> dy.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> dy.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> dy.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> dy.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final ArgumentType<?> _ArgumentItemPredicate() {
        return fs.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentItemStack() {
        return fp.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentParticle() {
        return eh.a((di)COMMAND_BUILD_CONTEXT);
    }

    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return em.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.al);
    }

    public final void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        helpTopics.putAll(helpTopicsToAdd);
    }

    public final boolean canUseChatPreview() {
        return false;
    }

    public String[] compatibleVersions() {
        return new String[]{"1.19.3"};
    }

    public final String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).v().f_();
    }

    public final String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private final SimpleFunctionWrapper convertFunction(dj commandFunction) {
        ToIntFunction<dn> appliedObj = css -> MINECRAFT_SERVER.az().a(commandFunction, css);
        dj.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_19_3_R2.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public final void createDispatcherFile(File file, CommandDispatcher<dn> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)gd.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public final Component getAdventureChatComponent(CommandContext<dn> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)ss.a.a((ss)du.a(cmdCtx, (String)key)));
    }

    public final Object getBiome(CommandContext<dn> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        em.c biomeResult = em.a(cmdCtx, (String)key, (ace)ix.al);
        if (biomeResult.a().left().isPresent()) {
            acf resourceLocation = ((gz.c)biomeResult.a().left().get()).g().a();
            return switch (subType) {
                case ArgumentSubType.BIOME_BIOME -> {
                    Biome biome = null;
                    try {
                        biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
                    }
                    catch (IllegalArgumentException biomeNotFound) {
                        biome = null;
                    }
                    Biome var6_8 = biome;
                    yield var6_8;
                }
                case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                    NamespacedKey var6_9;
                    yield var6_9 = NMS_1_19_3_R2.fromResourceLocation(resourceLocation);
                }
                default -> {
                    NamespacedKey var6_10;
                    yield var6_10 = null;
                }
            };
        }
        throw ERROR_BIOME_INVALID.create((Object)biomeResult.b());
    }

    public final Predicate<Block> getBlockPredicate(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ez.a(cmdCtx, (String)key);
        return block -> predicate.test(new cyx((cjz)((dn)cmdCtx.getSource()).e(), new gp(block.getX(), block.getY(), block.getZ()), true));
    }

    public final BlockData getBlockState(CommandContext<dn> cmdCtx, String key) {
        return CraftBlockData.fromData((cyt)fa.a(cmdCtx, (String)key).a());
    }

    public final CommandDispatcher<dn> getBrigadierDispatcher() {
        return NMS_1_19_3_R2.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    public final dn getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    public final World getDimension(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return dw.a(cmdCtx, (String)key).getWorld();
    }

    public final World.Environment getEnvironment(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return dw.a(cmdCtx, (String)key).getWorld().getEnvironment();
    }

    public final Enchantment getEnchantment(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return Enchantment.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(iw.g.b((Object)((chq)ej.g(cmdCtx, (String)key).a()))));
    }

    public final Object getEntitySelector(CommandContext<dn> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        fv argument = (fv)cmdCtx.getArgument(str, fv.class);
        try {
            CommandAPIHandler.getInstance().getField(fv.class, "p").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (bdr entity : argument.b((dn)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ahn player : argument.d((dn)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dn)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dn)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public final EntityType getEntityType(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)bdv.a((bdv)((bdv)ej.e(cmdCtx, (String)key).a())).a());
    }

    public final FunctionWrapper[] getFunction(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dn css = ((dn)cmdCtx.getSource()).a().b(2);
        for (dj commandFunction : fo.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dn)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public final ItemStack getItemStack(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((cdt)fp.a(cmdCtx, (String)key).a(1, false));
    }

    public final Predicate<ItemStack> getItemStackPredicate(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fs.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public final Location2D getLocation2DBlock(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        ahd blockPos = fe.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dn)cmdCtx.getSource()), (double)blockPos.c(), (double)blockPos.d());
    }

    public final Location2D getLocation2DPrecise(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        ead vecPos = fj.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dn)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public final Location getLocationBlock(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        gp blockPos = fd.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((dn)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public final Location getLocationPrecise(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        eae vecPos = fk.b(cmdCtx, (String)key).a((dn)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dn)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public final LootTable getLootTable(CommandContext<dn> cmdCtx, String key) {
        acf resourceLocation = el.e(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_19_3_R2.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.aG().a(resourceLocation));
    }

    public final ParticleData<?> getParticle(CommandContext<dn> cmdCtx, String key) {
        io particleOptions = eh.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((io)particleOptions);
        if (particleOptions instanceof it) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof ii) {
            ii options = (ii)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((cyt)options.c()));
        }
        if (particleOptions instanceof ij) {
            ij options = (ij)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ik) {
            ik options = (ik)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof im) {
            im options = (im)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((cdt)options.c()));
        }
        if (particleOptions instanceof iu) {
            iu options = (iu)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof is) {
            is options = (is)particleOptions;
            return new ParticleData(particle, (Object)options.c());
        }
        if (particleOptions instanceof ir) {
            ir options = (ir)particleOptions;
            return new ParticleData(particle, (Object)Float.valueOf(options.c()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, ij options) {
        Color color = Color.fromRGB((int)((int)(options.e().x() * 255.0f)), (int)((int)(options.e().y() * 255.0f)), (int)((int)(options.e().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().x() * 255.0f)), (int)((int)(options.d().y() * 255.0f)), (int)((int)(options.d().z() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<dn> cmdCtx, Particle particle, iu options) {
        Vibration.Destination destination;
        eae origin = ((dn)cmdCtx.getSource()).d();
        ahm level = ((dn)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.c, origin.d, origin.e);
        ddg ddg2 = options.c();
        if (ddg2 instanceof dcy) {
            dcy positionSource = (dcy)ddg2;
            eae to = (eae)positionSource.a((cjw)level).get();
            destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        } else {
            ddg2 = options.c();
            if (ddg2 instanceof dda) {
                dda positionSource = (dda)ddg2;
                destination = this.getVibrationParticleOptionDestinationAsEntityPositionSource(positionSource, (cjw)level);
            } else {
                CommandAPI.getLogger().warning("Unknown vibration destination " + options.c());
                return new ParticleData(particle, null);
            }
        }
        return new ParticleData(particle, (Object)new Vibration(from, destination, options.d()));
    }

    private Vibration.Destination getVibrationParticleOptionDestinationAsEntityPositionSource(dda positionSource, cjw level) {
        positionSource.a(level);
        Either entity = EntityPositionSource_sourceEntity.get(positionSource);
        if (entity.left().isPresent()) {
            return new Vibration.Destination.EntityDestination((Entity)((bdr)entity.left().get()).getBukkitEntity());
        }
        Either id = (Either)entity.right().get();
        if (id.left().isPresent()) {
            return new Vibration.Destination.EntityDestination(Bukkit.getEntity((UUID)((UUID)id.left().get())));
        }
        bdr foundEntity = null;
        for (ahm world : MINECRAFT_SERVER.E()) {
            bdr entityById = world.a(((Integer)id.right().get()).intValue());
            if (entityById == null) continue;
            foundEntity = entityById;
            break;
        }
        return new Vibration.Destination.EntityDestination((Entity)foundEntity.getBukkitEntity());
    }

    public PotionEffectType getPotionEffect(CommandContext<dn> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getByKey((NamespacedKey)NMS_1_19_3_R2.fromResourceLocation(iw.e.b((Object)((bdi)ej.f(cmdCtx, (String)key).a()))));
    }

    public CommandSender getSenderForCommand(CommandContext<dn> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dn css = (dn)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        eae pos = css.d();
        ead rot = css.k();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.i, rot.j);
        bdr proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<dn> cmdCtx, String key, ArgumentSubType subType) {
        acf soundResource = el.e(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                aln soundEvent = (aln)iw.c.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((aln)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SuggestionProvider<dn> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                act functionData = this.getMinecraftServer().az();
                dq.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return dq.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> gf.b;
            case SuggestionProviders.SOUNDS -> gf.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dq.a(this.getMinecraftServer().ay().a().stream().map(ac::h), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dq.a((Iterable)this.getMinecraftServer().aG().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> gf.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        Collection customFunctions = MINECRAFT_SERVER.az().b(new acf(key.getNamespace(), key.getKey()));
        return customFunctions.toArray(new SimpleFunctionWrapper[0]);
    }

    public World getWorldForCSS(dn css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public void hookChatPreview(Plugin plugin, Player player) {
    }

    public final boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = NMS_1_19_3_R2.MINECRAFT_SERVER.at;
        serverResources.b().d = MINECRAFT_SERVER.aB();
        try {
            CommandAPIHandler.getInstance().getField(acs.class, "g").set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        ArrayList<String> packIDs = new ArrayList<String>(MINECRAFT_SERVER.aA().d());
        List disabledPacks = MINECRAFT_SERVER.aV().F().a().b();
        for (String availablePack : MINECRAFT_SERVER.aA().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        hn.b registryAccess = MINECRAFT_SERVER.aW();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            ajp serverPackRepository = MINECRAFT_SERVER.aA();
            ArrayList<ais> packResources = new ArrayList<ais>();
            for (String packID : collection) {
                ajn pack = serverPackRepository.a(packID);
                if (pack == null) continue;
                packResources.add(pack.e());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            ajx resourceManager = new ajx(ait.b, packResources);
            CompletableFuture simpleReloadInstance = akk.a((ake)resourceManager, (List)serverResources.b().h(), (Executor)NMS_1_19_3_R2.MINECRAFT_SERVER.ar, (Executor)MINECRAFT_SERVER, CompletableFuture.completedFuture(aoz.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            NMS_1_19_3_R2.MINECRAFT_SERVER.at.close();
            NMS_1_19_3_R2.MINECRAFT_SERVER.at = serverResources;
            NMS_1_19_3_R2.MINECRAFT_SERVER.server.syncCommands();
            MINECRAFT_SERVER.aA().a(collection);
            Collection selectedIDs = MINECRAFT_SERVER.aA().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(MINECRAFT_SERVER.aA().b());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            MINECRAFT_SERVER.aV().a(new cko(new cjk((List)enabledIDs, disabledIDs), MINECRAFT_SERVER.aV().F().b()));
            NMS_1_19_3_R2.MINECRAFT_SERVER.at.b().a((hn)registryAccess);
            MINECRAFT_SERVER.aU().a((ake)NMS_1_19_3_R2.MINECRAFT_SERVER.at.a());
        });
        if (MINECRAFT_SERVER.bm()) {
            MINECRAFT_SERVER.c(((CompletableFuture)third)::isDone);
        }
        try {
            while (true) {
                if (!recipes.hasNext()) {
                    CommandAPI.logNormal((String)"Finished reloading datapacks");
                    return;
                }
                Recipe recipe = (Recipe)recipes.next();
                try {
                    Bukkit.addRecipe((Recipe)recipe);
                    if (!(recipe instanceof Keyed)) continue;
                    Keyed keyedRecipe = (Keyed)recipe;
                    CommandAPI.logInfo((String)("Re-registering recipe: " + keyedRecipe.getKey()));
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public final void resendPackets(Player player) {
        MINECRAFT_SERVER.aB().a(((CraftPlayer)player).getHandle());
    }

    public final void unhookChatPreview(Player player) {
        Channel channel = ((CraftPlayer)player).getHandle().b.b.m;
        if (channel.pipeline().get("CommandAPI_" + player.getName()) != null) {
            channel.eventLoop().submit(() -> channel.pipeline().remove("CommandAPI_" + player.getName()));
        }
    }

    public Message generateMessageFromJson(String json) {
        return ss.a.a((String)json);
    }

    public final MinecraftServer getMinecraftServer() {
        return MINECRAFT_SERVER;
    }

    public ArgumentType<?> _ArgumentMobEffect() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.M);
    }

    public ArgumentType<?> _ArgumentEntitySummon() {
        return ej.a((di)COMMAND_BUILD_CONTEXT, (ace)ix.q);
    }

    static {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            MINECRAFT_SERVER = server2.getServer();
            COMMAND_BUILD_CONTEXT = di.a((hn)MINECRAFT_SERVER.aW(), (byx)MINECRAFT_SERVER.aV().F().b());
        } else {
            MINECRAFT_SERVER = null;
            COMMAND_BUILD_CONTEXT = null;
        }
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(dda.class, MethodHandles.lookup()).findVarHandle(dda.class, "c", Either.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
        ERROR_BIOME_INVALID = new DynamicCommandExceptionType(arg -> ss.a((String)"commands.locatebiome.invalid", (Object[])new Object[]{arg}));
    }
}

