/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.collect.ImmutableList;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.logging.LogUtils;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.EntitySelector;
import dev.jorel.commandapi.arguments.SuggestionProviders;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.ComplexRecipeImpl;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_18_R2.CraftLootTable;
import org.bukkit.craftbukkit.v1_18_R2.CraftParticle;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.CraftSound;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_18_R2.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_18_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_18_R2.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.potion.CraftPotionEffectType;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ComplexRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public class NMS_1_18_R2
extends NMS_Common<dm> {
    private static final MinecraftServer MINECRAFT_SERVER = ((CraftServer)Bukkit.getServer()).getServer();
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;

    private static NamespacedKey fromResourceLocation(yt key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return et.a();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return eu.a();
    }

    public ArgumentType<?> _ArgumentEntity(EntitySelector selector) {
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> dw.b();
            case EntitySelector.MANY_PLAYERS -> dw.d();
            case EntitySelector.ONE_ENTITY -> dw.a();
            case EntitySelector.ONE_PLAYER -> dw.c();
        };
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return fm.a();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return fj.a();
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return el.a((ys)hb.aP);
    }

    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        for (Map.Entry<String, HelpTopic> entry : helpTopicsToAdd.entrySet()) {
            helpTopics.put(entry.getKey(), entry.getValue());
        }
    }

    public String[] compatibleVersions() {
        return new String[]{"1.18.2"};
    }

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).u().e_();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(dj commandFunction) {
        ToIntFunction<dm> appliedObj = css -> MINECRAFT_SERVER.ay().a(commandFunction, css);
        dj.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_18_R2.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<dm> dispatcher) throws IOException {
        Files.asCharSink((File)file, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)fw.a(dispatcher, (CommandNode)dispatcher.getRoot())));
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Component getAdventureChat(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return PaperComponents.gsonSerializer().deserialize((Object)qk.a.a((qk)ea.a(cmdCtx, (String)key)));
    }

    public Component getAdventureChatComponent(CommandContext<dm> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)qk.a.a((qk)ds.a(cmdCtx, (String)key)));
    }

    public Biome getBiome(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        el.b biomeResult = el.a(cmdCtx, (String)key);
        if (biomeResult.a().left().isPresent()) {
            return Biome.valueOf((String)((ys)biomeResult.a().left().get()).a().a().toUpperCase());
        }
        throw new DynamicCommandExceptionType(x -> new qy("commands.locatebiome.invalid", new Object[]{x})).create((Object)biomeResult.b());
    }

    public Predicate<Block> getBlockPredicate(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = et.a(cmdCtx, (String)key);
        return block -> predicate.test(new coz((cay)((dm)cmdCtx.getSource()).e(), new gj(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<dm> cmdCtx, String key) {
        return CraftBlockData.fromData((cov)eu.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<dm> getBrigadierDispatcher() {
        return NMS_1_18_R2.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    public ChatColor getChatColor(CommandContext<dm> cmdCtx, String str) {
        return CraftChatMessage.getColor((p)dr.a(cmdCtx, (String)str));
    }

    public dm getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    public CommandSender getCommandSenderFromCSS(dm css) {
        try {
            return css.getBukkitSender();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    public Enchantment getEnchantment(CommandContext<dm> cmdCtx, String str) {
        return new CraftEnchantment(dz.a(cmdCtx, (String)str));
    }

    public Object getEntitySelector(CommandContext<dm> cmdCtx, String str, EntitySelector selector) throws CommandSyntaxException {
        fp argument = (fp)cmdCtx.getArgument(str, fp.class);
        try {
            CommandAPIHandler.getInstance().getField(fp.class, "o").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (axk entity : argument.b((dm)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case EntitySelector.MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (adx player : argument.d((dm)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case EntitySelector.ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dm)cmdCtx.getSource()).getBukkitEntity();
            }
            case EntitySelector.ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dm)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
        };
    }

    public EntityType getEntityType(CommandContext<dm> cmdCtx, String str) throws CommandSyntaxException {
        return EntityType.fromName((String)axo.a((axo)((axo)hb.W.a(dx.a(cmdCtx, (String)str)))).a());
    }

    public FunctionWrapper[] getFunction(CommandContext<dm> cmdCtx, String str) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dm css = ((dm)cmdCtx.getSource()).a().b(2);
        for (dj commandFunction : fi.a(cmdCtx, (String)str)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dm)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        return this.convertFunction((dj)MINECRAFT_SERVER.ay().a(new yt(key.getNamespace(), key.getKey())).get());
    }

    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (yt resourceLocation : MINECRAFT_SERVER.ay().e()) {
            result.add(NMS_1_18_R2.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public ItemStack getItemStack(CommandContext<dm> cmdCtx, String str) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((buw)fj.a(cmdCtx, (String)str).a(1, false));
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fm.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        adn blockPos = ey.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)blockPos.a, (double)blockPos.b);
    }

    public Location2D getLocation2DPrecise(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        dpn vecPos = fd.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public Location getLocationBlock(CommandContext<dm> cmdCtx, String str) throws CommandSyntaxException {
        gj blockPos = ex.a(cmdCtx, (String)str);
        return new Location(this.getWorldForCSS((dm)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public Location getLocationPrecise(CommandContext<dm> cmdCtx, String str) throws CommandSyntaxException {
        dpo vecPos = fe.b(cmdCtx, (String)str).a((dm)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dm)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public LootTable getLootTable(CommandContext<dm> cmdCtx, String str) {
        yt resourceLocation = ek.e(cmdCtx, (String)str);
        return new CraftLootTable(NMS_1_18_R2.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.aF().a(resourceLocation));
    }

    public String getObjective(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return ee.a(cmdCtx, (String)key).b();
    }

    public String getObjectiveCriteria(CommandContext<dm> cmdCtx, String key) {
        return ef.a(cmdCtx, (String)key).d();
    }

    public ParticleData<?> getParticle(CommandContext<dm> cmdCtx, String str) {
        ia particleOptions = eh.a(cmdCtx, (String)str);
        adw level = ((dm)cmdCtx.getSource()).e();
        Particle particle = CraftParticle.toBukkit((ia)particleOptions);
        if (particleOptions instanceof id) {
            id options = (id)particleOptions;
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof hu) {
            hu options = (hu)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((cov)options.c()));
        }
        if (particleOptions instanceof hv) {
            hv options = (hv)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
        }
        if (particleOptions instanceof hw) {
            hw options = (hw)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof hy) {
            hy options = (hy)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((buw)options.c()));
        }
        if (particleOptions instanceof ie) {
            Vibration.Destination.EntityDestination destination;
            ie options = (ie)particleOptions;
            gj origin = options.c().b();
            Location from = new Location((World)level.getWorld(), (double)origin.u(), (double)origin.v(), (double)origin.w());
            ctc ctc2 = options.c().c();
            if (ctc2 instanceof csv) {
                csv positionSource = (csv)ctc2;
                to = (gj)positionSource.a((cav)level).get();
                destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.u(), (double)to.v(), (double)to.w()));
            } else {
                to = options.c().c();
                if (to instanceof csw) {
                    csw positionSource = (csw)to;
                    positionSource.a((cav)level);
                    Optional entity = EntityPositionSource_sourceEntity.get(positionSource);
                    destination = new Vibration.Destination.EntityDestination((Entity)((axk)entity.get()).getBukkitEntity());
                } else {
                    CommandAPI.getLogger().warning("Unknown vibration destination " + options.c().c());
                    return new ParticleData(particle, null);
                }
            }
            return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c().a()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    public PotionEffectType getPotionEffect(CommandContext<dm> cmdCtx, String str) throws CommandSyntaxException {
        return new CraftPotionEffectType(eb.a(cmdCtx, (String)str));
    }

    public ComplexRecipe getRecipe(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        bxo recipe = ek.b(cmdCtx, (String)key);
        return new ComplexRecipeImpl(NMS_1_18_R2.fromResourceLocation(recipe.f()), recipe.toBukkitRecipe());
    }

    public CommandSender getSenderForCommand(CommandContext<dm> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dm css = (dm)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        dpo pos = css.d();
        dpn rot = css.i();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.i, rot.j);
        axk proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public Sound getSound(CommandContext<dm> cmdCtx, String key) {
        return CraftSound.getBukkit((ahj)((ahj)hb.R.a(ek.e(cmdCtx, (String)key))));
    }

    public SuggestionProvider<dm> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                zg functionData = MINECRAFT_SERVER.ay();
                dp.a((Iterable)functionData.f(), (SuggestionsBuilder)builder, (String)"#");
                return dp.a((Iterable)functionData.e(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> fy.b;
            case SuggestionProviders.SOUNDS -> fy.c;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> dp.a(MINECRAFT_SERVER.ax().a().stream().map(af::h), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> dp.a((Iterable)MINECRAFT_SERVER.aF().a(), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> fy.d;
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = MINECRAFT_SERVER.ay().b(new yt(key.getNamespace(), key.getKey())).a();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((dj)customFunctions.get(i));
        }
        return result;
    }

    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (yt resourceLocation : MINECRAFT_SERVER.ay().e()) {
            result.add(NMS_1_18_R2.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    public String getTeam(CommandContext<dm> cmdCtx, String key) throws CommandSyntaxException {
        return ep.a(cmdCtx, (String)key).b();
    }

    public World getWorldForCSS(dm css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public void reloadDataPacks() {
        CommandAPI.logNormal((String)"Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.a serverResources = NMS_1_18_R2.MINECRAFT_SERVER.aB;
        serverResources.b().c = MINECRAFT_SERVER.aA();
        try {
            CommandAPIHandler.getInstance().getField(zf.class, "i").set(serverResources.b().a(), this.getBrigadierDispatcher());
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        ArrayList<String> packIDs = new ArrayList<String>(MINECRAFT_SERVER.az().d());
        List disabledPacks = MINECRAFT_SERVER.aT().D().b();
        for (String availablePack : MINECRAFT_SERVER.az().b()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        hc.a registryAccess = MINECRAFT_SERVER.aU();
        CompletableFuture<List> first = CompletableFuture.supplyAsync(() -> {
            afn serverPackRepository = MINECRAFT_SERVER.az();
            ArrayList<afa> packResources = new ArrayList<afa>();
            for (String packID : collection) {
                afl pack = serverPackRepository.a(packID);
                if (pack == null) continue;
                packResources.add(pack.d());
            }
            return packResources;
        });
        CompletionStage second = first.thenCompose(packResources -> {
            afu resourceManager = new afu(afb.b, packResources);
            CompletableFuture simpleReloadInstance = agf.a((aga)resourceManager, (List)serverResources.b().h(), (Executor)NMS_1_18_R2.MINECRAFT_SERVER.az, (Executor)MINECRAFT_SERVER, CompletableFuture.completedFuture(aka.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        });
        CompletionStage third = ((CompletableFuture)second).thenAcceptAsync(resources -> {
            NMS_1_18_R2.MINECRAFT_SERVER.aB.close();
            NMS_1_18_R2.MINECRAFT_SERVER.aB = serverResources;
            NMS_1_18_R2.MINECRAFT_SERVER.server.syncCommands();
            MINECRAFT_SERVER.az().a(collection);
            Collection selectedIDs = MINECRAFT_SERVER.az().d();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList disabledIDs = new ArrayList(MINECRAFT_SERVER.az().b());
            ListIterator disabledIDsIterator = disabledIDs.listIterator();
            while (disabledIDsIterator.hasNext()) {
                if (!enabledIDs.contains(disabledIDsIterator.next())) continue;
                disabledIDsIterator.remove();
            }
            MINECRAFT_SERVER.aT().a(new caj((List)enabledIDs, disabledIDs));
            NMS_1_18_R2.MINECRAFT_SERVER.aB.b().a((hc)registryAccess);
            MINECRAFT_SERVER.aS().a((aga)NMS_1_18_R2.MINECRAFT_SERVER.aB.a());
        });
        if (MINECRAFT_SERVER.bk()) {
            MINECRAFT_SERVER.c(((CompletableFuture)third)::isDone);
        }
        try {
            ((CompletableFuture)third).get();
            while (recipes.hasNext()) {
                Recipe recipe = (Recipe)recipes.next();
                try {
                    Bukkit.addRecipe((Recipe)recipe);
                    if (!(recipe instanceof Keyed)) continue;
                    Keyed keyedRecipe = (Keyed)recipe;
                    CommandAPI.logInfo((String)("Re-registering recipe: " + keyedRecipe.getKey()));
                }
                catch (Exception e) {}
            }
            CommandAPI.logNormal((String)"Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError((String)("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString()));
        }
    }

    public void resendPackets(Player player) {
        MINECRAFT_SERVER.aA().a(((CraftPlayer)player).getHandle());
    }

    static {
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(csw.class, MethodHandles.lookup()).findVarHandle(csw.class, "d", Optional.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
    }
}

