/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.ArgumentSubType;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_17_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftSound;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_17_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public abstract class NMS_1_17_Common
extends NMS_Common {
    protected static final MinecraftServer MINECRAFT_SERVER = ((CraftServer)Bukkit.getServer()).getServer();
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;

    private static NamespacedKey fromResourceLocation(ww key) {
        return NamespacedKey.fromString((String)(key.b() + ":" + key.a()));
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return eq.a();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return er.a();
    }

    public ArgumentType<?> _ArgumentEntity(ArgumentSubType subType) {
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> dv.b();
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> dv.d();
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> dv.a();
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> dv.c();
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return fj.a();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return fg.a();
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        helpTopics.putAll(helpTopicsToAdd);
    }

    public abstract String[] compatibleVersions();

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).t().d_();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(di commandFunction) {
        ToIntFunction<dl> appliedObj = css -> MINECRAFT_SERVER.az().a(commandFunction, css);
        di.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_17_Common.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<dl> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ft.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Component getAdventureChatComponent(CommandContext<dl> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)os.a.a((os)dr.a(cmdCtx, (String)key)));
    }

    public Object getBiome(CommandContext<dl> cmdCtx, String key, ArgumentSubType subType) throws CommandSyntaxException {
        return switch (subType) {
            case ArgumentSubType.BIOME_BIOME -> {
                Biome biome = null;
                try {
                    biome = Biome.valueOf((String)((ww)cmdCtx.getArgument(key, ww.class)).a().toUpperCase());
                }
                catch (IllegalArgumentException biomeNotFound) {
                    biome = null;
                }
                Biome var4_6 = biome;
                yield var4_6;
            }
            case ArgumentSubType.BIOME_NAMESPACEDKEY -> {
                NamespacedKey var4_7;
                yield var4_7 = NMS_1_17_Common.fromResourceLocation((ww)cmdCtx.getArgument(key, ww.class));
            }
            default -> {
                NamespacedKey var4_8;
                yield var4_8 = null;
            }
        };
    }

    public Predicate<Block> getBlockPredicate(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = eq.a(cmdCtx, (String)key);
        return block -> predicate.test(new ckx((bwt)((dl)cmdCtx.getSource()).e(), new gg(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<dl> cmdCtx, String key) {
        return CraftBlockData.fromData((ckt)er.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<dl> getBrigadierDispatcher() {
        return NMS_1_17_Common.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    public dl getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    public Object getEntitySelector(CommandContext<dl> cmdCtx, String str, ArgumentSubType subType) throws CommandSyntaxException {
        fm argument = (fm)cmdCtx.getArgument(str, fm.class);
        try {
            CommandAPIHandler.getInstance().getField(fm.class, "o").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (subType) {
            case ArgumentSubType.ENTITYSELECTOR_MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (atg entity : argument.b((dl)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (abs player : argument.d((dl)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((dl)cmdCtx.getSource()).getBukkitEntity();
            }
            case ArgumentSubType.ENTITYSELECTOR_ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((dl)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public EntityType getEntityType(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        return EntityType.fromName((String)atk.a((atk)((atk)gw.Y.a(dw.a(cmdCtx, (String)key)))).a());
    }

    public FunctionWrapper[] getFunction(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        dl css = ((dl)cmdCtx.getSource()).a().b(2);
        for (di commandFunction : ff.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((dl)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public ItemStack getItemStack(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((bqq)fg.a(cmdCtx, (String)key).a(1, false));
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = fj.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        abi blockPos = ev.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dl)cmdCtx.getSource()), (double)blockPos.a, (double)blockPos.b);
    }

    public Location2D getLocation2DPrecise(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        dmz vecPos = fa.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((dl)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public Location getLocationBlock(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        gg blockPos = eu.a(cmdCtx, (String)key);
        return new Location(this.getWorldForCSS((dl)cmdCtx.getSource()), (double)blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
    }

    public Location getLocationPrecise(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        dna vecPos = fb.b(cmdCtx, (String)key).a((dl)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((dl)cmdCtx.getSource()), vecPos.a(), vecPos.b(), vecPos.c());
    }

    public LootTable getLootTable(CommandContext<dl> cmdCtx, String key) {
        ww resourceLocation = ei.f(cmdCtx, (String)key);
        return new CraftLootTable(NMS_1_17_Common.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.aH().a(resourceLocation));
    }

    public NamespacedKey getMinecraftKey(CommandContext<dl> cmdCtx, String key) {
        return NMS_1_17_Common.fromResourceLocation(ei.f(cmdCtx, (String)key));
    }

    public ParticleData<?> getParticle(CommandContext<dl> cmdCtx, String key) {
        ht particleOptions = eg.a(cmdCtx, (String)key);
        Particle particle = CraftParticle.toBukkit((ht)particleOptions);
        if (particleOptions instanceof hw) {
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof hn) {
            hn options = (hn)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((ckt)options.c()));
        }
        if (particleOptions instanceof ho) {
            ho options = (ho)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof hp) {
            hp options = (hp)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof hr) {
            hr options = (hr)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((bqq)options.c()));
        }
        if (particleOptions instanceof hx) {
            hx options = (hx)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(Particle particle, ho options) {
        Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
        return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<dl> cmdCtx, Particle particle, hx options) {
        Vibration.Destination.EntityDestination destination;
        gg origin = options.c().b();
        abr level = ((dl)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), (double)origin.u(), (double)origin.v(), (double)origin.w());
        cpa cpa2 = options.c().c();
        if (cpa2 instanceof cot) {
            cot positionSource = (cot)cpa2;
            to = (gg)positionSource.a((bwq)level).get();
            destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.u(), (double)to.v(), (double)to.w()));
        } else {
            to = options.c().c();
            if (to instanceof cou) {
                cou positionSource = (cou)to;
                positionSource.a((bwq)level);
                Optional entity = EntityPositionSource_sourceEntity.get(positionSource);
                destination = new Vibration.Destination.EntityDestination((Entity)((atg)entity.get()).getBukkitEntity());
            } else {
                CommandAPI.getLogger().warning("Unknown vibration destination " + options.c().c());
                return new ParticleData(particle, null);
            }
        }
        return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c().a()));
    }

    public PotionEffectType getPotionEffect(CommandContext<dl> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getById((int)gw.V.a((Object)ea.a(cmdCtx, (String)key)));
    }

    public CommandSender getSenderForCommand(CommandContext<dl> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        dl css = (dl)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        dna pos = css.d();
        dmz rot = css.i();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.a(), pos.b(), pos.c(), rot.i, rot.j);
        atg proxyEntity = css.f();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final Object getSound(CommandContext<dl> cmdCtx, String key, ArgumentSubType subType) {
        ww soundResource = ei.f(cmdCtx, (String)key);
        return switch (subType) {
            case ArgumentSubType.SOUND_SOUND -> {
                afd soundEvent = (afd)gw.T.a(soundResource);
                if (soundEvent == null) {
                    yield null;
                }
                yield CraftSound.getBukkit((afd)soundEvent);
            }
            case ArgumentSubType.SOUND_NAMESPACEDKEY -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a()));
            default -> throw new IllegalArgumentException("Unexpected value: " + subType);
        };
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = MINECRAFT_SERVER.az().b(new ww(key.getNamespace(), key.getKey())).b();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((di)customFunctions.get(i));
        }
        return result;
    }

    public World getWorldForCSS(dl css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public abstract void reloadDataPacks();

    public void resendPackets(Player player) {
        MINECRAFT_SERVER.aB().a(((CraftPlayer)player).getHandle());
    }

    public Message generateMessageFromJson(String json) {
        return os.a.a((String)json);
    }

    public MinecraftServer getMinecraftServer() {
        return MINECRAFT_SERVER;
    }

    static {
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(cou.class, MethodHandles.lookup()).findVarHandle(cou.class, "d", Optional.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
    }
}

