/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.EntitySelector;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CustomFunction;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentEntitySummon;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentMobEffect;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2I;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.synchronization.ArgumentRegistry;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.BlockPosition2D;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_17_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftSound;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_17_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;

public abstract class NMS_1_17_Common
extends NMS_Common {
    protected static final MinecraftServer MINECRAFT_SERVER = ((CraftServer)Bukkit.getServer()).getServer();
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;

    private static NamespacedKey fromResourceLocation(MinecraftKey key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getKey()));
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return ArgumentBlockPredicate.a();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return ArgumentTile.a();
    }

    public ArgumentType<?> _ArgumentEntity(EntitySelector selector) {
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> ArgumentEntity.multipleEntities();
            case EntitySelector.MANY_PLAYERS -> ArgumentEntity.d();
            case EntitySelector.ONE_ENTITY -> ArgumentEntity.a();
            case EntitySelector.ONE_PLAYER -> ArgumentEntity.c();
        };
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return ArgumentItemPredicate.a();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return ArgumentItemStack.a();
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        for (Map.Entry<String, HelpTopic> entry : helpTopicsToAdd.entrySet()) {
            helpTopics.put(entry.getKey(), entry.getValue());
        }
    }

    public abstract String[] compatibleVersions();

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().asString();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).a();
    }

    private SimpleFunctionWrapper convertFunction(CustomFunction commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> MINECRAFT_SERVER.getFunctionData().a(commandFunction, css);
        CustomFunction.c[] cArr = commandFunction.b();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_17_Common.fromResourceLocation(commandFunction.a()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<CommandListenerWrapper> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentRegistry.a(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Component getAdventureChatComponent(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)ArgumentChatComponent.a(cmdCtx, (String)key)));
    }

    public Biome getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return Biome.valueOf((String)((MinecraftKey)cmdCtx.getArgument(key, MinecraftKey.class)).getKey().toUpperCase());
    }

    public Predicate<Block> getBlockPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentBlockPredicate.a(cmdCtx, (String)key);
        return block -> predicate.test(new ShapeDetectorBlock((IWorldReader)((CommandListenerWrapper)cmdCtx.getSource()).getWorld(), new BlockPosition(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftBlockData.fromData((IBlockData)ArgumentTile.a(cmdCtx, (String)key).a());
    }

    public CommandDispatcher<CommandListenerWrapper> getBrigadierDispatcher() {
        return NMS_1_17_Common.MINECRAFT_SERVER.vanillaCommandDispatcher.a();
    }

    public CommandListenerWrapper getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    public Object getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str, EntitySelector selector) throws CommandSyntaxException {
        net.minecraft.commands.arguments.selector.EntitySelector argument = (net.minecraft.commands.arguments.selector.EntitySelector)cmdCtx.getArgument(str, net.minecraft.commands.arguments.selector.EntitySelector.class);
        try {
            CommandAPIHandler.getInstance().getField(net.minecraft.commands.arguments.selector.EntitySelector.class, "o").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (net.minecraft.world.entity.Entity entity : argument.getEntities((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case EntitySelector.MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case EntitySelector.ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
            }
            case EntitySelector.ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
        };
    }

    public EntityType getEntityType(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return EntityType.fromName((String)EntityTypes.getName((EntityTypes)((EntityTypes)IRegistry.Y.get(ArgumentEntitySummon.a(cmdCtx, (String)str)))).getKey());
    }

    public FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CustomFunction commandFunction : ArgumentTag.a(cmdCtx, (String)str)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ArgumentItemStack.a(cmdCtx, (String)str).a(1, false));
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        BlockPosition2D blockPos = ArgumentVec2I.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.a, (double)blockPos.b);
    }

    public Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)vecPos.i, (double)vecPos.j);
    }

    public Location getLocationBlock(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        BlockPosition blockPos = ArgumentPosition.a(cmdCtx, (String)str);
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    public Location getLocationPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String str) throws CommandSyntaxException {
        Vec3D vecPos = ArgumentVec3.b(cmdCtx, (String)str).a((CommandListenerWrapper)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.getX(), vecPos.getY(), vecPos.getZ());
    }

    public LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        MinecraftKey resourceLocation = ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)str);
        return new CraftLootTable(NMS_1_17_Common.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.getLootTableRegistry().getLootTable(resourceLocation));
    }

    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return NMS_1_17_Common.fromResourceLocation(ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)key));
    }

    public ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)str);
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).getWorld();
        Particle particle = CraftParticle.toBukkit((ParticleParam)particleOptions);
        if (particleOptions instanceof ParticleType) {
            ParticleType options = (ParticleType)particleOptions;
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((IBlockData)options.c()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            Color toColor = Color.fromRGB((int)((int)(options.d().a() * 255.0f)), (int)((int)(options.d().b() * 255.0f)), (int)((int)(options.d().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.f()));
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.e().a() * 255.0f)), (int)((int)(options.e().b() * 255.0f)), (int)((int)(options.e().c() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.f()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.c()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            Vibration.Destination.EntityDestination destination;
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            BlockPosition origin = options.c().b();
            Location from = new Location((World)level.getWorld(), (double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
            PositionSource positionSource = options.c().c();
            if (positionSource instanceof BlockPositionSource) {
                BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
                to = (BlockPosition)positionSource2.a((net.minecraft.world.level.World)level).get();
                destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.getX(), (double)to.getY(), (double)to.getZ()));
            } else {
                to = options.c().c();
                if (to instanceof EntityPositionSource) {
                    EntityPositionSource positionSource3 = (EntityPositionSource)to;
                    positionSource3.a((net.minecraft.world.level.World)level);
                    Optional entity = EntityPositionSource_sourceEntity.get(positionSource3);
                    destination = new Vibration.Destination.EntityDestination((Entity)((net.minecraft.world.entity.Entity)entity.get()).getBukkitEntity());
                } else {
                    CommandAPI.getLogger().warning("Unknown vibration destination " + options.c().c());
                    return new ParticleData(particle, null);
                }
            }
            return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.c().a()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    public PotionEffectType getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return PotionEffectType.getById((int)IRegistry.V.getId((Object)ArgumentMobEffect.a(cmdCtx, (String)key)));
    }

    public CommandSender getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        Vec3D pos = css.getPosition();
        Vec2F rot = css.i();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.getX(), pos.getY(), pos.getZ(), rot.i, rot.j);
        net.minecraft.world.entity.Entity proxyEntity = css.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public final <SoundOrNamespacedKey> SoundOrNamespacedKey getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key, Class<SoundOrNamespacedKey> returnType) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.f(cmdCtx, (String)key);
        if (returnType.equals(NamespacedKey.class)) {
            return (SoundOrNamespacedKey)NamespacedKey.fromString((String)(soundResource.getNamespace() + ":" + soundResource.getKey()));
        }
        SoundEffect soundEvent = (SoundEffect)IRegistry.T.get(soundResource);
        if (soundEvent == null) {
            return null;
        }
        return (SoundOrNamespacedKey)CraftSound.getBukkit((SoundEffect)soundEvent);
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = MINECRAFT_SERVER.getFunctionData().b(new MinecraftKey(key.getNamespace(), key.getKey())).getTagged();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((CustomFunction)customFunctions.get(i));
        }
        return result;
    }

    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.getWorld() == null ? null : css.getWorld().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public abstract void reloadDataPacks();

    public void resendPackets(Player player) {
        MINECRAFT_SERVER.getCommandDispatcher().a(((CraftPlayer)player).getHandle());
    }

    public Message generateMessageFromJson(String json) {
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    public MinecraftServer getMinecraftServer() {
        return MINECRAFT_SERVER;
    }

    static {
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(EntityPositionSource.class, MethodHandles.lookup()).findVarHandle(EntityPositionSource.class, "d", Optional.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
    }
}

