/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nms;

import com.google.common.io.Files;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIHandler;
import dev.jorel.commandapi.arguments.EntitySelector;
import dev.jorel.commandapi.nms.NMS_Common;
import dev.jorel.commandapi.wrappers.FunctionWrapper;
import dev.jorel.commandapi.wrappers.Location2D;
import dev.jorel.commandapi.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.wrappers.ParticleData;
import dev.jorel.commandapi.wrappers.SimpleFunctionWrapper;
import io.papermc.paper.text.PaperComponents;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_17_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_17_R1.CraftParticle;
import org.bukkit.craftbukkit.v1_17_R1.CraftServer;
import org.bukkit.craftbukkit.v1_17_R1.CraftSound;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_17_R1.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_17_R1.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTable;

public abstract class NMS_1_17_Common
extends NMS_Common {
    protected static final MinecraftServer MINECRAFT_SERVER = ((CraftServer)Bukkit.getServer()).getServer();
    private static final VarHandle SimpleHelpMap_helpTopics;
    private static final VarHandle EntityPositionSource_sourceEntity;

    private static NamespacedKey fromResourceLocation(ResourceLocation key) {
        return NamespacedKey.fromString((String)(key.getNamespace() + ":" + key.getPath()));
    }

    public ArgumentType<?> _ArgumentBlockPredicate() {
        return BlockPredicateArgument.blockPredicate();
    }

    public ArgumentType<?> _ArgumentBlockState() {
        return BlockStateArgument.block();
    }

    public ArgumentType<?> _ArgumentEntity(EntitySelector selector) {
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> EntityArgument.entities();
            case EntitySelector.MANY_PLAYERS -> EntityArgument.players();
            case EntitySelector.ONE_ENTITY -> EntityArgument.entity();
            case EntitySelector.ONE_PLAYER -> EntityArgument.player();
        };
    }

    public ArgumentType<?> _ArgumentItemPredicate() {
        return ItemPredicateArgument.itemPredicate();
    }

    public ArgumentType<?> _ArgumentItemStack() {
        return ItemArgument.item();
    }

    public ArgumentType<?> _ArgumentSyntheticBiome() {
        return this._ArgumentMinecraftKeyRegistered();
    }

    public void addToHelpMap(Map<String, HelpTopic> helpTopicsToAdd) {
        Map helpTopics = SimpleHelpMap_helpTopics.get(Bukkit.getServer().getHelpMap());
        for (Map.Entry<String, HelpTopic> entry : helpTopicsToAdd.entrySet()) {
            helpTopics.put(entry.getKey(), entry.getValue());
        }
    }

    public abstract String[] compatibleVersions();

    public String convert(ItemStack is) {
        return is.getType().getKey().toString() + CraftItemStack.asNMSCopy((ItemStack)is).getOrCreateTag().getAsString();
    }

    public String convert(ParticleData<?> particle) {
        return CraftParticle.toNMS((Particle)particle.particle(), (Object)particle.data()).writeToString();
    }

    private SimpleFunctionWrapper convertFunction(CommandFunction commandFunction) {
        ToIntFunction<CommandSourceStack> appliedObj = css -> MINECRAFT_SERVER.getFunctions().execute(commandFunction, css);
        CommandFunction.Entry[] cArr = commandFunction.getEntries();
        String[] result = new String[cArr.length];
        int size = cArr.length;
        for (int i = 0; i < size; ++i) {
            result[i] = cArr[i].toString();
        }
        return new SimpleFunctionWrapper(NMS_1_17_Common.fromResourceLocation(commandFunction.getId()), appliedObj, result);
    }

    public void createDispatcherFile(File file, CommandDispatcher<CommandSourceStack> dispatcher) throws IOException {
        Files.write((CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)ArgumentTypes.serializeNodeToJson(dispatcher, (CommandNode)dispatcher.getRoot())), (File)file, (Charset)StandardCharsets.UTF_8);
    }

    public HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    public Component getAdventureChatComponent(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return PaperComponents.gsonSerializer().deserialize((Object)Component.Serializer.toJson((net.minecraft.network.chat.Component)ComponentArgument.getComponent(cmdCtx, (String)key)));
    }

    public Biome getBiome(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return Biome.valueOf((String)((ResourceLocation)cmdCtx.getArgument(key, ResourceLocation.class)).getPath().toUpperCase());
    }

    public Predicate<Block> getBlockPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = BlockPredicateArgument.getBlockPredicate(cmdCtx, (String)key);
        return block -> predicate.test(new BlockInWorld((LevelReader)((CommandSourceStack)cmdCtx.getSource()).getLevel(), new BlockPos(block.getX(), block.getY(), block.getZ()), true));
    }

    public BlockData getBlockState(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return CraftBlockData.fromData((BlockState)BlockStateArgument.getBlock(cmdCtx, (String)key).getState());
    }

    public CommandDispatcher<CommandSourceStack> getBrigadierDispatcher() {
        return NMS_1_17_Common.MINECRAFT_SERVER.vanillaCommandDispatcher.getDispatcher();
    }

    public CommandSourceStack getCLWFromCommandSender(CommandSender sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender);
    }

    public Object getEntitySelector(CommandContext<CommandSourceStack> cmdCtx, String str, EntitySelector selector) throws CommandSyntaxException {
        net.minecraft.commands.arguments.selector.EntitySelector argument = (net.minecraft.commands.arguments.selector.EntitySelector)cmdCtx.getArgument(str, net.minecraft.commands.arguments.selector.EntitySelector.class);
        try {
            CommandAPIHandler.getInstance().getField(net.minecraft.commands.arguments.selector.EntitySelector.class, "o").set(argument, false);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        return switch (selector) {
            default -> throw new IncompatibleClassChangeError();
            case EntitySelector.MANY_ENTITIES -> {
                try {
                    ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                    for (net.minecraft.world.entity.Entity entity : argument.findEntities((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(entity.getBukkitEntity());
                    }
                    ArrayList<CraftEntity> var5_6 = result;
                    yield var5_6;
                }
                catch (CommandSyntaxException e) {
                    CraftEntity var5_7;
                    yield var5_7 = new ArrayList();
                }
            }
            case EntitySelector.MANY_PLAYERS -> {
                try {
                    ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                    for (ServerPlayer player : argument.findPlayers((CommandSourceStack)cmdCtx.getSource())) {
                        result.add(player.getBukkitEntity());
                    }
                    ArrayList<CraftPlayer> var5_8 = result;
                    yield var5_8;
                }
                catch (CommandSyntaxException e) {
                    ArrayList var5_9 = new ArrayList();
                    yield var5_9;
                }
            }
            case EntitySelector.ONE_ENTITY -> {
                CraftEntity var5_10;
                yield var5_10 = argument.findSingleEntity((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
            }
            case EntitySelector.ONE_PLAYER -> {
                CraftPlayer var5_11 = argument.findSinglePlayer((CommandSourceStack)cmdCtx.getSource()).getBukkitEntity();
                yield var5_11;
            }
        };
    }

    public org.bukkit.entity.EntityType getEntityType(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        return org.bukkit.entity.EntityType.fromName((String)EntityType.getKey((EntityType)((EntityType)Registry.ENTITY_TYPE.get(EntitySummonArgument.getSummonableEntity(cmdCtx, (String)str)))).getPath());
    }

    public FunctionWrapper[] getFunction(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandSourceStack css = ((CommandSourceStack)cmdCtx.getSource()).withSuppressedOutput().withMaximumPermission(2);
        for (CommandFunction commandFunction : FunctionArgument.getFunctions(cmdCtx, (String)str)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper((SimpleFunctionWrapper)this.convertFunction(commandFunction), (Object)css, entity -> ((CommandSourceStack)cmdCtx.getSource()).withEntity(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    public ItemStack getItemStack(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)ItemArgument.getItem(cmdCtx, (String)str).createItemStack(1, false));
    }

    public Predicate<ItemStack> getItemStackPredicate(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Predicate predicate = ItemPredicateArgument.getItemPredicate(cmdCtx, (String)key);
        return item -> predicate.test(CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Location2D getLocation2DBlock(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        ColumnPos blockPos = ColumnPosArgument.getColumnPos(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPos.x, (double)blockPos.z);
    }

    public Location2D getLocation2DPrecise(CommandContext<CommandSourceStack> cmdCtx, String key) throws CommandSyntaxException {
        Vec2 vecPos = Vec2Argument.getVec2(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)vecPos.x, (double)vecPos.y);
    }

    public Location getLocationBlock(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        BlockPos blockPos = BlockPosArgument.getLoadedBlockPos(cmdCtx, (String)str);
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
    }

    public Location getLocationPrecise(CommandContext<CommandSourceStack> cmdCtx, String str) throws CommandSyntaxException {
        Vec3 vecPos = Vec3Argument.getCoordinates(cmdCtx, (String)str).getPosition((CommandSourceStack)cmdCtx.getSource());
        return new Location(this.getWorldForCSS((CommandSourceStack)cmdCtx.getSource()), vecPos.x(), vecPos.y(), vecPos.z());
    }

    public LootTable getLootTable(CommandContext<CommandSourceStack> cmdCtx, String str) {
        ResourceLocation resourceLocation = ResourceLocationArgument.getId(cmdCtx, (String)str);
        return new CraftLootTable(NMS_1_17_Common.fromResourceLocation(resourceLocation), MINECRAFT_SERVER.getLootTables().get(resourceLocation));
    }

    public NamespacedKey getMinecraftKey(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return NMS_1_17_Common.fromResourceLocation(ResourceLocationArgument.getId(cmdCtx, (String)key));
    }

    public ParticleData<?> getParticle(CommandContext<CommandSourceStack> cmdCtx, String str) {
        ParticleOptions particleOptions = ParticleArgument.getParticle(cmdCtx, (String)str);
        ServerLevel level = ((CommandSourceStack)cmdCtx.getSource()).getLevel();
        Particle particle = CraftParticle.toBukkit((ParticleOptions)particleOptions);
        if (particleOptions instanceof SimpleParticleType) {
            SimpleParticleType options = (SimpleParticleType)particleOptions;
            return new ParticleData(particle, null);
        }
        if (particleOptions instanceof BlockParticleOption) {
            BlockParticleOption options = (BlockParticleOption)particleOptions;
            return new ParticleData(particle, (Object)CraftBlockData.fromData((BlockState)options.getState()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
            Color toColor = Color.fromRGB((int)((int)(options.getToColor().x() * 255.0f)), (int)((int)(options.getToColor().y() * 255.0f)), (int)((int)(options.getToColor().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustTransition(color, toColor, options.getScale()));
        }
        if (particleOptions instanceof DustParticleOptions) {
            DustParticleOptions options = (DustParticleOptions)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.getColor().x() * 255.0f)), (int)((int)(options.getColor().y() * 255.0f)), (int)((int)(options.getColor().z() * 255.0f)));
            return new ParticleData(particle, (Object)new Particle.DustOptions(color, options.getScale()));
        }
        if (particleOptions instanceof ItemParticleOption) {
            ItemParticleOption options = (ItemParticleOption)particleOptions;
            return new ParticleData(particle, (Object)CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)options.getItem()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            Vibration.Destination.EntityDestination destination;
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            BlockPos origin = options.getVibrationPath().getOrigin();
            Location from = new Location((World)level.getWorld(), (double)origin.getX(), (double)origin.getY(), (double)origin.getZ());
            PositionSource positionSource = options.getVibrationPath().getDestination();
            if (positionSource instanceof BlockPositionSource) {
                BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
                to = (BlockPos)positionSource2.getPosition((Level)level).get();
                destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), (double)to.getX(), (double)to.getY(), (double)to.getZ()));
            } else {
                to = options.getVibrationPath().getDestination();
                if (to instanceof EntityPositionSource) {
                    EntityPositionSource positionSource3 = (EntityPositionSource)to;
                    positionSource3.getPosition((Level)level);
                    Optional entity = EntityPositionSource_sourceEntity.get(positionSource3);
                    destination = new Vibration.Destination.EntityDestination((Entity)((net.minecraft.world.entity.Entity)entity.get()).getBukkitEntity());
                } else {
                    CommandAPI.getLogger().warning("Unknown vibration destination " + options.getVibrationPath().getDestination());
                    return new ParticleData(particle, null);
                }
            }
            return new ParticleData(particle, (Object)new Vibration(from, (Vibration.Destination)destination, options.getVibrationPath().getArrivalInTicks()));
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData(particle, null);
    }

    public CommandSender getSenderForCommand(CommandContext<CommandSourceStack> cmdCtx, boolean isNative) {
        CraftEntity proxy;
        CommandSourceStack css = (CommandSourceStack)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        Vec3 pos = css.getPosition();
        Vec2 rot = css.getRotation();
        World world = this.getWorldForCSS(css);
        Location location = new Location(world, pos.x(), pos.y(), pos.z(), rot.x, rot.y);
        net.minecraft.world.entity.Entity proxyEntity = css.getEntity();
        CraftEntity craftEntity = proxy = proxyEntity == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals(proxy)) {
            return new NativeProxyCommandSender(sender, (CommandSender)proxy, location, world);
        }
        return sender;
    }

    public SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    public Sound getSound(CommandContext<CommandSourceStack> cmdCtx, String key) {
        return CraftSound.getBukkit((SoundEvent)((SoundEvent)Registry.SOUND_EVENT.get(ResourceLocationArgument.getId(cmdCtx, (String)key))));
    }

    public SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = MINECRAFT_SERVER.getFunctions().getTag(new ResourceLocation(key.getNamespace(), key.getKey())).getValues();
        SimpleFunctionWrapper[] result = new SimpleFunctionWrapper[customFunctions.size()];
        int size = customFunctions.size();
        for (int i = 0; i < size; ++i) {
            result[i] = this.convertFunction((CommandFunction)customFunctions.get(i));
        }
        return result;
    }

    public World getWorldForCSS(CommandSourceStack css) {
        return css.getLevel() == null ? null : css.getLevel().getWorld();
    }

    public boolean isVanillaCommandWrapper(Command command) {
        return command instanceof VanillaCommandWrapper;
    }

    public abstract void reloadDataPacks();

    public void resendPackets(Player player) {
        MINECRAFT_SERVER.getCommands().sendCommands(((CraftPlayer)player).getHandle());
    }

    public MinecraftServer getMinecraftServer() {
        return MINECRAFT_SERVER;
    }

    static {
        VarHandle shm_ht = null;
        VarHandle eps_se = null;
        try {
            shm_ht = MethodHandles.privateLookupIn(SimpleHelpMap.class, MethodHandles.lookup()).findVarHandle(SimpleHelpMap.class, "helpTopics", Map.class);
            eps_se = MethodHandles.privateLookupIn(EntityPositionSource.class, MethodHandles.lookup()).findVarHandle(EntityPositionSource.class, "d", Optional.class);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
        SimpleHelpMap_helpTopics = shm_ht;
        EntityPositionSource_sourceEntity = eps_se;
    }
}

