/*
 * Decompiled with CFR 0.152.
 */
package net.luminis.tls.handshake;

import java.nio.ByteBuffer;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.luminis.tls.Logger;
import net.luminis.tls.TlsConstants;
import net.luminis.tls.TlsProtocolException;
import net.luminis.tls.alert.DecodeErrorException;
import net.luminis.tls.alert.IllegalParameterAlert;
import net.luminis.tls.extension.Extension;
import net.luminis.tls.handshake.EncryptedExtensions;
import net.luminis.tls.handshake.HandshakeMessage;

public class ServerHello
extends HandshakeMessage {
    static byte[] HelloRetryRequest_SHA256 = new byte[]{-49, 33, -83, 116, -27, -102, 97, 17, -66, 29, -116, 2, 30, 101, -72, -111, -62, -94, 17, 22, 122, -69, -116, 94, 7, -98, 9, -30, -56, -88, 51, -100};
    private static final int MINIMAL_MESSAGE_LENGTH = 44;
    private static SecureRandom secureRandom = new SecureRandom();
    private byte[] raw;
    private byte[] random;
    private TlsConstants.CipherSuite cipherSuite;
    private PublicKey serverSharedKey;
    private short tlsVersion;
    private List<Extension> extensions = Collections.emptyList();

    public ServerHello() {
    }

    public ServerHello(TlsConstants.CipherSuite cipher) {
        this(cipher, Collections.emptyList());
    }

    public ServerHello(TlsConstants.CipherSuite cipher, List<Extension> extensions) {
        this.random = new byte[32];
        secureRandom.nextBytes(this.random);
        this.cipherSuite = cipher;
        this.extensions = extensions;
        int extensionsSize = extensions.stream().mapToInt(extension -> extension.getBytes().length).sum();
        this.raw = new byte[44 + extensionsSize];
        ByteBuffer buffer = ByteBuffer.wrap(this.raw);
        buffer.putInt(this.raw.length - 4 | 0x2000000);
        buffer.putShort((short)771);
        buffer.put(this.random);
        buffer.put((byte)0);
        buffer.putShort(cipher.value);
        buffer.put((byte)0);
        buffer.putShort((short)extensionsSize);
        extensions.stream().forEach(extension -> buffer.put(extension.getBytes()));
    }

    @Override
    public TlsConstants.HandshakeType getType() {
        return TlsConstants.HandshakeType.server_hello;
    }

    public ServerHello parse(ByteBuffer buffer, int length) throws TlsProtocolException {
        int sessionIdLength;
        if (buffer.remaining() < 44) {
            throw new DecodeErrorException("Message too short");
        }
        buffer.getInt();
        byte versionHigh = buffer.get();
        byte versionLow = buffer.get();
        if (versionHigh != 3 || versionLow != 3) {
            throw new IllegalParameterAlert("Invalid version number (should be 0x0303)");
        }
        this.random = new byte[32];
        buffer.get(this.random);
        if (Arrays.equals(this.random, HelloRetryRequest_SHA256)) {
            Logger.debug("HelloRetryRequest!");
        }
        if ((sessionIdLength = buffer.get() & 0xFF) > 32) {
            throw new DecodeErrorException("session id length exceeds 32");
        }
        byte[] legacySessionIdEcho = new byte[sessionIdLength];
        buffer.get(legacySessionIdEcho);
        short cipherSuiteCode = buffer.getShort();
        Arrays.stream(TlsConstants.CipherSuite.values()).filter(item -> item.value == cipherSuiteCode).findFirst().ifPresent(item -> {
            this.cipherSuite = item;
        });
        if (this.cipherSuite == null) {
            throw new DecodeErrorException("Unknown cipher suite (" + cipherSuiteCode + ")");
        }
        byte legacyCompressionMethod = buffer.get();
        if (legacyCompressionMethod != 0) {
            throw new DecodeErrorException("Legacy compression method must have the value 0");
        }
        this.extensions = EncryptedExtensions.parseExtensions(buffer, TlsConstants.HandshakeType.server_hello);
        this.raw = new byte[length];
        buffer.rewind();
        buffer.get(this.raw);
        return this;
    }

    @Override
    public byte[] getBytes() {
        return this.raw;
    }

    public byte[] getRandom() {
        return this.random;
    }

    public TlsConstants.CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }
}

